/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Recording;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class RecordingReader
extends Reader<Recording> {
    private String pathAccountSid;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateCreatedBefore;
    private ZonedDateTime dateCreatedAfter;
    private String callSid;
    private String conferenceSid;
    private Boolean includeSoftDeleted;
    private Integer pageSize;

    public RecordingReader() {
    }

    public RecordingReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public RecordingReader setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public RecordingReader setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public RecordingReader setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public RecordingReader setCallSid(String callSid) {
        this.callSid = callSid;
        return this;
    }

    public RecordingReader setConferenceSid(String conferenceSid) {
        this.conferenceSid = conferenceSid;
        return this;
    }

    public RecordingReader setIncludeSoftDeleted(Boolean includeSoftDeleted) {
        this.includeSoftDeleted = includeSoftDeleted;
        return this;
    }

    public RecordingReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Recording> read(TwilioRestClient client) {
        return new ResourceSet<Recording>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Recording> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Recordings.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Recording> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("recordings", response.getContent(), Recording.class, client.getObjectMapper());
    }

    @Override
    public Page<Recording> previousPage(Page<Recording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> nextPage(Page<Recording> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Recording> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.dateCreated != null) {
            request.addQueryParam("DateCreated", this.dateCreated.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        } else if (this.dateCreatedAfter != null || this.dateCreatedBefore != null) {
            request.addQueryDateTimeRange("DateCreated", this.dateCreatedAfter, this.dateCreatedBefore);
        }
        if (this.callSid != null) {
            request.addQueryParam("CallSid", this.callSid);
        }
        if (this.conferenceSid != null) {
            request.addQueryParam("ConferenceSid", this.conferenceSid);
        }
        if (this.includeSoftDeleted != null) {
            request.addQueryParam("IncludeSoftDeleted", this.includeSoftDeleted.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

