/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Address;

public class AddressUpdater
extends Updater<Address> {
    private String pathSid;
    private String pathAccountSid;
    private String friendlyName;
    private String customerName;
    private String street;
    private String city;
    private String region;
    private String postalCode;
    private Boolean emergencyEnabled;
    private Boolean autoCorrectAddress;
    private String streetSecondary;

    public AddressUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public AddressUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public AddressUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressUpdater setCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    public AddressUpdater setStreet(String street) {
        this.street = street;
        return this;
    }

    public AddressUpdater setCity(String city) {
        this.city = city;
        return this;
    }

    public AddressUpdater setRegion(String region) {
        this.region = region;
        return this;
    }

    public AddressUpdater setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public AddressUpdater setEmergencyEnabled(Boolean emergencyEnabled) {
        this.emergencyEnabled = emergencyEnabled;
        return this;
    }

    public AddressUpdater setAutoCorrectAddress(Boolean autoCorrectAddress) {
        this.autoCorrectAddress = autoCorrectAddress;
        return this;
    }

    public AddressUpdater setStreetSecondary(String streetSecondary) {
        this.streetSecondary = streetSecondary;
        return this;
    }

    @Override
    public Address update(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Addresses/{Sid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Address.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.customerName != null) {
            request.addPostParam("CustomerName", this.customerName);
        }
        if (this.street != null) {
            request.addPostParam("Street", this.street);
        }
        if (this.city != null) {
            request.addPostParam("City", this.city);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.postalCode != null) {
            request.addPostParam("PostalCode", this.postalCode);
        }
        if (this.emergencyEnabled != null) {
            request.addPostParam("EmergencyEnabled", this.emergencyEnabled.toString());
        }
        if (this.autoCorrectAddress != null) {
            request.addPostParam("AutoCorrectAddress", this.autoCorrectAddress.toString());
        }
        if (this.streetSecondary != null) {
            request.addPostParam("StreetSecondary", this.streetSecondary);
        }
    }
}

