/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpClient;
import com.twilio.http.HttpMethod;
import com.twilio.http.HttpUtility;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.ValidationInterceptor;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class ValidationClient
extends HttpClient {
    private final org.apache.http.client.HttpClient client;

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey) {
        this(accountSid, credentialSid, signingKey, privateKey, DEFAULT_REQUEST_CONFIG);
    }

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey, SignatureAlgorithm algorithm) {
        this(accountSid, credentialSid, signingKey, privateKey, DEFAULT_REQUEST_CONFIG, algorithm);
    }

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey, RequestConfig requestConfig) {
        this(accountSid, credentialSid, signingKey, privateKey, requestConfig, DEFAULT_SOCKET_CONFIG, SignatureAlgorithm.RS256);
    }

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey, RequestConfig requestConfig, SignatureAlgorithm algorithm) {
        this(accountSid, credentialSid, signingKey, privateKey, requestConfig, DEFAULT_SOCKET_CONFIG, algorithm);
    }

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey, RequestConfig requestConfig, SocketConfig socketConfig) {
        this(accountSid, credentialSid, signingKey, privateKey, requestConfig, socketConfig, SignatureAlgorithm.RS256);
    }

    public ValidationClient(String accountSid, String credentialSid, String signingKey, PrivateKey privateKey, RequestConfig requestConfig, SocketConfig socketConfig, SignatureAlgorithm algorithm) {
        List<BasicHeader> headers = Arrays.asList(new BasicHeader("X-Twilio-Client", "java-10.1.3"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(100);
        this.client = HttpClientBuilder.create().setConnectionManager(connectionManager).setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers).addInterceptorLast(new ValidationInterceptor(accountSid, credentialSid, signingKey, privateKey, algorithm)).setRedirectStrategy(this.getRedirectStrategy()).build();
    }

    @Override
    public Response makeRequest(Request request) {
        HttpMethod method;
        RequestBuilder builder = RequestBuilder.create(request.getMethod().toString()).setUri(request.constructURL().toString()).setVersion(HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        if ((method = request.getMethod()) == HttpMethod.POST) {
            if (request.getContentType() == null) {
                request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
            }
            if (EnumConstants.ContentType.JSON.getValue().equals(request.getContentType().getValue())) {
                StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
                builder.setEntity(entity);
                builder.addHeader("Content-Type", EnumConstants.ContentType.JSON.getValue());
            } else {
                builder.addHeader("Content-Type", EnumConstants.ContentType.FORM_URLENCODED.getValue());
                for (Map.Entry entry : request.getPostParams().entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        builder.addParameter((String)entry.getKey(), value);
                    }
                }
            }
        }
        builder.addHeader("User-Agent", HttpUtility.getUserAgentString(request.getUserAgentExtensions()));
        try {
            HttpResponse response = this.client.execute(builder.build());
            return new Response(response.getEntity() == null ? null : response.getEntity().getContent(), response.getStatusLine().getStatusCode(), response.getAllHeaders());
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

