/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpClient;
import com.twilio.http.HttpMethod;
import com.twilio.http.HttpUtility;
import com.twilio.http.Request;
import com.twilio.http.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class NetworkHttpClient
extends HttpClient {
    protected final org.apache.http.client.HttpClient client;
    private boolean isCustomClient;

    public NetworkHttpClient() {
        this(DEFAULT_REQUEST_CONFIG);
    }

    public NetworkHttpClient(RequestConfig requestConfig) {
        this(requestConfig, DEFAULT_SOCKET_CONFIG);
    }

    public NetworkHttpClient(RequestConfig requestConfig, SocketConfig socketConfig) {
        List<BasicHeader> headers = Arrays.asList(new BasicHeader("X-Twilio-Client", "java-10.1.3"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        String googleAppEngineVersion = System.getProperty("com.google.appengine.runtime.version");
        boolean isGoogleAppEngine = googleAppEngineVersion != null && !googleAppEngineVersion.isEmpty();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (!isGoogleAppEngine) {
            clientBuilder.useSystemProperties();
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(100);
        this.client = clientBuilder.setConnectionManager(connectionManager).setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers).setRedirectStrategy(this.getRedirectStrategy()).build();
    }

    public NetworkHttpClient(HttpClientBuilder clientBuilder) {
        List<BasicHeader> headers = Arrays.asList(new BasicHeader("X-Twilio-Client", "java-10.1.3"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        this.isCustomClient = true;
        this.client = clientBuilder.setDefaultHeaders(headers).setRedirectStrategy(this.getRedirectStrategy()).build();
    }

    @Override
    public Response makeRequest(Request request) {
        Response response;
        HttpMethod method = request.getMethod();
        RequestBuilder builder = RequestBuilder.create(method.toString()).setUri(request.constructURL().toString()).setVersion(HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        for (Map.Entry<String, List<String>> entry : request.getHeaderParams().entrySet()) {
            for (String value : entry.getValue()) {
                builder.addHeader(entry.getKey(), value);
            }
        }
        if (method == HttpMethod.POST) {
            if (request.getContentType() == null) {
                request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
            }
            if (EnumConstants.ContentType.JSON.getValue().equals(request.getContentType().getValue())) {
                StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
                builder.setEntity(entity);
                builder.addHeader("Content-Type", EnumConstants.ContentType.JSON.getValue());
            } else {
                builder.addHeader("Content-Type", EnumConstants.ContentType.FORM_URLENCODED.getValue());
                for (Map.Entry entry : request.getPostParams().entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        builder.addParameter((String)entry.getKey(), value);
                    }
                }
            }
        }
        builder.addHeader("User-Agent", HttpUtility.getUserAgentString(request.getUserAgentExtensions(), this.isCustomClient));
        HttpResponse response2 = null;
        try {
            response2 = this.client.execute(builder.build());
            HttpEntity httpEntity = response2.getEntity();
            response = new Response(httpEntity == null ? null : new BufferedHttpEntity(httpEntity).getContent(), response2.getStatusLine().getStatusCode(), response2.getAllHeaders());
        }
        catch (IOException iOException) {
            try {
                throw new ApiException(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response2);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly(response2);
        return response;
    }
}

