/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.converter;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class DateConverter {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String RFC2822_DATE_TIME = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter RFC2822_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z").withLocale(new Locale("en_US"));
    private static final DateTimeFormatter ISO8601_DATE_TIME_FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME;

    public static ZonedDateTime rfc2822DateTimeFromString(String dateTimeString) {
        try {
            return ZonedDateTime.parse(dateTimeString, RFC2822_DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ZonedDateTime iso8601DateTimeFromString(String dateTimeString) {
        try {
            return ZonedDateTime.parse(dateTimeString, ISO8601_DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDate localDateFromString(String dateString) {
        try {
            return LocalDate.parse(dateString, DATE_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dateStringFromLocalDate(LocalDate date) {
        try {
            return date.format(DATE_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }
}

