/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl.cloud;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.cloud.CloudEventDao;
import org.thingsboard.server.dao.cloud.TsKvCloudEventDao;
import org.thingsboard.server.dao.sqlts.insert.sql.SqlPartitioningRepository;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@TbCoreComponent
@Service
@ConditionalOnExpression(value="${sql.ttl.cloud_events.enabled:true} && ${sql.ttl.cloud_events.cloud_events_ttl:0} > 0 && '${queue.type:null}' != 'kafka'")
public class CloudEventsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventsCleanUpService.class);
    public static final String RANDOM_DELAY_INTERVAL_MS_EXPRESSION = "#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.cloud_events.execution_interval_ms})}";
    @Value(value="${sql.ttl.cloud_events.cloud_events_ttl}")
    private long ttl;
    @Value(value="${sql.cloud_events.partition_size:24}")
    private int partitionSizeInHours;
    @Value(value="${sql.ttl.cloud_events.enabled}")
    private boolean ttlTaskExecutionEnabled;
    private final CloudEventDao cloudEventDao;
    private final TsKvCloudEventDao tsKvCloudEventDao;
    private final SqlPartitioningRepository partitioningRepository;

    public CloudEventsCleanUpService(PartitionService partitionService, CloudEventDao cloudEventDao, TsKvCloudEventDao tsKvCloudEventDao, SqlPartitioningRepository partitioningRepository) {
        super(partitionService);
        this.cloudEventDao = cloudEventDao;
        this.tsKvCloudEventDao = tsKvCloudEventDao;
        this.partitioningRepository = partitioningRepository;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.cloud_events.execution_interval_ms})}", fixedDelayString="${sql.ttl.cloud_events.execution_interval_ms}")
    public void cleanUp() {
        long cloudEventsExpTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.ttl);
        if (this.ttlTaskExecutionEnabled && this.isSystemTenantPartitionMine()) {
            this.cloudEventDao.cleanupEvents(cloudEventsExpTime);
            this.tsKvCloudEventDao.cleanupEvents(cloudEventsExpTime);
        } else {
            this.partitioningRepository.cleanupPartitionsCache("cloud_event", cloudEventsExpTime, TimeUnit.HOURS.toMillis(this.partitionSizeInHours));
            this.partitioningRepository.cleanupPartitionsCache("ts_kv_cloud_event", cloudEventsExpTime, TimeUnit.HOURS.toMillis(this.partitionSizeInHours));
        }
    }
}

