/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.EntityVersionsDiff;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.executors.VersionControlExecutor;
import org.thingsboard.server.service.sync.vc.DefaultEntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.GitVersionControlQueueService;
import org.thingsboard.server.service.sync.vc.data.ClearRepositoryGitRequest;
import org.thingsboard.server.service.sync.vc.data.CommitGitRequest;
import org.thingsboard.server.service.sync.vc.data.EntitiesContentGitRequest;
import org.thingsboard.server.service.sync.vc.data.EntityContentGitRequest;
import org.thingsboard.server.service.sync.vc.data.FileContentGitRequest;
import org.thingsboard.server.service.sync.vc.data.ListBranchesGitRequest;
import org.thingsboard.server.service.sync.vc.data.ListEntitiesGitRequest;
import org.thingsboard.server.service.sync.vc.data.ListVersionsGitRequest;
import org.thingsboard.server.service.sync.vc.data.PendingGitRequest;
import org.thingsboard.server.service.sync.vc.data.VersionsDiffGitRequest;
import org.thingsboard.server.service.sync.vc.data.VoidGitRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@TbCoreComponent
@Service
public class DefaultGitVersionControlQueueService
implements GitVersionControlQueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGitVersionControlQueueService.class);
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbClusterService clusterService;
    private final DefaultEntitiesVersionControlService entitiesVersionControlService;
    private final SchedulerComponent scheduler;
    private final VersionControlExecutor executor;
    private final SecretConfigurationService secretConfigurationService;
    private final Map<UUID, PendingGitRequest<?>> pendingRequestMap = new ConcurrentHashMap();
    private final Map<UUID, HashMap<Integer, String[]>> chunkedMsgs = new ConcurrentHashMap();
    @Value(value="${queue.vc.request-timeout:180000}")
    private int requestTimeout;
    @Value(value="${queue.vc.msg-chunk-size:250000}")
    private int msgChunkSize;

    public DefaultGitVersionControlQueueService(TbServiceInfoProvider serviceInfoProvider, TbClusterService clusterService, @Lazy DefaultEntitiesVersionControlService entitiesVersionControlService, SchedulerComponent scheduler, VersionControlExecutor executor, SecretConfigurationService secretConfigurationService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.clusterService = clusterService;
        this.entitiesVersionControlService = entitiesVersionControlService;
        this.scheduler = scheduler;
        this.executor = executor;
        this.secretConfigurationService = secretConfigurationService;
    }

    public ListenableFuture<CommitGitRequest> prepareCommit(User user, VersionCreateRequest request) {
        log.debug("Executing prepareCommit [{}][{}]", (Object)request.getBranch(), (Object)request.getVersionName());
        CommitGitRequest commit = new CommitGitRequest(user.getTenantId(), request);
        ListenableFuture future = this.registerAndSend((PendingGitRequest)commit, builder -> builder.setCommitRequest(this.buildCommitRequest(commit).setPrepareMsg(DefaultGitVersionControlQueueService.getCommitPrepareMsg((User)user, (VersionCreateRequest)request)).build()).build());
        return Futures.transform((ListenableFuture)future, f -> commit, (Executor)this.executor);
    }

    public ListenableFuture<Void> addToCommit(CommitGitRequest commit, EntityExportData<ExportableEntity<EntityId>> entityData) {
        return this.addToCommit(commit, Collections.emptyList(), entityData);
    }

    public ListenableFuture<Void> addToCommit(CommitGitRequest commit, List<CustomerId> parents, EntityExportData<? extends ExportableEntity<? extends EntityId>> entityData) {
        String path;
        if (EntityType.ENTITY_GROUP.equals((Object)entityData.getEntityType())) {
            EntityGroup group = (EntityGroup)entityData.getEntity();
            path = this.getHierarchyPath(parents) + DefaultGitVersionControlQueueService.getGroupPath((EntityGroup)group);
        } else {
            path = this.getHierarchyPath(parents) + DefaultGitVersionControlQueueService.getRelativePath((EntityType)entityData.getEntityType(), (EntityId)entityData.getExternalId());
        }
        log.debug("Executing addToCommit [{}][{}][{}]", new Object[]{entityData.getEntityType(), entityData.getEntity().getId(), commit.getRequestId()});
        String entityDataJson = JacksonUtil.toPrettyString((Object)entityData.sort());
        Iterable entityDataChunks = StringUtils.split((String)entityDataJson, (int)this.msgChunkSize);
        String chunkedMsgId = UUID.randomUUID().toString();
        int chunksCount = Iterables.size((Iterable)entityDataChunks);
        AtomicInteger chunkIndex = new AtomicInteger();
        ArrayList futures = new ArrayList();
        entityDataChunks.forEach(chunk -> {
            log.trace("[{}] sending chunk {} for 'addToCommit'", (Object)chunkedMsgId, (Object)chunkIndex.get());
            ListenableFuture chunkFuture = this.registerAndSend((PendingGitRequest)commit, builder -> builder.setCommitRequest(this.buildCommitRequest(commit).setAddMsg(TransportProtos.AddMsg.newBuilder().setRelativePath(path).setEntityDataJsonChunk(chunk).setChunkedMsgId(chunkedMsgId).setChunkIndex(chunkIndex.getAndIncrement()).setChunksCount(chunksCount)).build()).build());
            futures.add(chunkFuture);
        });
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), r -> {
            log.trace("[{}] sent all chunks for 'addToCommit'", (Object)chunkedMsgId);
            return null;
        }, (Executor)this.executor);
    }

    public ListenableFuture<Void> addToCommit(CommitGitRequest commit, List<CustomerId> parents, EntityType type, EntityId groupExternalId, List<EntityId> groupEntityIds) {
        String path = this.getHierarchyPath(parents) + DefaultGitVersionControlQueueService.getGroupEntitiesListPath((EntityType)type, (EntityId)groupExternalId);
        String entityDataJson = JacksonUtil.toPrettyString(groupEntityIds);
        return this.registerAndSend((PendingGitRequest)commit, builder -> builder.setCommitRequest(this.buildCommitRequest(commit).setAddMsg(TransportProtos.AddMsg.newBuilder().setRelativePath(path).setEntityDataJsonChunk(entityDataJson).setChunkedMsgId(UUID.randomUUID().toString()).setChunksCount(1).setChunkIndex(0).build())).build());
    }

    public ListenableFuture<Void> deleteAll(CommitGitRequest commit, EntityType entityType) {
        log.debug("Executing deleteAll [{}][{}][{}]", new Object[]{commit.getTenantId(), entityType, commit.getRequestId()});
        return this.registerAndSend((PendingGitRequest)commit, builder -> builder.setCommitRequest(this.buildCommitRequest(commit).setDeleteMsg(TransportProtos.DeleteMsg.newBuilder().setFolder(entityType.name().toLowerCase()).setRecursively(true).build())).build());
    }

    public ListenableFuture<VersionCreationResult> push(CommitGitRequest commit) {
        log.debug("Executing push [{}][{}]", (Object)commit.getTenantId(), (Object)commit.getRequestId());
        return this.sendRequest((PendingGitRequest)commit, builder -> builder.setCommitRequest(this.buildCommitRequest(commit).setPushMsg(TransportProtos.PushMsg.getDefaultInstance())));
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, PageLink pageLink) {
        return this.listVersions(tenantId, this.applyPageLinkParameters(TransportProtos.ListVersionsRequestMsg.newBuilder().setBranchName(branch), pageLink).build());
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, EntityType entityType, PageLink pageLink) {
        return this.listVersions(tenantId, this.applyPageLinkParameters(TransportProtos.ListVersionsRequestMsg.newBuilder().setBranchName(branch).setEntityType(entityType.name()), pageLink).build());
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, List<CustomerId> hierarchy, EntityType entityType, EntityId groupId, PageLink pageLink) {
        return this.listVersions(tenantId, branch, this.getHierarchyPath(hierarchy) + "groups/", entityType, groupId.getId(), pageLink);
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, List<CustomerId> hierarchy, EntityId entityId, PageLink pageLink) {
        return this.listVersions(tenantId, branch, this.getHierarchyPath(hierarchy), entityId.getEntityType(), entityId.getId(), pageLink);
    }

    private ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, String path, EntityType entityType, UUID entityUuid, PageLink pageLink) {
        return this.listVersions(tenantId, this.applyPageLinkParameters(TransportProtos.ListVersionsRequestMsg.newBuilder().setBranchName(branch).setPath(path).setEntityType(entityType.name()).setEntityIdMSB(entityUuid.getMostSignificantBits()).setEntityIdLSB(entityUuid.getLeastSignificantBits()), pageLink).build());
    }

    private TransportProtos.ListVersionsRequestMsg.Builder applyPageLinkParameters(TransportProtos.ListVersionsRequestMsg.Builder builder, PageLink pageLink) {
        builder.setPageSize(pageLink.getPageSize()).setPage(pageLink.getPage());
        if (pageLink.getTextSearch() != null) {
            builder.setTextSearch(pageLink.getTextSearch());
        }
        if (pageLink.getSortOrder() != null) {
            if (pageLink.getSortOrder().getProperty() != null) {
                builder.setSortProperty(pageLink.getSortOrder().getProperty());
            }
            if (pageLink.getSortOrder().getDirection() != null) {
                builder.setSortDirection(pageLink.getSortOrder().getDirection().name());
            }
        }
        return builder;
    }

    private ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, TransportProtos.ListVersionsRequestMsg requestMsg) {
        ListVersionsGitRequest request = new ListVersionsGitRequest(tenantId);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setListVersionRequest(requestMsg));
    }

    public ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId tenantId, String versionId, EntityType entityType) {
        return this.listEntitiesAtVersion(tenantId, TransportProtos.ListEntitiesRequestMsg.newBuilder().setVersionId(versionId).setEntityType(entityType.name()).build());
    }

    public ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId tenantId, String versionId) {
        return this.listEntitiesAtVersion(tenantId, TransportProtos.ListEntitiesRequestMsg.newBuilder().setVersionId(versionId).build());
    }

    private ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId tenantId, TransportProtos.ListEntitiesRequestMsg requestMsg) {
        ListEntitiesGitRequest request = new ListEntitiesGitRequest(tenantId);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setListEntitiesRequest(requestMsg));
    }

    public ListenableFuture<List<BranchInfo>> listBranches(TenantId tenantId) {
        ListBranchesGitRequest request = new ListBranchesGitRequest(tenantId);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setListBranchesRequest(TransportProtos.ListBranchesRequestMsg.newBuilder().build()));
    }

    public ListenableFuture<List<EntityVersionsDiff>> getVersionsDiff(TenantId tenantId, EntityType entityType, EntityId externalId, String versionId1, String versionId2) {
        String path = entityType != null ? DefaultGitVersionControlQueueService.getRelativePath((EntityType)entityType, (EntityId)externalId) : "";
        VersionsDiffGitRequest request = new VersionsDiffGitRequest(tenantId, path, versionId1, versionId2);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setVersionsDiffRequest(TransportProtos.VersionsDiffRequestMsg.newBuilder().setPath(request.getPath()).setVersionId1(request.getVersionId1()).setVersionId2(request.getVersionId2()).build()));
    }

    public ListenableFuture<EntityExportData> getEntity(TenantId tenantId, String versionId, List<CustomerId> hierarchy, EntityId entityId) {
        log.debug("Executing getEntity [{}][{}][{}]", new Object[]{tenantId, versionId, entityId});
        EntityContentGitRequest request = new EntityContentGitRequest(tenantId, versionId, entityId);
        this.chunkedMsgs.put(request.getRequestId(), new HashMap());
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setEntityContentRequest(TransportProtos.EntityContentRequestMsg.newBuilder().setVersionId(versionId).setPath(this.getHierarchyPath(hierarchy)).setEntityType(entityId.getEntityType().name()).setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits())).build());
    }

    public ListenableFuture<List<EntityId>> getGroupEntityIds(TenantId tenantId, String versionId, List<CustomerId> ownerIds, EntityType type, EntityId externalId) {
        String path = this.getHierarchyPath(ownerIds) + "groups/" + type.name().toLowerCase() + "/" + String.valueOf(externalId.getId()) + "_entities.json";
        FileContentGitRequest request = new FileContentGitRequest(tenantId, versionId, path);
        ListenableFuture future = this.sendRequest((PendingGitRequest)request, builder -> builder.setEntityContentRequest(TransportProtos.EntityContentRequestMsg.newBuilder().setVersionId(versionId).setPath(path)).build());
        return Futures.transform((ListenableFuture)future, data -> (List)JacksonUtil.fromString((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */), (Executor)this.executor);
    }

    public ListenableFuture<EntityExportData> getEntityGroup(TenantId tenantId, String versionId, List<CustomerId> hierarchy, EntityType groupType, EntityId groupId) {
        EntityContentGitRequest request = new EntityContentGitRequest(tenantId, versionId, groupId);
        this.chunkedMsgs.put(request.getRequestId(), new LinkedHashMap());
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setEntityContentRequest(TransportProtos.EntityContentRequestMsg.newBuilder().setVersionId(versionId).setPath(this.getHierarchyPath(hierarchy) + "groups/").setEntityType(groupType.name()).setEntityIdMSB(groupId.getId().getMostSignificantBits()).setEntityIdLSB(groupId.getId().getLeastSignificantBits())).build());
    }

    private <T> ListenableFuture<Void> registerAndSend(PendingGitRequest<T> request, Function<TransportProtos.ToVersionControlServiceMsg.Builder, TransportProtos.ToVersionControlServiceMsg> enrichFunction) {
        return this.registerAndSend(request, enrichFunction, null);
    }

    private <T> ListenableFuture<Void> registerAndSend(PendingGitRequest<T> request, Function<TransportProtos.ToVersionControlServiceMsg.Builder, TransportProtos.ToVersionControlServiceMsg> enrichFunction, RepositorySettings settings) {
        if (!request.getFuture().isDone()) {
            this.pendingRequestMap.putIfAbsent(request.getRequestId(), request);
            TransportProtos.ToVersionControlServiceMsg requestBody = enrichFunction.apply(this.newRequestProto(request, settings));
            log.trace("[{}][{}] PUSHING request: {}", new Object[]{request.getTenantId(), request.getRequestId(), requestBody});
            SettableFuture submitFuture = SettableFuture.create();
            this.clusterService.pushMsgToVersionControl(request.getTenantId(), requestBody, (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
            if (request.getTimeoutTask() == null) {
                request.setTimeoutTask(this.scheduler.schedule(() -> this.processTimeout(request.getRequestId()), (long)this.requestTimeout, TimeUnit.MILLISECONDS));
            }
            return submitFuture;
        }
        try {
            request.getFuture().get();
            throw new RuntimeException("Failed to process the request");
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            throw new RuntimeException(cause.getMessage(), cause);
        }
    }

    private <T> ListenableFuture<T> sendRequest(PendingGitRequest<T> request, Consumer<TransportProtos.ToVersionControlServiceMsg.Builder> enrichFunction) {
        return this.sendRequest(request, enrichFunction, null);
    }

    private <T> ListenableFuture<T> sendRequest(PendingGitRequest<T> request, Consumer<TransportProtos.ToVersionControlServiceMsg.Builder> enrichFunction, RepositorySettings settings) {
        ListenableFuture submitFuture = this.registerAndSend(request, builder -> {
            enrichFunction.accept((TransportProtos.ToVersionControlServiceMsg.Builder)builder);
            return builder.build();
        }, settings);
        return Futures.transformAsync((ListenableFuture)submitFuture, input -> request.getFuture(), (Executor)this.executor);
    }

    public ListenableFuture<List<EntityExportData>> getEntities(TenantId tenantId, String versionId, List<CustomerId> hierarchy, EntityType entityType, boolean groups, boolean recursive, int offset, int limit) {
        log.debug("Executing getEntities [{}][{}][{}]", new Object[]{tenantId, versionId, entityType});
        EntitiesContentGitRequest request = new EntitiesContentGitRequest(tenantId, versionId, entityType);
        this.chunkedMsgs.put(request.getRequestId(), new HashMap());
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setEntitiesContentRequest(TransportProtos.EntitiesContentRequestMsg.newBuilder().setVersionId(versionId).setPath(this.getHierarchyPath(hierarchy)).setEntityType(entityType.name()).setRecursive(recursive).setGroups(groups).setOffset(offset).setLimit(limit)).build());
    }

    public ListenableFuture<List<EntityExportData>> getEntities(TenantId tenantId, String versionId, List<CustomerId> hierarchy, EntityType entityType, List<UUID> ids) {
        EntitiesContentGitRequest request = new EntitiesContentGitRequest(tenantId, versionId, entityType);
        List idProtos = ids.stream().map(id -> TransportProtos.EntityIdProto.newBuilder().setEntityIdMSB(id.getMostSignificantBits()).setEntityIdLSB(id.getLeastSignificantBits()).build()).collect(Collectors.toList());
        this.chunkedMsgs.put(request.getRequestId(), new LinkedHashMap());
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setEntitiesContentRequest(TransportProtos.EntitiesContentRequestMsg.newBuilder().setVersionId(versionId).setPath(this.getHierarchyPath(hierarchy)).setEntityType(entityType.name()).addAllIds((Iterable)idProtos)));
    }

    public ListenableFuture<Void> initRepository(TenantId tenantId, RepositorySettings settings) {
        log.debug("Executing initRepository [{}]", (Object)tenantId);
        VoidGitRequest request = new VoidGitRequest(tenantId);
        RepositorySettings repository = (RepositorySettings)this.secretConfigurationService.replaceSecretUsages(tenantId, (Object)settings, RepositorySettings.class);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setInitRepositoryRequest(TransportProtos.GenericRepositoryRequestMsg.getDefaultInstance()), repository);
    }

    public ListenableFuture<Void> testRepository(TenantId tenantId, RepositorySettings settings) {
        log.debug("Executing testRepository [{}]", (Object)tenantId);
        VoidGitRequest request = new VoidGitRequest(tenantId);
        RepositorySettings repository = (RepositorySettings)this.secretConfigurationService.replaceSecretUsages(tenantId, (Object)settings, RepositorySettings.class);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setTestRepositoryRequest(TransportProtos.GenericRepositoryRequestMsg.getDefaultInstance()), repository);
    }

    public ListenableFuture<Void> clearRepository(TenantId tenantId) {
        log.debug("Executing clearRepository [{}]", (Object)tenantId);
        ClearRepositoryGitRequest request = new ClearRepositoryGitRequest(tenantId);
        return this.sendRequest((PendingGitRequest)request, builder -> builder.setClearRepositoryRequest(TransportProtos.GenericRepositoryRequestMsg.getDefaultInstance()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processResponse(TransportProtos.VersionControlResponseMsg vcResponseMsg) {
        UUID requestId = new UUID(vcResponseMsg.getRequestIdMSB(), vcResponseMsg.getRequestIdLSB());
        PendingGitRequest request = (PendingGitRequest)this.pendingRequestMap.get(requestId);
        if (request == null) {
            log.debug("[{}] received stale response: {}", (Object)requestId, (Object)vcResponseMsg);
            return;
        }
        log.debug("[{}] processing response: {}", (Object)requestId, (Object)vcResponseMsg);
        SettableFuture future = request.getFuture();
        boolean completed = true;
        if (!StringUtils.isEmpty((String)vcResponseMsg.getError())) {
            future.setException((Throwable)new RuntimeException(vcResponseMsg.getError()));
        } else {
            try {
                if (vcResponseMsg.hasGenericResponse()) {
                    future.set(null);
                } else if (vcResponseMsg.hasCommitResponse()) {
                    TransportProtos.CommitResponseMsg commitResponse = vcResponseMsg.getCommitResponse();
                    VersionCreationResult commitResult = new VersionCreationResult();
                    if (commitResponse.getTs() > 0L) {
                        commitResult.setVersion(new EntityVersion(commitResponse.getTs(), commitResponse.getCommitId(), commitResponse.getName(), commitResponse.getAuthor()));
                    }
                    commitResult.setAdded(commitResponse.getAdded());
                    commitResult.setRemoved(commitResponse.getRemoved());
                    commitResult.setModified(commitResponse.getModified());
                    commitResult.setDone(true);
                    ((CommitGitRequest)request).getFuture().set((Object)commitResult);
                } else if (vcResponseMsg.hasListBranchesResponse()) {
                    TransportProtos.ListBranchesResponseMsg listBranchesResponse = vcResponseMsg.getListBranchesResponse();
                    ((ListBranchesGitRequest)request).getFuture().set(listBranchesResponse.getBranchesList().stream().map(arg_0 -> this.getBranchInfo(arg_0)).collect(Collectors.toList()));
                } else if (vcResponseMsg.hasListEntitiesResponse()) {
                    TransportProtos.ListEntitiesResponseMsg listEntitiesResponse = vcResponseMsg.getListEntitiesResponse();
                    ((ListEntitiesGitRequest)request).getFuture().set(listEntitiesResponse.getEntitiesList().stream().map(arg_0 -> this.getVersionedEntityInfo(arg_0)).collect(Collectors.toList()));
                } else if (vcResponseMsg.hasListVersionsResponse()) {
                    TransportProtos.ListVersionsResponseMsg listVersionsResponse = vcResponseMsg.getListVersionsResponse();
                    ((ListVersionsGitRequest)request).getFuture().set((Object)this.toPageData(listVersionsResponse));
                } else if (vcResponseMsg.hasEntityContentResponse()) {
                    if (request instanceof EntityContentGitRequest) {
                        TransportProtos.EntityContentResponseMsg responseMsg = vcResponseMsg.getEntityContentResponse();
                        log.trace("Received chunk {} for 'getEntity'", (Object)responseMsg.getChunkIndex());
                        Optional joined = this.joinChunks(requestId, responseMsg, 0, 1);
                        if (!joined.isPresent()) return;
                        log.trace("Collected all chunks for 'getEntity'");
                        ((EntityContentGitRequest)request).getFuture().set((Object)((EntityExportData)((List)joined.get()).get(0)));
                    } else {
                        if (!(request instanceof FileContentGitRequest)) throw new RuntimeException("Unsupported request: " + String.valueOf(request.getClass()));
                        String data = vcResponseMsg.getEntityContentResponse().getData();
                        ((FileContentGitRequest)request).getFuture().set((Object)data);
                    }
                } else if (vcResponseMsg.hasEntitiesContentResponse()) {
                    TransportProtos.EntitiesContentResponseMsg responseMsg = vcResponseMsg.getEntitiesContentResponse();
                    TransportProtos.EntityContentResponseMsg item = responseMsg.getItem();
                    if (responseMsg.getItemsCount() > 0) {
                        Optional joined = this.joinChunks(requestId, item, responseMsg.getItemIdx(), responseMsg.getItemsCount());
                        if (!joined.isPresent()) return;
                        ((EntitiesContentGitRequest)request).getFuture().set((Object)((List)joined.get()));
                    } else {
                        ((EntitiesContentGitRequest)request).getFuture().set(Collections.emptyList());
                    }
                } else if (vcResponseMsg.hasVersionsDiffResponse()) {
                    TransportProtos.VersionsDiffResponseMsg diffResponse = vcResponseMsg.getVersionsDiffResponse();
                    List entityVersionsDiffList = diffResponse.getDiffList().stream().map(diff -> EntityVersionsDiff.builder().externalId(EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)diff.getEntityType()), (UUID)new UUID(diff.getEntityIdMSB(), diff.getEntityIdLSB()))).entityDataAtVersion1(StringUtils.isNotEmpty((String)diff.getEntityDataAtVersion1()) ? this.toData(diff.getEntityDataAtVersion1()) : null).entityDataAtVersion2(StringUtils.isNotEmpty((String)diff.getEntityDataAtVersion2()) ? this.toData(diff.getEntityDataAtVersion2()) : null).rawDiff(diff.getRawDiff()).build()).collect(Collectors.toList());
                    ((VersionsDiffGitRequest)request).getFuture().set(entityVersionsDiffList);
                }
            }
            catch (Exception e) {
                future.setException((Throwable)e);
                throw e;
            }
        }
        if (!completed) return;
        this.removePendingRequest(requestId);
    }

    private Optional<List<EntityExportData>> joinChunks(UUID requestId, TransportProtos.EntityContentResponseMsg responseMsg, int itemIdx, int expectedMsgCount) {
        HashMap chunksMap = (HashMap)this.chunkedMsgs.get(requestId);
        if (chunksMap == null) {
            return Optional.empty();
        }
        String[] msgChunks = chunksMap.computeIfAbsent(itemIdx, id -> new String[responseMsg.getChunksCount()]);
        msgChunks[responseMsg.getChunkIndex()] = responseMsg.getData();
        if (chunksMap.size() == expectedMsgCount && chunksMap.values().stream().allMatch(chunks -> CollectionsUtil.countNonNull((Object[])chunks) == ((String[])chunks).length)) {
            return Optional.of(chunksMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).map(chunks -> String.join((CharSequence)"", chunks)).map(arg_0 -> this.toData(arg_0)).collect(Collectors.toList()));
        }
        return Optional.empty();
    }

    private void processTimeout(UUID requestId) {
        PendingGitRequest pendingRequest = this.removePendingRequest(requestId);
        if (pendingRequest != null) {
            log.debug("[{}] request timed out ({} ms}", (Object)requestId, (Object)this.requestTimeout);
            pendingRequest.getFuture().setException((Throwable)new TimeoutException("Request timed out"));
        }
    }

    private PendingGitRequest<?> removePendingRequest(UUID requestId) {
        PendingGitRequest pendingRequest = (PendingGitRequest)this.pendingRequestMap.remove(requestId);
        if (pendingRequest != null && pendingRequest.getTimeoutTask() != null) {
            pendingRequest.getTimeoutTask().cancel(true);
            pendingRequest.setTimeoutTask(null);
        }
        this.chunkedMsgs.remove(requestId);
        return pendingRequest;
    }

    private PageData<EntityVersion> toPageData(TransportProtos.ListVersionsResponseMsg listVersionsResponse) {
        List listVersions = listVersionsResponse.getVersionsList().stream().map(arg_0 -> this.getEntityVersion(arg_0)).collect(Collectors.toList());
        return new PageData(listVersions, listVersionsResponse.getTotalPages(), listVersionsResponse.getTotalElements(), listVersionsResponse.getHasNext());
    }

    private EntityVersion getEntityVersion(TransportProtos.EntityVersionProto proto) {
        return new EntityVersion(proto.getTs(), proto.getId(), proto.getName(), proto.getAuthor());
    }

    private VersionedEntityInfo getVersionedEntityInfo(TransportProtos.VersionedEntityInfoProto proto) {
        return new VersionedEntityInfo(EntityIdFactory.getByTypeAndUuid((String)proto.getEntityType(), (UUID)new UUID(proto.getEntityIdMSB(), proto.getEntityIdLSB())));
    }

    private BranchInfo getBranchInfo(TransportProtos.BranchInfoProto proto) {
        return new BranchInfo(proto.getName(), proto.getIsDefault());
    }

    private EntityExportData toData(String data) {
        return (EntityExportData)JacksonUtil.fromString((String)data, EntityExportData.class);
    }

    private String getHierarchyPath(List<CustomerId> parents) {
        StringBuilder path = new StringBuilder();
        for (EntityId entityId : parents) {
            path.append("hierarchy/").append(entityId.getId()).append("/");
        }
        return path.toString();
    }

    private static String getGroupEntitiesListPath(EntityType groupType, EntityId groupExternalId) {
        return "groups/" + groupType.name().toLowerCase() + "/" + String.valueOf(groupExternalId) + "_entities.json";
    }

    private static String getGroupPath(EntityGroup group) {
        return "groups/" + group.getType().name().toLowerCase() + "/" + String.valueOf(group.getExternalId() != null ? group.getExternalId() : group.getId()) + ".json";
    }

    private static String getRelativePath(EntityType entityType, EntityId entityId) {
        Object path = entityType.name().toLowerCase();
        if (entityId != null) {
            path = (String)path + "/" + String.valueOf(entityId) + ".json";
        }
        return path;
    }

    private static TransportProtos.PrepareMsg getCommitPrepareMsg(User user, VersionCreateRequest request) {
        return TransportProtos.PrepareMsg.newBuilder().setCommitMsg(request.getVersionName()).setBranchName(request.getBranch()).setAuthorName(DefaultGitVersionControlQueueService.getAuthorName((User)user)).setAuthorEmail(user.getEmail()).build();
    }

    private static String getAuthorName(User user) {
        ArrayList<String> parts = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)user.getFirstName())) {
            parts.add(user.getFirstName());
        }
        if (StringUtils.isNotBlank((String)user.getLastName())) {
            parts.add(user.getLastName());
        }
        if (parts.isEmpty()) {
            parts.add(user.getName());
        }
        return String.join((CharSequence)" ", parts);
    }

    private TransportProtos.ToVersionControlServiceMsg.Builder newRequestProto(PendingGitRequest<?> request, RepositorySettings settings) {
        TenantId tenantId = request.getTenantId();
        UUID requestId = request.getRequestId();
        TransportProtos.ToVersionControlServiceMsg.Builder builder = TransportProtos.ToVersionControlServiceMsg.newBuilder().setNodeId(this.serviceInfoProvider.getServiceId()).setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setRequestIdMSB(requestId.getMostSignificantBits()).setRequestIdLSB(requestId.getLeastSignificantBits());
        RepositorySettings vcSettings = settings;
        if (vcSettings == null && request.requiresSettings()) {
            vcSettings = this.entitiesVersionControlService.getVersionControlSettings(tenantId);
        }
        if (vcSettings != null) {
            vcSettings = (RepositorySettings)this.secretConfigurationService.replaceSecretUsages(tenantId, (Object)vcSettings, RepositorySettings.class);
            builder.setVcSettings(ProtoUtils.toProto((RepositorySettings)vcSettings));
        } else if (request.requiresSettings()) {
            throw new RuntimeException("No entity version control settings provisioned!");
        }
        return builder;
    }

    private TransportProtos.CommitRequestMsg.Builder buildCommitRequest(CommitGitRequest commit) {
        return TransportProtos.CommitRequestMsg.newBuilder().setTxId(commit.getTxId().toString());
    }
}

