/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.integration.IntegrationManagerService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class IntegrationImportService
extends BaseEntityImportService<IntegrationId, Integration, EntityExportData<Integration>> {
    private final IntegrationService integrationService;
    private final IntegrationManagerService integrationManagerService;

    protected void setOwner(TenantId tenantId, Integration integration, BaseEntityImportService.IdProvider idProvider) {
        integration.setTenantId(tenantId);
    }

    protected Integration findExistingEntity(EntitiesImportCtx ctx, Integration integration, BaseEntityImportService.IdProvider idProvider) {
        Integration existingIntegration = (Integration)super.findExistingEntity(ctx, (ExportableEntity)integration, idProvider);
        if (existingIntegration == null && ctx.isFindExistingByName()) {
            existingIntegration = this.integrationService.findTenantIntegrationsByName(ctx.getTenantId(), integration.getName()).stream().findFirst().orElse(null);
        }
        return existingIntegration;
    }

    protected Integration prepare(EntitiesImportCtx ctx, Integration integration, Integration oldEntity, EntityExportData<Integration> exportData, BaseEntityImportService.IdProvider idProvider) {
        if (ctx.isAutoGenerateIntegrationKey()) {
            if (integration.getId() == null) {
                integration.setRoutingKey(UUID.randomUUID().toString());
            } else {
                integration.setRoutingKey(oldEntity.getRoutingKey());
            }
        }
        integration.setDefaultConverterId((ConverterId)idProvider.getInternalId((EntityId)integration.getDefaultConverterId()));
        integration.setDownlinkConverterId((ConverterId)idProvider.getInternalId((EntityId)integration.getDownlinkConverterId()));
        return integration;
    }

    protected Integration deepCopy(Integration integration) {
        return new Integration(integration);
    }

    protected Integration saveOrUpdate(EntitiesImportCtx ctx, Integration integration, EntityExportData<Integration> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.integrationService.saveIntegration(integration);
    }

    protected void onEntitySaved(User user, Integration savedIntegration, Integration oldIntegration) throws ThingsboardException {
        super.onEntitySaved(user, (ExportableEntity)savedIntegration, (ExportableEntity)oldIntegration);
    }

    public EntityType getEntityType() {
        return EntityType.INTEGRATION;
    }

    @ConstructorProperties(value={"integrationService", "integrationManagerService"})
    @Generated
    public IntegrationImportService(IntegrationService integrationService, IntegrationManagerService integrationManagerService) {
        this.integrationService = integrationService;
        this.integrationManagerService = integrationManagerService;
    }
}

