/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityGroupExportData;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ota.OtaPackageStateService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class EntityGroupImportService
extends BaseEntityImportService<EntityGroupId, EntityGroup, EntityGroupExportData> {
    private static final LinkedHashSet<EntityType> HINTS = new LinkedHashSet<EntityType>(Arrays.asList(EntityType.DASHBOARD, EntityType.DEVICE, EntityType.ASSET));
    public static final Pattern CONFIG_PROCESSED_FIELDS_PATTERN = Pattern.compile(".*Id.*");
    private final EntityGroupService entityGroupService;
    private final GroupPermissionService groupPermissionService;
    private final RoleService roleService;
    private final UserPermissionsService userPermissionsService;
    private final DeviceGroupOtaPackageService deviceGroupOtaPackageService;
    private final OtaPackageStateService otaPackageStateService;

    protected void setOwner(TenantId tenantId, EntityGroup entityGroup, BaseEntityImportService.IdProvider idProvider) {
        if (entityGroup.getOwnerId() instanceof TenantId) {
            entityGroup.setOwnerId((EntityId)tenantId);
        } else {
            entityGroup.setOwnerId(idProvider.getInternalId(entityGroup.getOwnerId()));
        }
    }

    protected EntityGroup findExistingEntity(EntitiesImportCtx ctx, EntityGroup entityGroup, BaseEntityImportService.IdProvider idProvider) {
        EntityGroup existingEntityGroup = (EntityGroup)super.findExistingEntity(ctx, (ExportableEntity)entityGroup, idProvider);
        if (existingEntityGroup == null && ctx.getSettings().isFindExistingByName()) {
            Object ownerId = entityGroup.getOwnerId().getEntityType() == EntityType.TENANT ? ctx.getTenantId() : idProvider.getInternalId(entityGroup.getOwnerId());
            existingEntityGroup = this.entityGroupService.findEntityGroupByTypeAndName(ctx.getTenantId(), (EntityId)ownerId, entityGroup.getType(), entityGroup.getName(), false).orElse(null);
        }
        return existingEntityGroup;
    }

    protected EntityGroup prepare(EntitiesImportCtx ctx, EntityGroup entity, EntityGroup oldEntity, EntityGroupExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        if (entity.getId() == null && entity.isGroupAll()) {
            throw new IllegalArgumentException("Import of new groups with type All is not allowed. Consider enabling import option to find existing entities by name");
        }
        this.replaceIdsRecursively(ctx, idProvider, JacksonUtil.getSafely((JsonNode)entity.getConfiguration(), (String[])new String[]{"actions"}), Collections.emptySet(), CONFIG_PROCESSED_FIELDS_PATTERN, HINTS);
        return entity;
    }

    protected EntityGroup deepCopy(EntityGroup entityGroup) {
        return new EntityGroup(entityGroup);
    }

    protected EntityGroup saveOrUpdate(EntitiesImportCtx ctx, EntityGroup entity, EntityGroupExportData exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.entityGroupService.saveEntityGroup(ctx.getTenantId(), entity.getOwnerId(), entity);
    }

    protected void processAfterSaved(EntitiesImportCtx ctx, EntityImportResult<EntityGroup> importResult, EntityGroupExportData exportData, BaseEntityImportService.IdProvider idProvider) throws ThingsboardException {
        super.processAfterSaved(ctx, importResult, (EntityExportData)exportData, idProvider);
        importResult.addSaveReferencesCallback(() -> {
            EntityGroup savedGroup = (EntityGroup)importResult.getSavedEntity();
            if (savedGroup.getType() == EntityType.DEVICE && exportData.getGroupOtaPackages() != null) {
                this.importGroupOtaPackage(ctx, importResult, savedGroup, exportData.getGroupOtaPackages(), idProvider);
            }
            if (ctx.isSaveUserGroupPermissions() && savedGroup.getType() == EntityType.USER && exportData.getPermissions() != null) {
                this.importGroupPermissions(ctx, importResult, savedGroup, exportData.getPermissions(), idProvider);
            }
        });
    }

    private boolean permissionsEqual(GroupPermission first, GroupPermission second) {
        return first.getUserGroupId().equals((Object)second.getUserGroupId()) && (first.getEntityGroupId() == null ? EntityId.NULL_UUID : first.getEntityGroupId().getId()).equals(second.getEntityGroupId() == null ? EntityId.NULL_UUID : second.getEntityGroupId().getId()) && first.getRoleId().equals((Object)second.getRoleId());
    }

    protected boolean isUpdateNeeded(EntitiesImportCtx ctx, EntityGroupExportData exportData, EntityGroup prepared, EntityGroup existing) {
        return super.isUpdateNeeded(ctx, (EntityExportData)exportData, (ExportableEntity)prepared, (ExportableEntity)existing) || ctx.isSaveUserGroupPermissions() && exportData.getPermissions() != null;
    }

    private void importGroupPermissions(EntitiesImportCtx ctx, EntityImportResult<EntityGroup> importResult, EntityGroup entityGroup, List<GroupPermission> incoming, BaseEntityImportService.IdProvider idProvider) {
        TenantId tenantId = ctx.getTenantId();
        ArrayList<GroupPermission> permissions = new ArrayList<GroupPermission>(incoming);
        permissions.forEach(permission -> {
            permission.setId(null);
            permission.setTenantId(tenantId);
            permission.setRoleId((RoleId)idProvider.getInternalId((EntityId)permission.getRoleId()));
            permission.setUserGroupId(entityGroup.getId());
            permission.setEntityGroupId((EntityGroupId)idProvider.getInternalId((EntityId)permission.getEntityGroupId()));
        });
        if (importResult.getOldEntity() != null) {
            List existingPermissions = this.groupPermissionService.findGroupPermissionListByTenantIdAndUserGroupId(tenantId, entityGroup.getId());
            for (GroupPermission existingPermission : existingPermissions) {
                boolean exists = permissions.stream().anyMatch(p -> this.permissionsEqual(p, existingPermission));
                if (!exists) {
                    Role role = this.roleService.findRoleById(tenantId, existingPermission.getRoleId());
                    if (TenantId.SYS_TENANT_ID.equals((Object)role.getOwnerId())) continue;
                    this.groupPermissionService.deleteGroupPermission(tenantId, existingPermission.getId());
                    importResult.addSendEventsCallback(() -> {
                        this.userPermissionsService.onGroupPermissionDeleted(existingPermission);
                        this.entityActionService.logEntityAction(ctx.getUser(), (EntityId)existingPermission.getId(), (HasName)existingPermission, null, ActionType.DELETED, null, new Object[]{existingPermission.getId().toString()});
                    });
                    continue;
                }
                permissions.removeIf(p -> this.permissionsEqual(p, existingPermission));
            }
        }
        for (GroupPermission permission2 : permissions) {
            Role role = this.roleService.findRoleById(tenantId, permission2.getRoleId());
            if (TenantId.SYS_TENANT_ID.equals((Object)role.getOwnerId())) continue;
            GroupPermission saved = this.groupPermissionService.saveGroupPermission(tenantId, permission2);
            importResult.addSendEventsCallback(() -> {
                this.userPermissionsService.onGroupPermissionUpdated(saved);
                this.entityActionService.logEntityAction(ctx.getUser(), (EntityId)saved.getId(), (HasName)saved, null, ActionType.ADDED, null, new Object[0]);
            });
        }
    }

    private void importGroupOtaPackage(EntitiesImportCtx ctx, EntityImportResult<EntityGroup> importResult, EntityGroup entityGroup, List<DeviceGroupOtaPackage> otaPackages, BaseEntityImportService.IdProvider idProvider) {
        List<DeviceGroupOtaPackage> incoming = otaPackages.stream().peek(pkg -> {
            pkg.setGroupId(entityGroup.getId());
            pkg.setOtaPackageId((OtaPackageId)idProvider.getInternalId((EntityId)pkg.getOtaPackageId()));
        }).toList();
        List existing = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupId(entityGroup.getId());
        for (DeviceGroupOtaPackage otaPackage : existing) {
            boolean notFound = incoming.stream().noneMatch(newPkg -> this.equalsGroupOtaPackage(newPkg, otaPackage));
            if (!notFound) continue;
            this.deviceGroupOtaPackageService.deleteDeviceGroupOtaPackage(ctx.getTenantId(), otaPackage);
            importResult.addSendEventsCallback(() -> this.otaPackageStateService.update(ctx.getTenantId(), null, otaPackage));
        }
        for (DeviceGroupOtaPackage newOtaPackage : incoming) {
            DeviceGroupOtaPackage oldOtaPackage;
            if (this.equalsGroupOtaPackage(newOtaPackage, oldOtaPackage = (DeviceGroupOtaPackage)existing.stream().filter(e -> e.getOtaPackageType() == newOtaPackage.getOtaPackageType()).findFirst().orElse(null))) continue;
            if (oldOtaPackage != null) {
                newOtaPackage.setId(oldOtaPackage.getId());
                newOtaPackage.setGroupId(oldOtaPackage.getGroupId());
            } else {
                newOtaPackage.setId(null);
                newOtaPackage.setGroupId(entityGroup.getId());
            }
            this.deviceGroupOtaPackageService.saveDeviceGroupOtaPackage(ctx.getTenantId(), newOtaPackage);
            importResult.addSendEventsCallback(() -> this.otaPackageStateService.update(ctx.getTenantId(), newOtaPackage, oldOtaPackage));
        }
    }

    private boolean equalsGroupOtaPackage(DeviceGroupOtaPackage a, DeviceGroupOtaPackage b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Objects.equals(a.getOtaPackageId(), b.getOtaPackageId()) && a.getOtaPackageType() == b.getOtaPackageType() && a.getGroupId().equals((Object)b.getGroupId());
    }

    public EntityType getEntityType() {
        return EntityType.ENTITY_GROUP;
    }

    @ConstructorProperties(value={"entityGroupService", "groupPermissionService", "roleService", "userPermissionsService", "deviceGroupOtaPackageService", "otaPackageStateService"})
    @Generated
    public EntityGroupImportService(EntityGroupService entityGroupService, GroupPermissionService groupPermissionService, RoleService roleService, UserPermissionsService userPermissionsService, DeviceGroupOtaPackageService deviceGroupOtaPackageService, OtaPackageStateService otaPackageStateService) {
        this.entityGroupService = entityGroupService;
        this.groupPermissionService = groupPermissionService;
        this.roleService = roleService;
        this.userPermissionsService = userPermissionsService;
        this.deviceGroupOtaPackageService = deviceGroupOtaPackageService;
        this.otaPackageStateService = otaPackageStateService;
    }
}

