/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.csv;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.TbBiFunction;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasAdditionalInfo;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportColumnType;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.util.TypeCastUtil;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.report.util.CsvUtils;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.sync.ie.importing.csv.AbstractBulkImportService;
import org.thingsboard.server.service.sync.ie.importing.csv.ImportedEntityInfo;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class AbstractBulkImportService<E extends HasId<? extends EntityId> & TenantEntity> {
    @Autowired
    private TelemetrySubscriptionService tsSubscriptionService;
    @Autowired
    private TbTenantProfileCache tenantProfileCache;
    @Autowired
    private AccessControlService accessControlService;
    @Autowired
    private AccessValidator accessValidator;
    @Autowired
    private EntityActionService entityActionService;
    private ExecutorService executor;

    @PostConstruct
    private void initExecutor() {
        this.executor = ThingsBoardExecutors.newLimitedTasksExecutor((int)Runtime.getRuntime().availableProcessors(), (int)150000, (String)"bulk-import");
    }

    public final BulkImportResult<E> processBulkImport(BulkImportRequest request, SecurityUser user, BiConsumer<E, TbBiFunction<E, EntityGroup, E>> entityGroupAssigner) throws Exception {
        List entitiesData = this.parseData(request);
        BulkImportResult result = new BulkImportResult();
        CountDownLatch completionLatch = new CountDownLatch(entitiesData.size());
        SecurityContext securityContext = SecurityContextHolder.getContext();
        entitiesData.forEach(entityData -> DonAsynchron.submit(() -> {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
            ImportedEntityInfo importedEntityInfo = new ImportedEntityInfo();
            HasId entity = this.findOrCreateEntity(user.getTenantId(), (String)entityData.getFields().get(BulkImportColumnType.NAME));
            if (entity.getId() != null) {
                importedEntityInfo.setOldEntity((Object)((HasId)entity.getClass().getConstructor(entity.getClass()).newInstance(entity)));
                importedEntityInfo.setUpdated(true);
                if (entity instanceof HasVersion) {
                    HasVersion versionedEntity = (HasVersion)entity;
                    versionedEntity.setVersion(null);
                }
            } else {
                this.setOwners(entity, user.getTenantId(), request.getCustomerId() != null ? request.getCustomerId() : user.getCustomerId());
            }
            this.setEntityFields(entity, entityData.getFields());
            this.accessControlService.checkPermission(user, Resource.resourceFromEntityType((EntityType)this.getEntityType()), Operation.WRITE, (EntityId)entity.getId(), (TenantEntity)entity);
            TbBiFunction savingFunction = (e, entityGroup) -> {
                HasId savedEntity = this.saveEntity(user, entity, entityGroup, entityData.getFields());
                importedEntityInfo.setEntity((Object)savedEntity);
                return savedEntity;
            };
            if (entityGroupAssigner != null) {
                entityGroupAssigner.accept(entity, savingFunction);
            } else {
                savingFunction.apply((Object)entity, null);
            }
            HasId savedEntity = (HasId)importedEntityInfo.getEntity();
            if (request.getMapping().getUpdate().booleanValue() || !importedEntityInfo.isUpdated()) {
                this.saveKvs(user, savedEntity, entityData.getKvs());
            }
            return importedEntityInfo;
        }, importedEntityInfo -> {
            if (importedEntityInfo.isUpdated()) {
                result.getUpdated().incrementAndGet();
            } else {
                result.getCreated().incrementAndGet();
            }
            completionLatch.countDown();
        }, throwable -> {
            result.getErrors().incrementAndGet();
            result.getErrorsList().add(String.format("Line %d: %s", entityData.getLineNumber(), ExceptionUtils.getRootCauseMessage((Throwable)throwable)));
            completionLatch.countDown();
        }, (Executor)this.executor));
        completionLatch.await();
        return result;
    }

    protected abstract E findOrCreateEntity(TenantId var1, String var2);

    protected abstract void setOwners(E var1, TenantId var2, CustomerId var3);

    protected abstract void setEntityFields(E var1, Map<BulkImportColumnType, String> var2);

    protected abstract E saveEntity(SecurityUser var1, E var2, EntityGroup var3, Map<BulkImportColumnType, String> var4);

    protected abstract EntityType getEntityType();

    protected ObjectNode getOrCreateAdditionalInfoObj(HasAdditionalInfo entity) {
        return entity.getAdditionalInfo() == null || entity.getAdditionalInfo().isNull() ? JacksonUtil.newObjectNode() : (ObjectNode)entity.getAdditionalInfo();
    }

    private void saveKvs(SecurityUser user, E entity, Map<BulkImportRequest.ColumnMapping, ParsedValue> data) {
        Arrays.stream(BulkImportColumnType.values()).filter(BulkImportColumnType::isKv).map(kvType -> {
            JsonObject kvs = new JsonObject();
            data.entrySet().stream().filter(dataEntry -> ((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getType() == kvType && StringUtils.isNotEmpty((String)((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getKey())).forEach(dataEntry -> kvs.add(((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getKey(), (JsonElement)((ParsedValue)dataEntry.getValue()).toJsonPrimitive()));
            return Map.entry(kvType, kvs);
        }).filter(kvsEntry -> !((JsonObject)kvsEntry.getValue()).entrySet().isEmpty()).forEach(kvsEntry -> {
            BulkImportColumnType kvType = (BulkImportColumnType)kvsEntry.getKey();
            if (kvType == BulkImportColumnType.SHARED_ATTRIBUTE || kvType == BulkImportColumnType.SERVER_ATTRIBUTE) {
                this.saveAttributes(user, entity, kvsEntry, kvType);
            } else {
                this.saveTelemetry(user, entity, kvsEntry);
            }
        });
    }

    private void saveTelemetry(SecurityUser user, E entity, Map.Entry<BulkImportColumnType, JsonObject> kvsEntry) {
        List timeseries = JsonConverter.convertToTelemetry((JsonElement)((JsonElement)kvsEntry.getValue()), (long)System.currentTimeMillis()).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(kvEntry -> new BasicTsKvEntry(((Long)entry.getKey()).longValue(), kvEntry))).collect(Collectors.toList());
        this.accessValidator.validateEntityAndCallback(user, Operation.WRITE_TELEMETRY, (EntityId)entity.getId(), (result, tenantId, entityId) -> {
            TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
            long tenantTtl = TimeUnit.DAYS.toSeconds(((DefaultTenantProfileConfiguration)tenantProfile.getProfileData().getConfiguration()).getDefaultStorageTtlDays());
            this.tsSubscriptionService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).customerId(user.getCustomerId()).entityId(entityId).entries(timeseries).ttl(tenantTtl).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
        });
    }

    private void saveAttributes(SecurityUser user, E entity, Map.Entry<BulkImportColumnType, JsonObject> kvsEntry, BulkImportColumnType kvType) {
        String scope = kvType.getKey();
        List attributes = JsonConverter.convertToAttributes((JsonElement)((JsonElement)kvsEntry.getValue()));
        this.accessValidator.validateEntityAndCallback(user, Operation.WRITE_ATTRIBUTES, (EntityId)entity.getId(), (result, tenantId, entityId) -> this.tsSubscriptionService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId(entityId).scope(AttributeScope.valueOf((String)scope)).entries(attributes).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build()));
    }

    private List<EntityData> parseData(BulkImportRequest request) throws Exception {
        List records = CsvUtils.parseCsv((String)request.getFile(), (Character)request.getMapping().getDelimiter());
        AtomicInteger linesCounter = new AtomicInteger(0);
        if (request.getMapping().getHeader().booleanValue()) {
            records.remove(0);
            linesCounter.incrementAndGet();
        }
        List columnsMappings = request.getMapping().getColumns();
        return records.stream().map(record -> {
            EntityData entityData = new EntityData();
            Stream.iterate(0, i -> i < record.size(), i -> i + 1).map(i -> Map.entry((BulkImportRequest.ColumnMapping)columnsMappings.get((int)i), (String)record.get((int)i))).filter(entry -> StringUtils.isNotEmpty((String)((String)entry.getValue()))).forEach(entry -> {
                if (!((BulkImportRequest.ColumnMapping)entry.getKey()).getType().isKv()) {
                    entityData.getFields().put(((BulkImportRequest.ColumnMapping)entry.getKey()).getType(), (String)entry.getValue());
                } else {
                    Pair castResult = TypeCastUtil.castValue((String)((String)entry.getValue()));
                    entityData.getKvs().put((BulkImportRequest.ColumnMapping)entry.getKey(), new ParsedValue(castResult.getValue(), (DataType)castResult.getKey()));
                }
            });
            entityData.setLineNumber(linesCounter.incrementAndGet());
            return entityData;
        }).collect(Collectors.toList());
    }

    @PreDestroy
    private void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

