/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class ReportTemplateExportService
extends BaseEntityExportService<ReportTemplateId, ReportTemplate, EntityExportData<ReportTemplate>> {
    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, ReportTemplate reportTemplate, EntityExportData<ReportTemplate> exportData) {
        reportTemplate.setCustomerId((CustomerId)this.getExternalIdOrElseInternal(ctx, (EntityId)reportTemplate.getCustomerId()));
        for (JsonNode entityAlias : reportTemplate.getEntityAliasesConfig()) {
            this.replaceUuidsRecursively(ctx, entityAlias, Set.of("id"), null);
        }
        for (JsonNode dataSource : reportTemplate.getComponentDataSources()) {
            this.replaceUuidsRecursively(ctx, dataSource, Set.of("entityAliasId"), null);
        }
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.REPORT_TEMPLATE);
    }
}

