/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.common.data.sync.ie.EntityGroupExportData;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.ota.DeviceGroupOtaPackageService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.ie.importing.impl.EntityGroupImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class EntityGroupExportService
extends BaseEntityExportService<EntityGroupId, EntityGroup, EntityGroupExportData> {
    private final GroupPermissionService groupPermissionService;
    private final RoleService roleService;
    private final DeviceGroupOtaPackageService deviceGroupOtaPackageService;

    protected void setAdditionalExportData(EntitiesExportCtx<?> ctx, EntityGroup entityGroup, EntityGroupExportData exportData) throws ThingsboardException {
        List<DeviceGroupOtaPackage> packages;
        super.setAdditionalExportData(ctx, (ExportableEntity)entityGroup, (EntityExportData)exportData);
        EntityExportSettings exportSettings = ctx.getSettings();
        exportData.setGroupEntities(exportSettings.isExportGroupEntities());
        if (exportSettings.isExportPermissions() && entityGroup.getType() == EntityType.USER) {
            List permissions = this.groupPermissionService.findGroupPermissionListByTenantIdAndUserGroupId(ctx.getTenantId(), entityGroup.getId()).stream().filter(permission -> {
                Role role = this.roleService.findRoleById(ctx.getTenantId(), permission.getRoleId());
                return !role.getOwnerId().equals(TenantId.SYS_TENANT_ID);
            }).peek(permission -> {
                permission.setUserGroupId((EntityGroupId)this.getExternalIdOrElseInternal(ctx, (EntityId)permission.getUserGroupId()));
                permission.setRoleId((RoleId)this.getExternalIdOrElseInternal(ctx, (EntityId)permission.getRoleId()));
                permission.setEntityGroupId((EntityGroupId)this.getExternalIdOrElseInternal(ctx, (EntityId)permission.getEntityGroupId()));
            }).collect(Collectors.toList());
            exportData.setPermissions(permissions);
        }
        if (entityGroup.getType() == EntityType.DEVICE && !(packages = this.deviceGroupOtaPackageService.findDeviceGroupOtaPackageByGroupId(entityGroup.getId()).stream().filter(Objects::nonNull).peek(pkg -> {
            pkg.setOtaPackageId((OtaPackageId)this.getExternalIdOrElseInternal(ctx, (EntityId)pkg.getOtaPackageId()));
            pkg.setGroupId((EntityGroupId)this.getExternalIdOrElseInternal(ctx, (EntityId)pkg.getGroupId()));
        }).toList()).isEmpty()) {
            exportData.setGroupOtaPackages(packages);
        }
        this.replaceUuidsRecursively(ctx, JacksonUtil.getSafely((JsonNode)((EntityGroup)exportData.getEntity()).getConfiguration(), (String[])new String[]{"actions"}), Collections.emptySet(), EntityGroupImportService.CONFIG_PROCESSED_FIELDS_PATTERN);
    }

    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, EntityGroup entityGroup, EntityGroupExportData exportData) {
        if (entityGroup.getOwnerId().getEntityType() == EntityType.CUSTOMER) {
            entityGroup.setOwnerId(this.getExternalIdOrElseInternal(ctx, entityGroup.getOwnerId()));
        }
    }

    protected EntityGroupExportData newExportData() {
        return new EntityGroupExportData();
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.ENTITY_GROUP);
    }

    @ConstructorProperties(value={"groupPermissionService", "roleService", "deviceGroupOtaPackageService"})
    @Generated
    public EntityGroupExportService(GroupPermissionService groupPermissionService, RoleService roleService, DeviceGroupOtaPackageService deviceGroupOtaPackageService) {
        this.groupPermissionService = groupPermissionService;
        this.roleService = roleService;
        this.deviceGroupOtaPackageService = deviceGroupOtaPackageService;
    }
}

