/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.sync.ie.DeviceExportData;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.DefaultGroupEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class DeviceExportService
extends DefaultGroupEntityExportService<DeviceId, Device, DeviceExportData> {
    private final DeviceCredentialsService deviceCredentialsService;

    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, Device device, DeviceExportData exportData) {
        device.setCustomerId((CustomerId)this.getExternalIdOrElseInternal(ctx, (EntityId)device.getCustomerId()));
        device.setDeviceProfileId((DeviceProfileId)this.getExternalIdOrElseInternal(ctx, (EntityId)device.getDeviceProfileId()));
        device.setFirmwareId((OtaPackageId)this.getExternalIdOrElseInternal(ctx, (EntityId)device.getFirmwareId()));
        device.setSoftwareId((OtaPackageId)this.getExternalIdOrElseInternal(ctx, (EntityId)device.getSoftwareId()));
        if (ctx.getSettings().isExportCredentials()) {
            DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(ctx.getTenantId(), device.getId());
            credentials.setId(null);
            credentials.setDeviceId(null);
            exportData.setCredentials(credentials);
        }
    }

    protected DeviceExportData newExportData() {
        return new DeviceExportData();
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.DEVICE);
    }

    @ConstructorProperties(value={"deviceCredentialsService"})
    @Generated
    public DeviceExportService(DeviceCredentialsService deviceCredentialsService) {
        this.deviceCredentialsService = deviceCredentialsService;
    }
}

