/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.sync.ie.AttributeExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.relation.RelationDao;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.EntityExportService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
@Primary
public class DefaultEntityExportService<I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>>
implements EntityExportService<I, E, D> {
    @Autowired
    @Lazy
    protected ExportableEntitiesService exportableEntitiesService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;

    public final D getExportData(EntitiesExportCtx<?> ctx, I entityId) throws ThingsboardException {
        EntityExportData exportData = this.newExportData();
        ExportableEntity entity = (ExportableEntity)this.exportableEntitiesService.findEntityByTenantIdAndId(ctx.getTenantId(), entityId);
        if (entity == null) {
            throw new IllegalArgumentException(String.valueOf(entityId.getEntityType()) + " [" + String.valueOf(entityId.getId()) + "] not found");
        }
        exportData.setEntity(entity);
        exportData.setEntityType(entityId.getEntityType());
        this.setAdditionalExportData(ctx, entity, exportData);
        if (entity instanceof HasVersion) {
            HasVersion hasVersion = (HasVersion)entity;
            hasVersion.setVersion(null);
        }
        EntityId externalId = entity.getExternalId() != null ? entity.getExternalId() : (EntityId)entity.getId();
        ctx.putExternalId(entityId, externalId);
        entity.setId(externalId);
        entity.setTenantId(null);
        return (D)exportData;
    }

    protected void setAdditionalExportData(EntitiesExportCtx<?> ctx, E entity, D exportData) throws ThingsboardException {
        EntityExportSettings exportSettings = ctx.getSettings();
        if (exportSettings.isExportRelations()) {
            List relations = this.exportRelations(ctx, entity);
            relations.forEach(relation -> {
                relation.setFrom(this.getExternalIdOrElseInternal(ctx, relation.getFrom()));
                relation.setTo(this.getExternalIdOrElseInternal(ctx, relation.getTo()));
            });
            exportData.setRelations(relations);
        }
        if (exportSettings.isExportAttributes()) {
            Map attributes = this.exportAttributes(ctx, entity);
            exportData.setAttributes(attributes);
        }
        if (ctx.getSettings().isExportCalculatedFields()) {
            List calculatedFields = this.exportCalculatedFields(ctx, (EntityId)entity.getId());
            exportData.setCalculatedFields(calculatedFields);
        }
    }

    private List<EntityRelation> exportRelations(EntitiesExportCtx<?> ctx, E entity) throws ThingsboardException {
        ArrayList<EntityRelation> relations = new ArrayList<EntityRelation>();
        List inboundRelations = this.relationDao.findAllByTo(ctx.getTenantId(), (EntityId)entity.getId(), RelationTypeGroup.COMMON);
        relations.addAll(inboundRelations);
        List outboundRelations = this.relationDao.findAllByFrom(ctx.getTenantId(), (EntityId)entity.getId(), RelationTypeGroup.COMMON);
        relations.addAll(outboundRelations);
        return relations;
    }

    private Map<String, List<AttributeExportData>> exportAttributes(EntitiesExportCtx<?> ctx, E entity) throws ThingsboardException {
        List<AttributeScope> scopes = ((EntityId)entity.getId()).getEntityType() == EntityType.DEVICE ? List.of(AttributeScope.SERVER_SCOPE, AttributeScope.SHARED_SCOPE) : Collections.singletonList(AttributeScope.SERVER_SCOPE);
        LinkedHashMap<String, List<AttributeExportData>> attributes = new LinkedHashMap<String, List<AttributeExportData>>();
        scopes.forEach(scope -> {
            try {
                attributes.put(scope.name(), ((List)this.attributesService.findAll(ctx.getTenantId(), (EntityId)entity.getId(), scope).get()).stream().map(attribute -> {
                    AttributeExportData attributeExportData = new AttributeExportData();
                    attributeExportData.setKey(attribute.getKey());
                    attributeExportData.setLastUpdateTs(Long.valueOf(attribute.getLastUpdateTs()));
                    attributeExportData.setStrValue((String)attribute.getStrValue().orElse(null));
                    attributeExportData.setDoubleValue((Double)attribute.getDoubleValue().orElse(null));
                    attributeExportData.setLongValue((Long)attribute.getLongValue().orElse(null));
                    attributeExportData.setBooleanValue((Boolean)attribute.getBooleanValue().orElse(null));
                    attributeExportData.setJsonValue((String)attribute.getJsonValue().orElse(null));
                    return attributeExportData;
                }).collect(Collectors.toList()));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return attributes;
    }

    private List<CalculatedField> exportCalculatedFields(EntitiesExportCtx<?> ctx, EntityId entityId) {
        List calculatedFields = this.calculatedFieldService.findCalculatedFieldsByEntityId(ctx.getTenantId(), entityId);
        calculatedFields.forEach(calculatedField -> {
            calculatedField.setEntityId(this.getExternalIdOrElseInternal(ctx, entityId));
            calculatedField.getConfiguration().getArguments().values().forEach(argument -> {
                if (argument.getRefEntityId() != null) {
                    argument.setRefEntityId(this.getExternalIdOrElseInternal(ctx, argument.getRefEntityId()));
                }
            });
        });
        return calculatedFields;
    }

    public <ID extends EntityId> ID getExternalIdOrElseInternal(EntitiesExportCtx<?> ctx, ID internalId) {
        if (internalId == null || internalId.isNullUid()) {
            return internalId;
        }
        EntityId result = ctx.getExternalId(internalId);
        if (result == null) {
            result = Optional.ofNullable(this.exportableEntitiesService.getExternalIdByInternal(internalId)).orElse(internalId);
            ctx.putExternalId(internalId, result);
        }
        return (ID)result;
    }

    protected UUID getExternalIdOrElseInternalByUuid(EntitiesExportCtx<?> ctx, UUID internalUuid) {
        EntityId externalId;
        EntityId internalId;
        for (EntityType entityType : EntityType.values()) {
            try {
                internalId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)internalUuid);
            }
            catch (Exception e) {
                continue;
            }
            externalId = ctx.getExternalId(internalId);
            if (externalId == null) continue;
            return externalId.getId();
        }
        for (EntityType entityType : EntityType.values()) {
            try {
                internalId = EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)internalUuid);
            }
            catch (Exception e) {
                continue;
            }
            externalId = this.exportableEntitiesService.getExternalIdByInternal(internalId);
            if (externalId == null) continue;
            ctx.putExternalId(internalId, externalId);
            return externalId.getId();
        }
        return internalUuid;
    }

    protected D newExportData() {
        return (D)new EntityExportData();
    }
}

