/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.subscription.TbAlarmStatusSubscription;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.ws.telemetry.sub.AlarmSubscriptionUpdate;

public class TbAlarmStatusSubscription
extends TbSubscription<AlarmSubscriptionUpdate> {
    private final Set<UUID> alarmIds = new HashSet();
    private boolean hasMoreAlarmsInDB;
    private final List<String> typeList;
    private final List<AlarmSeverity> severityList;

    public TbAlarmStatusSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, BiConsumer<TbSubscription<AlarmSubscriptionUpdate>, AlarmSubscriptionUpdate> updateProcessor, List<String> typeList, List<AlarmSeverity> severityList) {
        super(serviceId, sessionId, subscriptionId, tenantId, entityId, TbSubscriptionType.ALARMS, updateProcessor);
        this.typeList = typeList;
        this.severityList = severityList;
    }

    public boolean matches(AlarmInfo alarm) {
        return !(alarm.isCleared() || this.typeList != null && !this.typeList.contains(alarm.getType()) || this.severityList != null && !this.severityList.contains(alarm.getSeverity()));
    }

    public boolean hasAlarms() {
        return !this.alarmIds.isEmpty();
    }

    @Generated
    public static TbAlarmStatusSubscriptionBuilder builder() {
        return new TbAlarmStatusSubscriptionBuilder();
    }

    @Generated
    public Set<UUID> getAlarmIds() {
        return this.alarmIds;
    }

    @Generated
    public boolean isHasMoreAlarmsInDB() {
        return this.hasMoreAlarmsInDB;
    }

    @Generated
    public void setHasMoreAlarmsInDB(boolean hasMoreAlarmsInDB) {
        this.hasMoreAlarmsInDB = hasMoreAlarmsInDB;
    }

    @Generated
    public List<String> getTypeList() {
        return this.typeList;
    }

    @Generated
    public List<AlarmSeverity> getSeverityList() {
        return this.severityList;
    }
}

