/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.discovery.event.OtherServiceShutdownEvent;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.subscription.SubscriptionManagerService;
import org.thingsboard.server.service.subscription.SubscriptionSchedulerComponent;
import org.thingsboard.server.service.subscription.TbEntityRemoteSubsInfo;
import org.thingsboard.server.service.subscription.TbEntitySubEvent;
import org.thingsboard.server.service.subscription.TbEntityUpdatesInfo;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscriptionUtils;
import org.thingsboard.server.service.subscription.TbSubscriptionsInfo;
import org.thingsboard.server.service.ws.notification.sub.NotificationUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;

/*
 * Exception performing whole class analysis ignored.
 */
@TbCoreComponent
@Service
public class DefaultSubscriptionManagerService
extends TbApplicationEventListener<PartitionChangeEvent>
implements SubscriptionManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriptionManagerService.class);
    private final TopicService topicService;
    private final PartitionService partitionService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbQueueProducerProvider producerProvider;
    private final TbLocalSubscriptionService localSubscriptionService;
    private final SubscriptionSchedulerComponent scheduler;
    private final Lock subsLock = new ReentrantLock();
    private final ConcurrentMap<EntityId, TbEntityRemoteSubsInfo> entitySubscriptions = new ConcurrentHashMap();
    private final ConcurrentMap<EntityId, TbEntityUpdatesInfo> entityUpdates = new ConcurrentHashMap();
    private String serviceId;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> toCoreNotificationsProducer;
    private long initTs;

    @PostConstruct
    public void initExecutor() {
        this.serviceId = this.serviceInfoProvider.getServiceId();
        this.initTs = System.currentTimeMillis();
        this.toCoreNotificationsProducer = this.producerProvider.getTbCoreNotificationsMsgProducer();
        this.scheduler.scheduleWithFixedDelay(() -> this.cleanupEntityUpdates(), 1L, 1L, TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubEvent(String serviceId, TbEntitySubEvent event, TbCallback callback) {
        TenantId tenantId = event.getTenantId();
        EntityId entityId = event.getEntityId();
        log.trace("[{}][{}][{}] Processing subscription event {}", new Object[]{tenantId, entityId, serviceId, event});
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, entityId);
        if (tpi.isMyPartition()) {
            this.subsLock.lock();
            try {
                TbEntityRemoteSubsInfo entitySubs = this.entitySubscriptions.computeIfAbsent(entityId, id -> new TbEntityRemoteSubsInfo(tenantId, entityId));
                boolean empty = entitySubs.updateAndCheckIsEmpty(serviceId, event);
                if (empty) {
                    this.entitySubscriptions.remove(entityId);
                }
            }
            finally {
                this.subsLock.unlock();
            }
            callback.onSuccess();
            if (event.hasTsOrAttrSub()) {
                this.sendSubEventCallback(tenantId, serviceId, entityId, event.getSeqNumber());
            }
        } else {
            log.warn("[{}][{}][{}] Event belongs to external partition. Probably re-balancing is in progress. Topic: {}", new Object[]{tenantId, entityId, serviceId, tpi.getFullTopicName()});
            callback.onFailure((Throwable)new RuntimeException("Entity belongs to external partition " + tpi.getFullTopicName() + "!"));
        }
    }

    @EventListener(value={OtherServiceShutdownEvent.class})
    public void onApplicationEvent(OtherServiceShutdownEvent event) {
        if (event.getServiceTypes() != null && event.getServiceTypes().contains(ServiceType.TB_CORE)) {
            this.subsLock.lock();
            try {
                int sizeBeforeCleanup = this.entitySubscriptions.size();
                this.entitySubscriptions.entrySet().removeIf(kv -> ((TbEntityRemoteSubsInfo)kv.getValue()).removeAndCheckIsEmpty(event.getServiceId()));
                log.info("[{}][{}] Removed {} entity subscription records due to server shutdown.", new Object[]{this.serviceId, event.getServiceId(), this.entitySubscriptions.size() - sizeBeforeCleanup});
            }
            finally {
                this.subsLock.unlock();
            }
        }
    }

    private void sendSubEventCallback(TenantId tenantId, String targetId, EntityId entityId, int seqNumber) {
        TbEntityUpdatesInfo update = this.getEntityUpdatesInfo(entityId);
        if (this.serviceId.equals(targetId)) {
            this.localSubscriptionService.onSubEventCallback(tenantId, entityId, seqNumber, update, TbCallback.EMPTY);
        } else {
            this.sendCoreNotification(targetId, entityId, TbSubscriptionUtils.toProto((TenantId)tenantId, (UUID)entityId.getId(), (int)seqNumber, (TbEntityUpdatesInfo)update));
        }
    }

    protected void onTbApplicationEvent(PartitionChangeEvent partitionChangeEvent) {
        if (ServiceType.TB_CORE.equals((Object)partitionChangeEvent.getServiceType())) {
            this.entitySubscriptions.values().removeIf(sub -> !this.partitionService.isMyPartition(ServiceType.TB_CORE, sub.getTenantId(), sub.getEntityId()));
        }
    }

    public void onTimeSeriesUpdate(TenantId tenantId, EntityId entityId, List<TsKvEntry> ts, TbCallback callback) {
        this.onTimeSeriesUpdate(entityId, ts);
        callback.onSuccess();
    }

    public void onTimeSeriesDelete(TenantId tenantId, EntityId entityId, List<String> keys, TbCallback callback) {
        this.onTimeSeriesUpdate(entityId, keys.stream().map(key -> new BasicTsKvEntry(0L, (KvEntry)new StringDataEntry(key, ""))).collect(Collectors.toList()));
        callback.onSuccess();
    }

    private void onTimeSeriesUpdate(EntityId entityId, List<TsKvEntry> update) {
        this.getEntityUpdatesInfo((EntityId)entityId).timeSeriesUpdateTs = System.currentTimeMillis();
        TbEntityRemoteSubsInfo subInfo = (TbEntityRemoteSubsInfo)this.entitySubscriptions.get(entityId);
        if (subInfo != null) {
            log.trace("[{}] Handling time-series update: {}", (Object)entityId, update);
            subInfo.getSubs().forEach((serviceId, sub) -> {
                List tmp;
                if (sub.tsAllKeys) {
                    this.onTimeSeriesUpdate(serviceId, entityId, update);
                } else if (sub.tsKeys != null && (tmp = DefaultSubscriptionManagerService.getSubList((List)update, (Set)sub.tsKeys)) != null) {
                    this.onTimeSeriesUpdate(serviceId, entityId, tmp);
                }
            });
        } else {
            log.trace("[{}] No time-series subscriptions for entity.", (Object)entityId);
        }
    }

    private void onTimeSeriesUpdate(String targetId, EntityId entityId, List<TsKvEntry> update) {
        if (this.serviceId.equals(targetId)) {
            this.localSubscriptionService.onTimeSeriesUpdate(entityId, update, TbCallback.EMPTY);
        } else {
            this.sendCoreNotification(targetId, entityId, TbSubscriptionUtils.toProto((EntityId)entityId, update));
        }
    }

    public void onAttributesUpdate(TenantId tenantId, EntityId entityId, String scope, List<AttributeKvEntry> attributes, TbCallback callback) {
        this.getEntityUpdatesInfo((EntityId)entityId).attributesUpdateTs = System.currentTimeMillis();
        this.processAttributesUpdate(entityId, scope, attributes);
        callback.onSuccess();
    }

    public void onAttributesDelete(TenantId tenantId, EntityId entityId, String scope, List<String> keys, TbCallback callback) {
        try {
            List<AttributeKvEntry> deletedEntries = keys.stream().map(key -> new BaseAttributeKvEntry(0L, (KvEntry)new StringDataEntry(key, ""))).toList();
            this.processAttributesUpdate(entityId, scope, deletedEntries);
        }
        catch (Exception e) {
            callback.onFailure((Throwable)e);
            return;
        }
        callback.onSuccess();
    }

    private void processAttributesUpdate(EntityId entityId, String scope, List<AttributeKvEntry> update) {
        TbEntityRemoteSubsInfo subInfo = (TbEntityRemoteSubsInfo)this.entitySubscriptions.get(entityId);
        if (subInfo != null) {
            log.trace("[{}] Handling attributes update: {}", (Object)entityId, update);
            subInfo.getSubs().forEach((serviceId, sub) -> {
                List tmp;
                if (sub.attrAllKeys) {
                    this.processAttributesUpdate(serviceId, entityId, scope, update);
                } else if (sub.attrKeys != null && (tmp = DefaultSubscriptionManagerService.getSubList((List)update, (Set)sub.attrKeys)) != null) {
                    this.processAttributesUpdate(serviceId, entityId, scope, tmp);
                }
            });
        } else {
            log.trace("[{}] No attributes subscriptions for entity.", (Object)entityId);
        }
    }

    private void processAttributesUpdate(String targetId, EntityId entityId, String scope, List<AttributeKvEntry> update) {
        List tsKvEntryList = update.stream().map(attr -> new BasicTsKvEntry(attr.getLastUpdateTs(), (KvEntry)attr)).collect(Collectors.toList());
        if (this.serviceId.equals(targetId)) {
            this.localSubscriptionService.onAttributesUpdate(entityId, scope, tsKvEntryList, TbCallback.EMPTY);
        } else {
            this.sendCoreNotification(targetId, entityId, TbSubscriptionUtils.toProto((String)scope, (EntityId)entityId, tsKvEntryList));
        }
    }

    public void onAlarmUpdate(TenantId tenantId, EntityId entityId, AlarmInfo alarm, TbCallback callback) {
        this.onAlarmSubUpdate(tenantId, entityId, alarm, false, callback);
    }

    public void onAlarmDeleted(TenantId tenantId, EntityId entityId, AlarmInfo alarm, TbCallback callback) {
        this.onAlarmSubUpdate(tenantId, entityId, alarm, true, callback);
    }

    private void onAlarmSubUpdate(TenantId tenantId, EntityId entityId, AlarmInfo alarm, boolean deleted, TbCallback callback) {
        TbEntityRemoteSubsInfo subInfo = (TbEntityRemoteSubsInfo)this.entitySubscriptions.get(entityId);
        if (subInfo != null) {
            log.trace("[{}][{}] Handling alarm update {}: {}", new Object[]{tenantId, entityId, alarm, deleted});
            for (Map.Entry entry : subInfo.getSubs().entrySet()) {
                if (!((TbSubscriptionsInfo)entry.getValue()).alarms) continue;
                this.onAlarmSubUpdate((String)entry.getKey(), entityId, alarm, deleted);
            }
        }
        callback.onSuccess();
    }

    private void onAlarmSubUpdate(String targetServiceId, EntityId entityId, AlarmInfo alarm, boolean deleted) {
        if (alarm == null) {
            log.warn("[{}] empty alarm update!", (Object)entityId);
            return;
        }
        if (this.serviceId.equals(targetServiceId)) {
            log.trace("[{}] Forwarding to local service: {} deleted: {}", new Object[]{entityId, alarm, deleted});
            this.localSubscriptionService.onAlarmUpdate(entityId, alarm, deleted, TbCallback.EMPTY);
        } else {
            this.sendCoreNotification(targetServiceId, entityId, TbSubscriptionUtils.toAlarmSubUpdateToProto((EntityId)entityId, (AlarmInfo)alarm, (boolean)deleted));
        }
    }

    private void sendCoreNotification(String targetServiceId, EntityId entityId, TransportProtos.ToCoreNotificationMsg msg) {
        log.trace("[{}] Forwarding to remote service [{}]: {}", new Object[]{entityId, targetServiceId, msg});
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, targetServiceId);
        TbProtoQueueMsg queueMsg = new TbProtoQueueMsg(entityId.getId(), (GeneratedMessageV3)msg);
        this.toCoreNotificationsProducer.send(tpi, (TbQueueMsg)queueMsg, null);
    }

    public void onNotificationUpdate(TenantId tenantId, UserId entityId, NotificationUpdate notificationUpdate, TbCallback callback) {
        TbEntityRemoteSubsInfo subInfo = (TbEntityRemoteSubsInfo)this.entitySubscriptions.get(entityId);
        if (subInfo != null) {
            NotificationsSubscriptionUpdate subscriptionUpdate = new NotificationsSubscriptionUpdate(notificationUpdate);
            log.trace("[{}][{}] Handling notificationUpdate for user {}", new Object[]{tenantId, entityId, notificationUpdate});
            for (Map.Entry entry : subInfo.getSubs().entrySet()) {
                if (!((TbSubscriptionsInfo)entry.getValue()).notifications) continue;
                this.onNotificationsSubUpdate((String)entry.getKey(), (EntityId)entityId, subscriptionUpdate);
            }
        }
        callback.onSuccess();
    }

    private void onNotificationsSubUpdate(String targetServiceId, EntityId entityId, NotificationsSubscriptionUpdate subscriptionUpdate) {
        if (this.serviceId.equals(targetServiceId)) {
            log.trace("[{}] Forwarding to local service: {}", (Object)entityId, (Object)subscriptionUpdate);
            this.localSubscriptionService.onNotificationUpdate(entityId, subscriptionUpdate, TbCallback.EMPTY);
        } else {
            this.sendCoreNotification(targetServiceId, entityId, TbSubscriptionUtils.notificationsSubUpdateToProto((EntityId)entityId, (NotificationsSubscriptionUpdate)subscriptionUpdate));
        }
    }

    private static <T extends KvEntry> List<T> getSubList(List<T> ts, Set<String> keys) {
        ArrayList<KvEntry> update = null;
        for (KvEntry entry : ts) {
            if (!keys.contains(entry.getKey())) continue;
            if (update == null) {
                update = new ArrayList<KvEntry>(ts.size());
            }
            update.add(entry);
        }
        return update;
    }

    private TbEntityUpdatesInfo getEntityUpdatesInfo(EntityId entityId) {
        return this.entityUpdates.computeIfAbsent(entityId, id -> new TbEntityUpdatesInfo(this.initTs));
    }

    private void cleanupEntityUpdates() {
        this.initTs = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L);
        int sizeBeforeCleanup = this.entityUpdates.size();
        this.entityUpdates.entrySet().removeIf(kv -> {
            TbEntityUpdatesInfo v = (TbEntityUpdatesInfo)kv.getValue();
            return this.initTs > v.attributesUpdateTs && this.initTs > v.timeSeriesUpdateTs;
        });
        log.info("Removed {} old entity update records.", (Object)(this.entityUpdates.size() - sizeBeforeCleanup));
    }

    @ConstructorProperties(value={"topicService", "partitionService", "serviceInfoProvider", "producerProvider", "localSubscriptionService", "scheduler"})
    @Generated
    public DefaultSubscriptionManagerService(TopicService topicService, PartitionService partitionService, TbServiceInfoProvider serviceInfoProvider, TbQueueProducerProvider producerProvider, TbLocalSubscriptionService localSubscriptionService, SubscriptionSchedulerComponent scheduler) {
        this.topicService = topicService;
        this.partitionService = partitionService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.producerProvider = producerProvider;
        this.localSubscriptionService = localSubscriptionService;
        this.scheduler = scheduler;
    }
}

