/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.GeneratorTools;
import org.thingsboard.server.service.solutions.data.values.ScheduleValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;
import org.thingsboard.server.service.solutions.data.values.TelemetryGeneratorFactory;
import org.thingsboard.server.service.solutions.data.values.ValueStrategySchedule;

public class ScheduleValueStrategyGenerator
extends TelemetryGenerator {
    private TelemetryGenerator defaultGenerator;
    private TimeZone timeZone;
    private Map<ValueStrategySchedule, TelemetryGenerator> scheduleGenerators;
    private TelemetryGenerator prevGenerator;

    public ScheduleValueStrategyGenerator(TelemetryProfile tp) {
        super(tp);
        ScheduleValueStrategyDefinition def = (ScheduleValueStrategyDefinition)tp.getValueStrategy();
        this.timeZone = TimeZone.getTimeZone(def.getTimeZone());
        this.defaultGenerator = TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), def.getDefaultDefinition()));
        this.scheduleGenerators = new LinkedHashMap();
        for (ValueStrategySchedule scheduleItem : def.getSchedule()) {
            this.scheduleGenerators.put(scheduleItem, TelemetryGeneratorFactory.create((TelemetryProfile)new TelemetryProfile(tp.getKey(), scheduleItem.getDefinition())));
        }
    }

    public void addValue(long ts, ObjectNode values) {
        int hour = GeneratorTools.getHour((TimeZone)this.timeZone, (long)ts);
        int minute = GeneratorTools.getMinute((TimeZone)this.timeZone, (long)ts);
        TelemetryGenerator generator = this.scheduleGenerators.entrySet().stream().filter(pair -> {
            ValueStrategySchedule schedule = (ValueStrategySchedule)pair.getKey();
            if (hour == schedule.getStartHour() && hour == schedule.getEndHour()) {
                return schedule.getStartMinute() <= minute && minute <= schedule.getEndMinute();
            }
            if (hour == schedule.getStartHour() && hour < schedule.getEndHour()) {
                return schedule.getStartMinute() <= minute;
            }
            if (hour > schedule.getStartHour() && hour < schedule.getEndHour()) {
                return true;
            }
            if (hour > schedule.getStartHour() && hour == schedule.getEndHour()) {
                return minute <= schedule.getEndHour();
            }
            return false;
        }).map(Map.Entry::getValue).findFirst().orElse(this.defaultGenerator);
        if (this.prevGenerator != null && !this.prevGenerator.equals((Object)generator)) {
            generator.setValue(this.prevGenerator.getValue());
        }
        generator.addValue(ts, values);
        this.prevGenerator = generator;
    }
}

