/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.values;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;
import org.thingsboard.server.service.solutions.data.values.GeneratorTools;
import org.thingsboard.server.service.solutions.data.values.IncDecValueStrategyDefinition;
import org.thingsboard.server.service.solutions.data.values.TelemetryGenerator;

public abstract class IncDecTelemetryGenerator<T extends IncDecValueStrategyDefinition>
extends TelemetryGenerator {
    protected final T strategy;
    protected double value;
    protected double endValue;

    public IncDecTelemetryGenerator(TelemetryProfile telemetryProfile) {
        super(telemetryProfile);
        this.strategy = (IncDecValueStrategyDefinition)telemetryProfile.getValueStrategy();
        this.value = this.getRandomStartValue();
        this.endValue = this.getRandomEndValue();
    }

    public void setValue(double value) {
        this.value = value;
        this.endValue = this.getRandomEndValue();
    }

    protected void put(ObjectNode values, double value) {
        if (this.strategy.getPrecision() == 0) {
            values.put(this.key, (int)value);
        } else {
            values.put(this.key, BigDecimal.valueOf(value).setScale(this.strategy.getPrecision(), RoundingMode.HALF_UP).doubleValue());
        }
    }

    public double getRandomStartValue() {
        return GeneratorTools.randomDouble((double)this.strategy.getMinStartValue(), (double)this.strategy.getMaxStartValue());
    }

    public double getRandomEndValue() {
        return GeneratorTools.randomDouble((double)this.strategy.getMinEndValue(), (double)this.strategy.getMaxEndValue());
    }

    @Generated
    public double getValue() {
        return this.value;
    }
}

