/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.solution;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.service.solutions.data.solution.SolutionTemplateLevel;

@Schema
public class SolutionTemplate {
    @Schema(description="ID of the solution template", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private String id;
    @Schema(description="Template Title", example="Smart office")
    private String title;
    @Schema(description="Level of the subscription that is required to unlock the template", example="PROTOTYPE")
    private SolutionTemplateLevel level;
    @Schema(description="Timeout for the installation UI to wait while template is installing")
    private long installTimeoutMs;
    @Schema(description="What keys to delete during template uninstall")
    private List<String> tenantTelemetryKeys;
    @Schema(description="What attributes to delete during template uninstall")
    private List<String> tenantAttributeKeys;

    public SolutionTemplate(SolutionTemplate solution) {
        this.id = solution.getId();
        this.title = solution.getTitle();
        this.level = solution.getLevel();
        this.installTimeoutMs = solution.getInstallTimeoutMs();
        this.tenantTelemetryKeys = solution.getTenantTelemetryKeys();
        this.tenantAttributeKeys = solution.getTenantAttributeKeys();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public SolutionTemplateLevel getLevel() {
        return this.level;
    }

    @Generated
    public long getInstallTimeoutMs() {
        return this.installTimeoutMs;
    }

    @Generated
    public List<String> getTenantTelemetryKeys() {
        return this.tenantTelemetryKeys;
    }

    @Generated
    public List<String> getTenantAttributeKeys() {
        return this.tenantAttributeKeys;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setLevel(SolutionTemplateLevel level) {
        this.level = level;
    }

    @Generated
    public void setInstallTimeoutMs(long installTimeoutMs) {
        this.installTimeoutMs = installTimeoutMs;
    }

    @Generated
    public void setTenantTelemetryKeys(List<String> tenantTelemetryKeys) {
        this.tenantTelemetryKeys = tenantTelemetryKeys;
    }

    @Generated
    public void setTenantAttributeKeys(List<String> tenantAttributeKeys) {
        this.tenantAttributeKeys = tenantAttributeKeys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolutionTemplate)) {
            return false;
        }
        SolutionTemplate other = (SolutionTemplate)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getInstallTimeoutMs() != other.getInstallTimeoutMs()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        SolutionTemplateLevel this$level = this.getLevel();
        SolutionTemplateLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        List this$tenantTelemetryKeys = this.getTenantTelemetryKeys();
        List other$tenantTelemetryKeys = other.getTenantTelemetryKeys();
        if (this$tenantTelemetryKeys == null ? other$tenantTelemetryKeys != null : !((Object)this$tenantTelemetryKeys).equals(other$tenantTelemetryKeys)) {
            return false;
        }
        List this$tenantAttributeKeys = this.getTenantAttributeKeys();
        List other$tenantAttributeKeys = other.getTenantAttributeKeys();
        return !(this$tenantAttributeKeys == null ? other$tenantAttributeKeys != null : !((Object)this$tenantAttributeKeys).equals(other$tenantAttributeKeys));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolutionTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $installTimeoutMs = this.getInstallTimeoutMs();
        result = result * 59 + (int)($installTimeoutMs >>> 32 ^ $installTimeoutMs);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        SolutionTemplateLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        List $tenantTelemetryKeys = this.getTenantTelemetryKeys();
        result = result * 59 + ($tenantTelemetryKeys == null ? 43 : ((Object)$tenantTelemetryKeys).hashCode());
        List $tenantAttributeKeys = this.getTenantAttributeKeys();
        result = result * 59 + ($tenantAttributeKeys == null ? 43 : ((Object)$tenantAttributeKeys).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolutionTemplate(id=" + this.getId() + ", title=" + this.getTitle() + ", level=" + String.valueOf(this.getLevel()) + ", installTimeoutMs=" + this.getInstallTimeoutMs() + ", tenantTelemetryKeys=" + String.valueOf(this.getTenantTelemetryKeys()) + ", tenantAttributeKeys=" + String.valueOf(this.getTenantAttributeKeys()) + ")";
    }

    @Generated
    public SolutionTemplate() {
    }
}

