/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.emulator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.solutions.data.definition.EmulatorDefinition;
import org.thingsboard.server.service.solutions.data.emulator.BasicEmulator;
import org.thingsboard.server.service.solutions.data.emulator.CustomEmulator;
import org.thingsboard.server.service.solutions.data.emulator.Emulator;
import org.thingsboard.server.service.solutions.data.emulator.SimpleEmulator;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class AbstractEmulatorLauncher<T extends GroupEntity<?>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEmulatorLauncher.class);
    protected static final TbQueueCallback EMPTY_CALLBACK = new /* Unavailable Anonymous Inner Class!! */;
    protected final T entity;
    protected final EmulatorDefinition emulatorDefinition;
    protected final ExecutorService oldTelemetryExecutor;
    protected final TbClusterService tbClusterService;
    protected final PartitionService partitionService;
    protected final TbQueueProducerProvider tbQueueProducerProvider;
    protected final TbServiceInfoProvider serviceInfoProvider;
    protected final TelemetrySubscriptionService tsSubService;
    protected final long publishFrequency;
    private final Emulator emulator;
    private ScheduledFuture<?> scheduledFuture;

    public AbstractEmulatorLauncher(T entity, EmulatorDefinition emulatorDefinition, ExecutorService oldTelemetryExecutor, TbClusterService tbClusterService, PartitionService partitionService, TbQueueProducerProvider tbQueueProducerProvider, TbServiceInfoProvider serviceInfoProvider, TelemetrySubscriptionService tsSubService) throws Exception {
        this.entity = entity;
        this.emulatorDefinition = emulatorDefinition;
        this.oldTelemetryExecutor = oldTelemetryExecutor;
        this.tbClusterService = tbClusterService;
        this.partitionService = partitionService;
        this.tbQueueProducerProvider = tbQueueProducerProvider;
        this.serviceInfoProvider = serviceInfoProvider;
        this.tsSubService = tsSubService;
        this.publishFrequency = TimeUnit.SECONDS.toMillis(Math.max(emulatorDefinition.getPublishFrequencyInSeconds(), 1));
        this.emulator = StringUtils.isEmpty((String)emulatorDefinition.getClazz()) ? new BasicEmulator() : (Emulator)Class.forName(emulatorDefinition.getClazz()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.emulator.init(emulatorDefinition);
    }

    public void launch() {
        long latestTs = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.emulatorDefinition.getPublishPeriodInDays()) - this.publishFrequency;
        this.oldTelemetryExecutor.submit(() -> {
            try {
                if (this.emulator instanceof SimpleEmulator) {
                    if (latestTs < System.currentTimeMillis() - this.publishFrequency) {
                        this.pushOldTelemetry(latestTs);
                    }
                } else if (this.emulator instanceof CustomEmulator) {
                    Pair telemetry = ((CustomEmulator)this.emulator).getNextValue();
                    while (telemetry != null) {
                        this.publishTelemetry(((Long)telemetry.getFirst()).longValue(), (ObjectNode)telemetry.getSecond());
                        telemetry = ((CustomEmulator)this.emulator).getNextValue();
                    }
                }
                this.postProcessEntity(this.entity);
            }
            catch (Exception e) {
                log.warn("[{}] Failed to upload telemetry for device: ", (Object)this.entity.getName(), (Object)e);
            }
        });
    }

    protected void postProcessEntity(T entity) {
    }

    private void pushOldTelemetry(long latestTs) throws InterruptedException {
        for (long ts = latestTs; ts < System.currentTimeMillis(); ts += this.publishFrequency) {
            this.publishTelemetry(ts);
        }
    }

    private void publishTelemetry(long ts) throws InterruptedException {
        ObjectNode values = ((SimpleEmulator)this.emulator).getValue(ts);
        this.publishTelemetry(ts, values);
        Thread.sleep(this.emulatorDefinition.getPublishPauseInMillis());
    }

    public void stop() {
        this.scheduledFuture.cancel(true);
    }

    private void publishTelemetry(long ts, ObjectNode value) {
        String msgData = JacksonUtil.toString((Object)value);
        log.debug("[{}] Publishing telemetry: {}", (Object)this.entity.getName(), (Object)msgData);
        TbMsgMetaData md = new TbMsgMetaData();
        md.putValue("ts", Long.toString(ts));
        TbMsg tbMsg = TbMsg.newMsg().type(TbMsgType.POST_TELEMETRY_REQUEST).originator((EntityId)this.entity.getId()).copyMetaData(md).dataType(TbMsgDataType.JSON).data(msgData).build();
        this.tbClusterService.pushMsgToRuleEngine(this.entity.getTenantId(), (EntityId)this.entity.getId(), tbMsg, null);
    }

    @Generated
    public T getEntity() {
        return (T)this.entity;
    }

    @Generated
    public EmulatorDefinition getEmulatorDefinition() {
        return this.emulatorDefinition;
    }

    @Generated
    public ExecutorService getOldTelemetryExecutor() {
        return this.oldTelemetryExecutor;
    }

    @Generated
    public TbClusterService getTbClusterService() {
        return this.tbClusterService;
    }

    @Generated
    public PartitionService getPartitionService() {
        return this.partitionService;
    }

    @Generated
    public TbQueueProducerProvider getTbQueueProducerProvider() {
        return this.tbQueueProducerProvider;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    @Generated
    public TelemetrySubscriptionService getTsSubService() {
        return this.tsSubService;
    }

    @Generated
    public long getPublishFrequency() {
        return this.publishFrequency;
    }

    @Generated
    public Emulator getEmulator() {
        return this.emulator;
    }

    @Generated
    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    @Generated
    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEmulatorLauncher)) {
            return false;
        }
        AbstractEmulatorLauncher other = (AbstractEmulatorLauncher)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPublishFrequency() != other.getPublishFrequency()) {
            return false;
        }
        GroupEntity this$entity = this.getEntity();
        GroupEntity other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        EmulatorDefinition this$emulatorDefinition = this.getEmulatorDefinition();
        EmulatorDefinition other$emulatorDefinition = other.getEmulatorDefinition();
        if (this$emulatorDefinition == null ? other$emulatorDefinition != null : !this$emulatorDefinition.equals(other$emulatorDefinition)) {
            return false;
        }
        ExecutorService this$oldTelemetryExecutor = this.getOldTelemetryExecutor();
        ExecutorService other$oldTelemetryExecutor = other.getOldTelemetryExecutor();
        if (this$oldTelemetryExecutor == null ? other$oldTelemetryExecutor != null : !this$oldTelemetryExecutor.equals(other$oldTelemetryExecutor)) {
            return false;
        }
        TbClusterService this$tbClusterService = this.getTbClusterService();
        TbClusterService other$tbClusterService = other.getTbClusterService();
        if (this$tbClusterService == null ? other$tbClusterService != null : !this$tbClusterService.equals(other$tbClusterService)) {
            return false;
        }
        PartitionService this$partitionService = this.getPartitionService();
        PartitionService other$partitionService = other.getPartitionService();
        if (this$partitionService == null ? other$partitionService != null : !this$partitionService.equals(other$partitionService)) {
            return false;
        }
        TbQueueProducerProvider this$tbQueueProducerProvider = this.getTbQueueProducerProvider();
        TbQueueProducerProvider other$tbQueueProducerProvider = other.getTbQueueProducerProvider();
        if (this$tbQueueProducerProvider == null ? other$tbQueueProducerProvider != null : !this$tbQueueProducerProvider.equals(other$tbQueueProducerProvider)) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        if (this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider)) {
            return false;
        }
        TelemetrySubscriptionService this$tsSubService = this.getTsSubService();
        TelemetrySubscriptionService other$tsSubService = other.getTsSubService();
        if (this$tsSubService == null ? other$tsSubService != null : !this$tsSubService.equals(other$tsSubService)) {
            return false;
        }
        Emulator this$emulator = this.getEmulator();
        Emulator other$emulator = other.getEmulator();
        if (this$emulator == null ? other$emulator != null : !this$emulator.equals(other$emulator)) {
            return false;
        }
        ScheduledFuture this$scheduledFuture = this.getScheduledFuture();
        ScheduledFuture other$scheduledFuture = other.getScheduledFuture();
        return !(this$scheduledFuture == null ? other$scheduledFuture != null : !this$scheduledFuture.equals(other$scheduledFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractEmulatorLauncher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $publishFrequency = this.getPublishFrequency();
        result = result * 59 + (int)($publishFrequency >>> 32 ^ $publishFrequency);
        GroupEntity $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        EmulatorDefinition $emulatorDefinition = this.getEmulatorDefinition();
        result = result * 59 + ($emulatorDefinition == null ? 43 : $emulatorDefinition.hashCode());
        ExecutorService $oldTelemetryExecutor = this.getOldTelemetryExecutor();
        result = result * 59 + ($oldTelemetryExecutor == null ? 43 : $oldTelemetryExecutor.hashCode());
        TbClusterService $tbClusterService = this.getTbClusterService();
        result = result * 59 + ($tbClusterService == null ? 43 : $tbClusterService.hashCode());
        PartitionService $partitionService = this.getPartitionService();
        result = result * 59 + ($partitionService == null ? 43 : $partitionService.hashCode());
        TbQueueProducerProvider $tbQueueProducerProvider = this.getTbQueueProducerProvider();
        result = result * 59 + ($tbQueueProducerProvider == null ? 43 : $tbQueueProducerProvider.hashCode());
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        TelemetrySubscriptionService $tsSubService = this.getTsSubService();
        result = result * 59 + ($tsSubService == null ? 43 : $tsSubService.hashCode());
        Emulator $emulator = this.getEmulator();
        result = result * 59 + ($emulator == null ? 43 : $emulator.hashCode());
        ScheduledFuture $scheduledFuture = this.getScheduledFuture();
        result = result * 59 + ($scheduledFuture == null ? 43 : $scheduledFuture.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractEmulatorLauncher(entity=" + String.valueOf(this.getEntity()) + ", emulatorDefinition=" + String.valueOf(this.getEmulatorDefinition()) + ", oldTelemetryExecutor=" + String.valueOf(this.getOldTelemetryExecutor()) + ", tbClusterService=" + String.valueOf(this.getTbClusterService()) + ", partitionService=" + String.valueOf(this.getPartitionService()) + ", tbQueueProducerProvider=" + String.valueOf(this.getTbQueueProducerProvider()) + ", serviceInfoProvider=" + String.valueOf(this.getServiceInfoProvider()) + ", tsSubService=" + String.valueOf(this.getTsSubService()) + ", publishFrequency=" + this.getPublishFrequency() + ", emulator=" + String.valueOf(this.getEmulator()) + ", scheduledFuture=" + String.valueOf(this.getScheduledFuture()) + ")";
    }
}

