/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceInfoFilter;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.MergedGroupTypePermissionInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.eventsourcing.ActionEntityEvent;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.owner.OwnerService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.DefaultOwnersCacheService;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Service
public class DefaultOwnersCacheService
implements OwnersCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOwnersCacheService.class);
    @Autowired
    private EntityGroupService entityGroupService;
    @Autowired
    private OwnerService ownerService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private EntityViewService entityViewService;
    @Autowired
    private EdgeService edgeService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    protected UserPermissionsService userPermissionsService;

    public Set<EntityId> fetchOwnersHierarchy(TenantId tenantId, EntityId entityId) {
        return this.ownerService.fetchOwnersHierarchy(tenantId, entityId);
    }

    public Set<EntityId> getOwners(TenantId tenantId, EntityId entityId, HasOwnerId hasOwnerId) {
        return this.ownerService.getOwners(tenantId, entityId, hasOwnerId);
    }

    public Set<EntityId> getOwners(TenantId tenantId, EntityGroupId entityGroupId) {
        return this.ownerService.getOwners(tenantId, entityGroupId);
    }

    public EntityId getOwner(TenantId tenantId, EntityId entityId) {
        return this.ownerService.getOwner(tenantId, entityId);
    }

    public void clearOwners(EntityId entityId) {
        this.ownerService.clearOwners(entityId);
    }

    public Set<EntityId> getChildOwners(TenantId tenantId, EntityId parentOwnerId) {
        HashSet<EntityId> result = new HashSet<EntityId>();
        try {
            this.fetchChildOwners(tenantId, parentOwnerId, result);
        }
        catch (Exception e) {
            log.error("Failed to get child owners by parentOwnerId [{}]", (Object)parentOwnerId, (Object)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public void changeDashboardOwner(TenantId tenantId, EntityId targetOwnerId, Dashboard dashboard) throws ThingsboardException {
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)dashboard.getId(), (HasOwnerId)dashboard, arg_0 -> ((DashboardService)this.dashboardService).saveDashboard(arg_0));
    }

    public void changeUserOwner(TenantId tenantId, EntityId targetOwnerId, User user) throws ThingsboardException {
        this.userPermissionsService.onUserUpdatedOrRemoved(user);
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)user.getId(), (HasOwnerId)user, targetUser -> this.userService.changeOwner(targetUser, targetOwnerId));
    }

    public void changeCustomerOwner(TenantId tenantId, EntityId targetOwnerId, Customer customer) throws ThingsboardException {
        if (customer.isPublic()) {
            throw new ThingsboardException("Public customer owner can't be changed!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        Set childOwnerIds = this.getChildOwners(tenantId, (EntityId)customer.getId());
        if (childOwnerIds.contains(targetOwnerId)) {
            throw new ThingsboardException("Owner of the Customer can't be changed to its Sub-Customer!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)customer.getId(), (HasOwnerId)customer, arg_0 -> ((CustomerService)this.customerService).saveCustomer(arg_0));
    }

    public void changeEntityViewOwner(TenantId tenantId, EntityId targetOwnerId, EntityView entityView) throws ThingsboardException {
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)entityView.getId(), (HasOwnerId)entityView, arg_0 -> ((EntityViewService)this.entityViewService).saveEntityView(arg_0));
    }

    public void changeEdgeOwner(TenantId tenantId, EntityId targetOwnerId, Edge edge) throws ThingsboardException {
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)edge.getId(), (HasOwnerId)edge, e -> this.edgeService.saveEdge(e));
    }

    public void changeAssetOwner(TenantId tenantId, EntityId targetOwnerId, Asset asset) throws ThingsboardException {
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)asset.getId(), (HasOwnerId)asset, arg_0 -> ((AssetService)this.assetService).saveAsset(arg_0));
    }

    public void changeDeviceOwner(TenantId tenantId, EntityId targetOwnerId, Device device) throws ThingsboardException {
        this.changeEntityOwner(tenantId, targetOwnerId, (EntityId)device.getId(), (HasOwnerId)device, d -> this.deviceService.saveDevice(d));
    }

    @Transactional
    public void changeEntityOwner(TenantId tenantId, EntityId targetOwnerId, EntityId entityId) throws ThingsboardException {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 1: {
                this.changeDeviceOwner(tenantId, targetOwnerId, this.getDeviceById(tenantId, entityId));
                break;
            }
            case 2: {
                this.changeAssetOwner(tenantId, targetOwnerId, this.getAssetById(tenantId, entityId));
                break;
            }
            case 3: {
                this.changeCustomerOwner(tenantId, targetOwnerId, this.getCustomerById(tenantId, entityId));
                break;
            }
            case 4: {
                this.changeUserOwner(tenantId, targetOwnerId, this.getUserById(tenantId, entityId));
                break;
            }
            case 5: {
                this.changeDashboardOwner(tenantId, targetOwnerId, this.getDashboardById(tenantId, entityId));
                break;
            }
            case 6: {
                this.changeEntityViewOwner(tenantId, targetOwnerId, this.getEntityViewById(tenantId, entityId));
                break;
            }
            case 7: {
                this.changeEdgeOwner(tenantId, targetOwnerId, this.getEdgeById(tenantId, entityId));
                break;
            }
            default: {
                throw new RuntimeException("EntityType does not support owner change: " + String.valueOf(entityId.getEntityType()));
            }
        }
    }

    public boolean isChildOwner(TenantId tenantId, CustomerId parentOwnerId, CustomerId childOwnerId) {
        return this.getChildOwners(tenantId, (EntityId)parentOwnerId).stream().anyMatch(arg_0 -> ((CustomerId)childOwnerId).equals(arg_0));
    }

    public <E extends BaseData<? extends UUIDBased>> PageData<E> getGroupEntities(TenantId tenantId, SecurityUser securityUser, EntityType entityType, Operation operation, PageLink pageLink, Function<List<EntityGroupId>, PageData<E>> getEntitiesFunction) throws Exception {
        Resource resource = Resource.resourceFromEntityType((EntityType)entityType);
        if (Authority.TENANT_ADMIN.equals((Object)securityUser.getAuthority()) && securityUser.getUserPermissions().hasGenericPermission(resource, operation)) {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityType.ordinal()]) {
                case 1: {
                    return this.deviceService.findDevicesByTenantId(tenantId, pageLink);
                }
                case 2: {
                    return this.assetService.findAssetsByTenantId(tenantId, pageLink);
                }
                case 3: {
                    return this.customerService.findCustomersByTenantId(tenantId, pageLink);
                }
                case 4: {
                    return this.userService.findUsersByTenantId(tenantId, pageLink);
                }
                case 5: {
                    return this.dashboardService.findDashboardsByTenantId(tenantId, pageLink);
                }
                case 6: {
                    return this.entityViewService.findEntityViewByTenantId(tenantId, pageLink);
                }
                case 7: {
                    return this.edgeService.findEdgesByTenantId(tenantId, pageLink);
                }
            }
            throw new RuntimeException("EntityType does not supported: " + String.valueOf(entityType));
        }
        List groupIds = this.getAllowedEntityGroupIds(tenantId, securityUser, entityType, operation);
        if (!groupIds.isEmpty()) {
            return getEntitiesFunction.apply(groupIds);
        }
        return PageData.emptyPageData();
    }

    private List<EntityGroupId> getAllowedEntityGroupIds(TenantId tenantId, SecurityUser securityUser, EntityType entityType, Operation operation) {
        MergedGroupTypePermissionInfo groupTypePermissionInfo = null;
        if (operation == Operation.READ) {
            groupTypePermissionInfo = (MergedGroupTypePermissionInfo)securityUser.getUserPermissions().getReadGroupPermissions().get(entityType);
        }
        Resource resource = Resource.resourceFromEntityType((EntityType)entityType);
        if (securityUser.getUserPermissions().hasGenericPermission(resource, operation) || groupTypePermissionInfo != null && !groupTypePermissionInfo.getEntityGroupIds().isEmpty()) {
            HashSet groupIds = new HashSet();
            if (securityUser.getUserPermissions().hasGenericPermission(resource, operation)) {
                Set ownerIds = this.getChildOwners(tenantId, securityUser.getOwnerId());
                for (EntityId ownerId : ownerIds) {
                    Optional entityGroup = this.entityGroupService.findEntityGroupByTypeAndName(tenantId, ownerId, entityType, "All");
                    entityGroup.ifPresent(group -> groupIds.add(group.getId()));
                }
            }
            if (groupTypePermissionInfo != null && !groupTypePermissionInfo.getEntityGroupIds().isEmpty()) {
                groupIds.addAll(groupTypePermissionInfo.getEntityGroupIds());
            }
            return new ArrayList<EntityGroupId>(groupIds);
        }
        return Collections.emptyList();
    }

    private Device getDeviceById(TenantId tenantId, EntityId entityId) {
        return this.deviceService.findDeviceById(tenantId, new DeviceId(entityId.getId()));
    }

    private Asset getAssetById(TenantId tenantId, EntityId entityId) {
        return this.assetService.findAssetById(tenantId, new AssetId(entityId.getId()));
    }

    private Customer getCustomerById(TenantId tenantId, EntityId entityId) {
        return this.customerService.findCustomerById(tenantId, new CustomerId(entityId.getId()));
    }

    private User getUserById(TenantId tenantId, EntityId entityId) {
        return this.userService.findUserById(tenantId, new UserId(entityId.getId()));
    }

    private Dashboard getDashboardById(TenantId tenantId, EntityId entityId) {
        return this.dashboardService.findDashboardById(tenantId, new DashboardId(entityId.getId()));
    }

    private EntityView getEntityViewById(TenantId tenantId, EntityId entityId) {
        return this.entityViewService.findEntityViewById(tenantId, new EntityViewId(entityId.getId()));
    }

    private Edge getEdgeById(TenantId tenantId, EntityId entityId) {
        return this.edgeService.findEdgeById(tenantId, new EdgeId(entityId.getId()));
    }

    private void fetchChildOwners(TenantId tenantId, EntityId entityId, Set<EntityId> result) throws Exception {
        result.add(entityId);
        Optional entityGroup = this.entityGroupService.findEntityGroupByTypeAndName(tenantId, entityId, EntityType.CUSTOMER, "All");
        if (entityGroup.isPresent()) {
            List childOwnerIds = (List)this.entityGroupService.findAllEntityIdsAsync(tenantId, ((EntityGroup)entityGroup.get()).getId(), new PageLink(Integer.MAX_VALUE)).get();
            for (EntityId ownerId : childOwnerIds) {
                this.fetchChildOwners(tenantId, ownerId, result);
            }
        }
    }

    public void changeEntityOwner(TenantId tenantId, EntityId entityId, EntityId targetOwnerId, EntityId currentOwnerId) throws ThingsboardException {
        if (targetOwnerId.equals(currentOwnerId)) {
            throw new ThingsboardException("Entity already belongs to this owner!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.deleteFromGroupsAndAddToGroupAll(tenantId, entityId, targetOwnerId);
        this.clearOwners(entityId);
    }

    private <T extends HasOwnerId> void changeEntityOwner(TenantId tenantId, EntityId targetOwnerId, EntityId entityId, T entity, Consumer<T> saveFunction) throws ThingsboardException {
        if (entity.getOwnerId().equals(targetOwnerId)) {
            throw new ThingsboardException("Entity already belongs to this owner!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.deleteFromGroupsAndAddToGroupAll(tenantId, entityId, targetOwnerId);
        EntityId previousOwnerId = entity.getOwnerId();
        entity.setOwnerId(targetOwnerId);
        saveFunction.accept(entity);
        this.clearOwners(entityId);
        this.eventPublisher.publishEvent((Object)ActionEntityEvent.builder().tenantId(tenantId).entityId(entityId).body(JacksonUtil.toString((Object)previousOwnerId)).actionType(ActionType.CHANGE_OWNER).build());
    }

    private void deleteFromGroupsAndAddToGroupAll(TenantId tenantId, EntityId entityId, EntityId targetOwnerId) throws ThingsboardException {
        List entityGroupList;
        try {
            entityGroupList = (List)this.entityGroupService.findEntityGroupsForEntityAsync(tenantId, entityId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
        for (EntityGroupId entityGroupId : entityGroupList) {
            this.entityGroupService.removeEntityFromEntityGroup(tenantId, entityGroupId, entityId);
        }
        this.entityGroupService.addEntityToEntityGroupAll(tenantId, targetOwnerId, entityId);
    }

    public Set<EntityId> getOwnedEntities(TenantId tenantId, EntityId ownerId) {
        HashSet<EntityId> ownerEntities = new HashSet<EntityId>();
        if (EntityType.CUSTOMER.equals((Object)ownerId.getEntityType())) {
            PageDataIterable deviceIdInfos = new PageDataIterable(pageLink -> this.deviceService.findDeviceInfosByFilter(DeviceInfoFilter.builder().tenantId(tenantId).customerId((CustomerId)ownerId).build(), pageLink), 1000);
            deviceIdInfos.forEach(deviceInfo -> ownerEntities.add((EntityId)deviceInfo.getId()));
            PageDataIterable assets = new PageDataIterable(pageLink -> this.assetService.findAssetsByTenantIdAndCustomerId(tenantId, (CustomerId)ownerId, pageLink), 1000);
            assets.forEach(asset -> ownerEntities.add((EntityId)asset.getId()));
        } else if (EntityType.TENANT.equals((Object)ownerId.getEntityType())) {
            PageDataIterable deviceIdInfos = new PageDataIterable(pageLink -> this.deviceService.findDeviceInfosByFilter(DeviceInfoFilter.builder().tenantId((TenantId)ownerId).customerId(new CustomerId(CustomerId.NULL_UUID)).build(), pageLink), 1000);
            deviceIdInfos.forEach(deviceInfo -> ownerEntities.add((EntityId)deviceInfo.getId()));
            PageDataIterable assets = new PageDataIterable(pageLink -> this.assetService.findAssetsByTenantIdAndCustomerId((TenantId)ownerId, new CustomerId(CustomerId.NULL_UUID), pageLink), 1000);
            assets.forEach(asset -> ownerEntities.add((EntityId)asset.getId()));
        }
        return ownerEntities;
    }
}

