/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.menu.CustomMenuInfo;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.PermissionChecker;
import org.thingsboard.server.service.security.permission.Permissions;

@Service
public class DefaultAccessControlService
implements AccessControlService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessControlService.class);
    private static final String YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION = "You don't have permission to perform this operation!";
    private final Map<Authority, Permissions> authorityPermissions = new HashMap();

    public DefaultAccessControlService(@Qualifier(value="sysAdminPermissions") Permissions sysAdminPermissions, @Qualifier(value="tenantAdminPermissions") Permissions tenantAdminPermissions, @Qualifier(value="customerUserPermissions") Permissions customerUserPermissions) {
        this.authorityPermissions.put(Authority.SYS_ADMIN, sysAdminPermissions);
        this.authorityPermissions.put(Authority.TENANT_ADMIN, tenantAdminPermissions);
        this.authorityPermissions.put(Authority.CUSTOMER_USER, customerUserPermissions);
    }

    public void checkPermission(SecurityUser user, Resource resource, Operation operation) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource, true);
        if (!permissionChecker.hasPermission(user, resource, operation)) {
            this.genericOperationPermissionDenied(resource, operation);
        }
    }

    public boolean hasPermission(SecurityUser user, Resource resource, Operation operation) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource, false);
        if (permissionChecker != null) {
            return permissionChecker.hasPermission(user, resource, operation);
        }
        return false;
    }

    public <I extends EntityId, T extends TenantEntity> void checkPermission(SecurityUser user, Resource resource, Operation operation, I entityId, T entity) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource, true);
        if (!permissionChecker.hasPermission(user, operation, entityId, entity)) {
            this.entityOperationPermissionDenied(resource, operation, entityId, entity);
        }
    }

    public <I extends EntityId, T extends TenantEntity> void checkPermission(SecurityUser user, Resource resource, Operation operation, I entityId, T entity, EntityGroupId entityGroupId) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource, true);
        if (!permissionChecker.hasPermission(user, operation, entityId, entity, entityGroupId)) {
            this.entityOperationPermissionDenied(resource, operation, entityId, entity);
        }
    }

    public <I extends EntityId, T extends TenantEntity> boolean hasPermission(SecurityUser user, Resource resource, Operation operation, I entityId, T entity) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource, false);
        if (permissionChecker != null) {
            return permissionChecker.hasPermission(user, operation, entityId, entity);
        }
        return false;
    }

    public void checkEntityGroupPermission(SecurityUser user, Operation operation, EntityGroup entityGroup) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), Resource.groupResourceFromGroupType((EntityType)entityGroup.getType()), true);
        if (!permissionChecker.hasEntityGroupPermission(user, operation, entityGroup)) {
            this.entityGroupOperationPermissionDenied(operation, entityGroup);
        }
    }

    public void checkEntityGroupInfoPermission(SecurityUser user, Operation operation, EntityGroupInfo entityGroup) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), Resource.groupResourceFromGroupType((EntityType)entityGroup.getType()), true);
        if (!permissionChecker.hasEntityGroupInfoPermission(user, operation, entityGroup)) {
            this.entityGroupOperationPermissionDenied(operation, (EntityGroup)entityGroup);
        }
    }

    public void checkCustomMenuPermission(SecurityUser user, Operation operation, CustomMenuInfo customMenu) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), Resource.CUSTOM_MENU, true);
        if (!permissionChecker.hasCustomMenuPermission(user, operation, customMenu)) {
            this.customMenuOperationPermissionDenied(operation, customMenu);
        }
    }

    public boolean hasEntityGroupPermission(SecurityUser user, Operation operation, EntityGroup entityGroup) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), Resource.groupResourceFromGroupType((EntityType)entityGroup.getType()), false);
        if (permissionChecker != null) {
            return permissionChecker.hasEntityGroupPermission(user, operation, entityGroup);
        }
        return false;
    }

    public boolean hasEntityGroupInfoPermission(SecurityUser user, Operation operation, EntityGroupInfo entityGroup) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), Resource.groupResourceFromGroupType((EntityType)entityGroup.getType()), false);
        if (permissionChecker != null) {
            return permissionChecker.hasEntityGroupInfoPermission(user, operation, entityGroup);
        }
        return false;
    }

    private PermissionChecker getPermissionChecker(Authority authority, Resource resource, boolean throwException) throws ThingsboardException {
        Optional permissionChecker;
        Permissions permissions = (Permissions)this.authorityPermissions.get(authority);
        if (permissions == null) {
            if (throwException) {
                this.permissionDenied();
            } else {
                return null;
            }
        }
        if (!(permissionChecker = permissions.getPermissionChecker(resource)).isPresent()) {
            if (throwException) {
                this.permissionDenied();
            } else {
                return null;
            }
        }
        return (PermissionChecker)permissionChecker.get();
    }

    private void permissionDenied() throws ThingsboardException {
        throw new ThingsboardException(YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION, ThingsboardErrorCode.PERMISSION_DENIED);
    }

    private void genericOperationPermissionDenied(Resource resource, Operation operation) throws ThingsboardException {
        throw new ThingsboardException("You don't have permission to perform '" + String.valueOf(operation) + "' operation with '" + String.valueOf(resource) + "' resource!", ThingsboardErrorCode.PERMISSION_DENIED);
    }

    private <I extends EntityId, T extends TenantEntity> void entityOperationPermissionDenied(Resource resource, Operation operation, I entityId, T entity) throws ThingsboardException {
        EntityType entityType = entity != null ? entity.getEntityType() : entityId.getEntityType();
        String message = "You don't have permission to perform '" + String.valueOf(operation) + "' operation with " + String.valueOf(entityType);
        if (entity instanceof HasName) {
            message = message + " '" + ((HasName)entity).getName() + "'";
        }
        message = message + "!";
        throw new ThingsboardException(message, ThingsboardErrorCode.PERMISSION_DENIED);
    }

    private void entityGroupOperationPermissionDenied(Operation operation, EntityGroup entityGroup) throws ThingsboardException {
        throw new ThingsboardException("You don't have permission to perform '" + String.valueOf(operation) + "' operation with " + String.valueOf(entityGroup.getType()) + " group '" + entityGroup.getName() + "'!", ThingsboardErrorCode.PERMISSION_DENIED);
    }

    private void customMenuOperationPermissionDenied(Operation operation, CustomMenuInfo customMenuInfo) throws ThingsboardException {
        throw new ThingsboardException("You don't have permission to perform '" + String.valueOf(operation) + "' operation with custom menu '" + customMenuInfo.getName() + "'!", ThingsboardErrorCode.PERMISSION_DENIED);
    }
}

