/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.rest;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.MfaAuthenticationToken;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.exception.UserPasswordNotValidException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.permission.UserPermissionsService;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Component
@TbCoreComponent
public class RestAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationProvider.class);
    private final SystemSecurityService systemSecurityService;
    private final SecuritySettingsService securitySettingsService;
    private final UserService userService;
    private final CustomerService customerService;
    private final UserPermissionsService userPermissionsService;
    private final TwoFactorAuthService twoFactorAuthService;

    @Autowired
    public RestAuthenticationProvider(UserService userService, CustomerService customerService, UserPermissionsService userPermissionsService, SystemSecurityService systemSecurityService, SecuritySettingsService securitySettingsService, TwoFactorAuthService twoFactorAuthService) {
        this.userService = userService;
        this.customerService = customerService;
        this.userPermissionsService = userPermissionsService;
        this.systemSecurityService = systemSecurityService;
        this.securitySettingsService = securitySettingsService;
        this.twoFactorAuthService = twoFactorAuthService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SecurityUser securityUser;
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof UserPrincipal)) {
            throw new BadCredentialsException("Authentication Failed. Bad user principal.");
        }
        UserPrincipal userPrincipal = (UserPrincipal)principal;
        if (userPrincipal.getType() == UserPrincipal.Type.USER_NAME) {
            String username = userPrincipal.getValue();
            String password = (String)authentication.getCredentials();
            SecuritySettings securitySettings = this.securitySettingsService.getSecuritySettings();
            UserPasswordPolicy passwordPolicy = securitySettings.getPasswordPolicy();
            if (Boolean.TRUE.equals(passwordPolicy.getForceUserToResetPasswordIfNotValid())) {
                try {
                    this.systemSecurityService.validatePasswordByPolicy(password, passwordPolicy);
                }
                catch (DataValidationException e) {
                    throw new UserPasswordNotValidException("The entered password violates our policies. If this is your real password, please reset it.");
                }
            }
            if (this.twoFactorAuthService.isTwoFaEnabled((securityUser = this.authenticateByUsernameAndPassword(authentication, userPrincipal, username, password)).getTenantId(), securityUser.getId())) {
                return new MfaAuthenticationToken(securityUser);
            }
            this.systemSecurityService.logLoginAction((User)securityUser, authentication.getDetails(), ActionType.LOGIN, null);
        } else {
            String publicId = userPrincipal.getValue();
            securityUser = this.authenticateByPublicId(userPrincipal, publicId);
        }
        return new UsernamePasswordAuthenticationToken((Object)securityUser, null, securityUser.getAuthorities());
    }

    private SecurityUser authenticateByUsernameAndPassword(Authentication authentication, UserPrincipal userPrincipal, String username, String password) {
        User user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, username);
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username);
        }
        try {
            UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(TenantId.SYS_TENANT_ID, user.getId());
            if (userCredentials == null) {
                throw new UsernameNotFoundException("User credentials not found");
            }
            try {
                this.systemSecurityService.validateUserCredentials(user.getTenantId(), userCredentials, username, password);
            }
            catch (LockedException e) {
                this.systemSecurityService.logLoginAction(user, authentication.getDetails(), ActionType.LOCKOUT, null);
                throw e;
            }
            if (user.getAuthority() == null) {
                throw new InsufficientAuthenticationException("User has no authority assigned");
            }
            return new SecurityUser(user, userCredentials.isEnabled(), userPrincipal, this.getMergedUserPermissions(user, false));
        }
        catch (Exception e) {
            this.systemSecurityService.logLoginAction(user, authentication.getDetails(), ActionType.LOGIN, e);
            throw e;
        }
    }

    private SecurityUser authenticateByPublicId(UserPrincipal userPrincipal, String publicId) {
        CustomerId customerId;
        try {
            customerId = new CustomerId(UUID.fromString(publicId));
        }
        catch (Exception e) {
            throw new BadCredentialsException("Authentication Failed. Public Id is not valid.");
        }
        Customer publicCustomer = this.customerService.findCustomerById(TenantId.SYS_TENANT_ID, customerId);
        if (publicCustomer == null) {
            throw new UsernameNotFoundException("Public entity not found: " + publicId);
        }
        if (!publicCustomer.isPublic()) {
            throw new BadCredentialsException("Authentication Failed. Public Id is not valid.");
        }
        User user = new User(new UserId(EntityId.NULL_UUID));
        user.setTenantId(publicCustomer.getTenantId());
        user.setCustomerId(publicCustomer.getId());
        user.setEmail(publicId);
        user.setAuthority(Authority.CUSTOMER_USER);
        user.setFirstName("Public");
        user.setLastName("Public");
        return new SecurityUser(user, true, userPrincipal, this.getMergedUserPermissions(user, true));
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    protected MergedUserPermissions getMergedUserPermissions(User user, boolean isPublic) {
        try {
            return this.userPermissionsService.getMergedPermissions(user, isPublic);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
        }
    }
}

