/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.stereotype.Component;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.CookieUtils;

@Component
@TbCoreComponent
public class HttpCookieOAuth2AuthorizationRequestRepository
implements AuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    public static final String OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME = "oauth2_auth_request";
    public static final String PREV_URI_PARAMETER = "prevUri";
    public static final String PREV_URI_COOKIE_NAME = "prev_uri";
    private static final int cookieExpireSeconds = 180;

    public OAuth2AuthorizationRequest loadAuthorizationRequest(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME).map(cookie -> (OAuth2AuthorizationRequest)CookieUtils.deserialize((Cookie)cookie, OAuth2AuthorizationRequest.class)).orElse(null);
    }

    public void saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, HttpServletRequest request, HttpServletResponse response) {
        if (authorizationRequest == null) {
            CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME);
            return;
        }
        if (request.getParameter(PREV_URI_PARAMETER) != null) {
            CookieUtils.addCookie((HttpServletResponse)response, (String)PREV_URI_COOKIE_NAME, (String)request.getParameter(PREV_URI_PARAMETER), (int)180);
        }
        CookieUtils.addCookie((HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME, (String)CookieUtils.serialize((Object)authorizationRequest), (int)180);
    }

    public OAuth2AuthorizationRequest removeAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.loadAuthorizationRequest(request);
    }

    public void removeAuthorizationRequestCookies(HttpServletRequest request, HttpServletResponse response) {
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)OAUTH2_AUTHORIZATION_REQUEST_COOKIE_NAME);
    }
}

