/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt.settings;

import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.security.model.JwtSettings;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.service.security.auth.jwt.settings.DefaultJwtSettingsService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsValidator;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Component
public class DefaultJwtSettingsValidator
implements JwtSettingsValidator {
    public void validate(JwtSettings jwtSettings) {
        byte[] decodedKey;
        if (StringUtils.isEmpty((CharSequence)jwtSettings.getTokenIssuer())) {
            throw new DataValidationException("JWT token issuer should be specified!");
        }
        if ((long)Optional.ofNullable(jwtSettings.getRefreshTokenExpTime()).orElse(0).intValue() < TimeUnit.MINUTES.toSeconds(15L)) {
            throw new DataValidationException("JWT refresh token expiration time should be at least 15 minutes!");
        }
        if ((long)Optional.ofNullable(jwtSettings.getTokenExpirationTime()).orElse(0).intValue() < TimeUnit.MINUTES.toSeconds(1L)) {
            throw new DataValidationException("JWT token expiration time should be at least 1 minute!");
        }
        if (jwtSettings.getTokenExpirationTime() >= jwtSettings.getRefreshTokenExpTime()) {
            throw new DataValidationException("JWT token expiration time should greater than JWT refresh token expiration time!");
        }
        if (StringUtils.isEmpty((CharSequence)jwtSettings.getTokenSigningKey())) {
            throw new DataValidationException("JWT token signing key should be specified!");
        }
        try {
            decodedKey = Base64.getDecoder().decode(jwtSettings.getTokenSigningKey());
        }
        catch (Exception e) {
            throw new DataValidationException("JWT token signing key should be a valid Base64 encoded string! " + e.getMessage());
        }
        if (Arrays.isNullOrEmpty((byte[])decodedKey)) {
            throw new DataValidationException("JWT token signing key should be non-empty after Base64 decoding!");
        }
        if (decodedKey.length * 8 < JwtTokenFactory.KEY_LENGTH && !DefaultJwtSettingsService.isSigningKeyDefault((JwtSettings)jwtSettings)) {
            throw new DataValidationException("JWT token signing key should be a Base64 encoded string representing at least 512 bits of data!");
        }
        System.arraycopy(decodedKey, 0, RandomUtils.nextBytes((int)decodedKey.length), 0, decodedKey.length);
    }

    @Generated
    public DefaultJwtSettingsValidator() {
    }
}

