/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.service.security.ValidationResultCode;

public class ValidationResult<V> {
    private final ValidationResultCode resultCode;
    private final String message;
    private final V v;

    public static <V> ValidationResult<V> ok(V v) {
        return new ValidationResult(ValidationResultCode.OK, "Ok", v);
    }

    public static <V> ValidationResult<V> accessDenied(String message) {
        return new ValidationResult(ValidationResultCode.ACCESS_DENIED, message, null);
    }

    public static <V> ValidationResult<V> entityNotFound(String message) {
        return new ValidationResult(ValidationResultCode.ENTITY_NOT_FOUND, message, null);
    }

    public static <V> ValidationResult<V> unauthorized(String message) {
        return new ValidationResult(ValidationResultCode.UNAUTHORIZED, message, null);
    }

    public static <V> ValidationResult<V> internalError(String message) {
        return new ValidationResult(ValidationResultCode.INTERNAL_ERROR, message, null);
    }

    @Generated
    public ValidationResultCode getResultCode() {
        return this.resultCode;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public V getV() {
        return (V)this.v;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ValidationResultCode this$resultCode = this.getResultCode();
        ValidationResultCode other$resultCode = other.getResultCode();
        if (this$resultCode == null ? other$resultCode != null : !this$resultCode.equals(other$resultCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$v = this.getV();
        Object other$v = other.getV();
        return !(this$v == null ? other$v != null : !this$v.equals(other$v));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidationResultCode $resultCode = this.getResultCode();
        result = result * 59 + ($resultCode == null ? 43 : $resultCode.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationResult(resultCode=" + String.valueOf(this.getResultCode()) + ", message=" + this.getMessage() + ", v=" + String.valueOf(this.getV()) + ")";
    }

    @ConstructorProperties(value={"resultCode", "message", "v"})
    @Generated
    public ValidationResult(ValidationResultCode resultCode, String message, V v) {
        this.resultCode = resultCode;
        this.message = message;
        this.v = v;
    }
}

