/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.rpc;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.rpc.RpcService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class TbRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRpcService.class);
    private final RpcService rpcService;
    private final TbClusterService tbClusterService;

    public Rpc save(TenantId tenantId, Rpc rpc) {
        Rpc saved = this.rpcService.save(rpc);
        this.pushRpcMsgToRuleEngine(tenantId, saved);
        return saved;
    }

    public void save(TenantId tenantId, RpcId rpcId, RpcStatus newStatus, JsonNode response) {
        Rpc foundRpc = this.rpcService.findById(tenantId, rpcId);
        if (foundRpc != null) {
            foundRpc.setStatus(newStatus);
            if (response != null) {
                foundRpc.setResponse(response);
            }
            Rpc saved = this.rpcService.save(foundRpc);
            this.pushRpcMsgToRuleEngine(tenantId, saved);
        } else {
            log.warn("[{}] Failed to update RPC status because RPC was already deleted", (Object)rpcId);
        }
    }

    private void pushRpcMsgToRuleEngine(TenantId tenantId, Rpc rpc) {
        TbMsg msg = TbMsg.newMsg().type(TbMsgType.valueOf((String)("RPC_" + rpc.getStatus().name()))).originator((EntityId)rpc.getDeviceId()).copyMetaData(TbMsgMetaData.EMPTY).data(JacksonUtil.toString((Object)rpc)).build();
        this.tbClusterService.pushMsgToRuleEngine(tenantId, (EntityId)rpc.getDeviceId(), msg, null);
    }

    public Rpc findRpcById(TenantId tenantId, RpcId rpcId) {
        return this.rpcService.findById(tenantId, rpcId);
    }

    public PageData<Rpc> findAllByDeviceIdAndStatus(TenantId tenantId, DeviceId deviceId, RpcStatus rpcStatus, PageLink pageLink) {
        return this.rpcService.findAllByDeviceIdAndStatus(tenantId, deviceId, rpcStatus, pageLink);
    }

    @ConstructorProperties(value={"rpcService", "tbClusterService"})
    @Generated
    public TbRpcService(RpcService rpcService, TbClusterService tbClusterService) {
        this.rpcService = rpcService;
        this.tbClusterService = tbClusterService;
    }
}

