/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.resource;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceDeleteResult;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.lwm2m.LwM2mObject;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.resource.ResourceService;
import org.thingsboard.server.dao.service.Validator;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.resource.TbImageService;
import org.thingsboard.server.service.resource.TbResourceService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.utils.LwM2mObjectModelUtils;

@Service
@TbCoreComponent
public class DefaultTbResourceService
extends AbstractTbEntityService
implements TbResourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbResourceService.class);
    private final ResourceService resourceService;
    private final ImageService imageService;
    private final TbImageService tbImageService;
    private final AccessControlService accessControlService;

    public TbResourceInfo save(TbResource resource, SecurityUser user) throws ThingsboardException {
        if (resource.getResourceType() == ResourceType.IMAGE) {
            throw new IllegalArgumentException("Image resource type is not supported");
        }
        ActionType actionType = resource.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = resource.getTenantId();
        try {
            if (ResourceType.LWM2M_MODEL.equals((Object)resource.getResourceType())) {
                LwM2mObjectModelUtils.toLwm2mResource((TbResource)resource);
            } else if (resource.getResourceKey() == null) {
                resource.setResourceKey(resource.getFileName());
            }
            TbResourceInfo savedResource = new TbResourceInfo((TbResourceInfo)this.resourceService.saveResource(resource));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedResource.getId(), (HasName)savedResource, actionType, (User)user, new Object[0]);
            return savedResource;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.TB_RESOURCE), (HasName)new TbResourceInfo((TbResourceInfo)resource), actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    public TbResourceDeleteResult delete(TbResourceInfo tbResource, boolean force, User user) {
        if (tbResource.getResourceType() == ResourceType.IMAGE) {
            throw new IllegalArgumentException("Image resource type is not supported");
        }
        ActionType actionType = ActionType.DELETED;
        TbResourceId resourceId = tbResource.getId();
        TenantId tenantId = tbResource.getTenantId();
        try {
            TbResourceDeleteResult result = this.resourceService.deleteResource(tenantId, resourceId, force);
            if (result.isSuccess()) {
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)resourceId, (HasName)tbResource, actionType, user, new Object[]{resourceId.toString()});
            }
            return result;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.TB_RESOURCE), actionType, user, e, new Object[]{resourceId.toString()});
            throw e;
        }
    }

    public List<LwM2mObject> findLwM2mObject(TenantId tenantId, String sortOrder, String sortProperty, String[] objectIds) {
        log.trace("Executing findByTenantId [{}]", (Object)tenantId);
        Validator.validateId((UUIDBased)tenantId, id -> "Incorrect tenantId " + String.valueOf(id));
        List resources = this.resourceService.findTenantResourcesByResourceTypeAndObjectIds(tenantId, ResourceType.LWM2M_MODEL, objectIds);
        return resources.stream().flatMap(s -> Stream.ofNullable(LwM2mObjectModelUtils.toLwM2mObject((TbResource)s, (boolean)false))).sorted(this.getComparator(sortProperty, sortOrder)).collect(Collectors.toList());
    }

    public List<LwM2mObject> findLwM2mObjectPage(TenantId tenantId, String sortProperty, String sortOrder, PageLink pageLink) {
        log.trace("Executing findByTenantId [{}]", (Object)tenantId);
        Validator.validateId((UUIDBased)tenantId, id -> "Incorrect tenantId " + String.valueOf(id));
        PageData resourcePageData = this.resourceService.findTenantResourcesByResourceTypeAndPageLink(tenantId, ResourceType.LWM2M_MODEL, pageLink);
        return resourcePageData.getData().stream().flatMap(s -> Stream.ofNullable(LwM2mObjectModelUtils.toLwM2mObject((TbResource)s, (boolean)false))).sorted(this.getComparator(sortProperty, sortOrder)).collect(Collectors.toList());
    }

    public List<ResourceExportData> exportResources(Dashboard dashboard, SecurityUser user) throws ThingsboardException {
        return this.exportResources(() -> this.imageService.getUsedImages(dashboard), () -> this.resourceService.getUsedResources(user.getTenantId(), dashboard), user);
    }

    public List<ResourceExportData> exportResources(WidgetTypeDetails widgetTypeDetails, SecurityUser user) throws ThingsboardException {
        return this.exportResources(() -> this.imageService.getUsedImages(widgetTypeDetails), () -> this.resourceService.getUsedResources(user.getTenantId(), widgetTypeDetails), user);
    }

    public void importResources(List<ResourceExportData> resources, SecurityUser user) throws Exception {
        for (ResourceExportData resourceData : resources) {
            TbResourceInfo resourceInfo = resourceData.getType() == ResourceType.IMAGE ? this.tbImageService.importImage(resourceData, true, user) : this.importResource(resourceData, user);
            resourceData.setNewLink(resourceInfo.getLink());
        }
    }

    private <T> List<ResourceExportData> exportResources(Supplier<Collection<TbResourceInfo>> imagesProcessor, Supplier<Collection<TbResourceInfo>> resourcesProcessor, SecurityUser user) throws ThingsboardException {
        ArrayList<TbResourceInfo> resources = new ArrayList<TbResourceInfo>();
        resources.addAll(imagesProcessor.get());
        resources.addAll(resourcesProcessor.get());
        for (TbResourceInfo resourceInfo : resources) {
            this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.READ, (EntityId)resourceInfo.getId(), (TenantEntity)resourceInfo);
        }
        return this.resourceService.exportResources(user.getTenantId(), resources);
    }

    private TbResourceInfo importResource(ResourceExportData resourceData, SecurityUser user) throws ThingsboardException {
        TbResource resource = this.resourceService.toResource(user.getTenantId(), resourceData);
        if (resource.getData() != null) {
            this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.CREATE, null, (TenantEntity)resource);
            return this.save(resource, user);
        }
        this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.READ, (EntityId)resource.getId(), (TenantEntity)resource);
        return resource;
    }

    private Comparator<? super LwM2mObject> getComparator(String sortProperty, String sortOrder) {
        Comparator<LwM2mObject> comparator = "name".equals(sortProperty) ? Comparator.comparing(LwM2mObject::getName) : Comparator.comparingLong(LwM2mObject::getId);
        return "DESC".equals(sortOrder) ? comparator.reversed() : comparator;
    }

    @ConstructorProperties(value={"resourceService", "imageService", "tbImageService", "accessControlService"})
    @Generated
    public DefaultTbResourceService(ResourceService resourceService, ImageService imageService, TbImageService tbImageService, AccessControlService accessControlService) {
        this.resourceService = resourceService;
        this.imageService = imageService;
        this.tbImageService = tbImageService;
        this.accessControlService = accessControlService;
    }
}

