/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.report.dashboard;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.DashboardReportService;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.dashboardreport.DashboardReportConfig;
import org.thingsboard.server.common.data.dashboardreport.DashboardReportData;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.report.util.WebReportClient;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@Service
public class DefaultDashboardReportService
implements DashboardReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDashboardReportService.class);
    @Value(value="${reports.rate_limits.enabled:false}")
    private boolean rateLimitsEnabled;
    @Value(value="${reports.rate_limits.configuration:5:300}")
    private String rateLimitsConfiguration;
    private final WebReportClient webReportClient;
    private final SystemSecurityService systemSecurityService;
    private final RateLimitService rateLimitService;

    private void checkLimits(TenantId tenantId) {
        if (this.rateLimitsEnabled && !this.rateLimitService.checkRateLimit(LimitedApi.REPORTS, (Object)tenantId, this.rateLimitsConfiguration)) {
            log.trace("[{}] Report generation limits exceeded!", (Object)tenantId);
            throw new RuntimeException("Failed to generate report due to rate limits!");
        }
    }

    public void generateDashboardReport(String baseUrl, DashboardId dashboardId, TenantId tenantId, UserId userId, String reportName, JsonNode reportParams, String accessToken, long accessTokenExpiration, Consumer<DashboardReportData> onSuccess, Consumer<Throwable> onFailure) {
        this.checkLimits(tenantId);
        log.trace("Executing generateDashboardReport, baseUrl [{}], dashboardId [{}], userId [{}]", new Object[]{baseUrl, dashboardId, userId});
        ObjectNode dashboardReportRequest = JacksonUtil.newObjectNode();
        dashboardReportRequest.put("baseUrl", baseUrl);
        dashboardReportRequest.put("dashboardId", dashboardId.toString());
        dashboardReportRequest.set("reportParams", reportParams);
        dashboardReportRequest.put("name", reportName);
        dashboardReportRequest.put("token", accessToken);
        dashboardReportRequest.put("expiration", accessTokenExpiration);
        this.webReportClient.requestDashboardReport((JsonNode)dashboardReportRequest, null, onSuccess, onFailure);
    }

    public void generateReport(TenantId tenantId, DashboardReportConfig reportConfig, String reportsServerEndpointUrl, Consumer<DashboardReportData> onSuccess, Consumer<Throwable> onFailure) throws ThingsboardException {
        this.checkLimits(tenantId);
        log.trace("Executing generateReport, reportConfig [{}]", (Object)reportConfig);
        AccessJwtToken accessToken = this.systemSecurityService.createUserAccessToken(tenantId, new UserId(UUID.fromString(reportConfig.getUserId())));
        this.webReportClient.requestDashboardReport(reportConfig, reportsServerEndpointUrl, accessToken.getToken(), accessToken.getClaims().getExpiration().getTime(), onSuccess, onFailure);
    }

    @ConstructorProperties(value={"webReportClient", "systemSecurityService", "rateLimitService"})
    @Generated
    public DefaultDashboardReportService(WebReportClient webReportClient, SystemSecurityService systemSecurityService, RateLimitService rateLimitService) {
        this.webReportClient = webReportClient;
        this.systemSecurityService = systemSecurityService;
        this.rateLimitService = rateLimitService;
    }
}

