/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.report;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.common.data.query.AlarmDataQuery;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.report.configuration.timewindow.Interval;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.report.ReportService;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.report.context.TbReportCtx;
import org.thingsboard.server.report.datasource.ReportDataService;
import org.thingsboard.server.service.query.EntityQueryService;
import org.thingsboard.server.service.report.LocalTbReportCtxProvider;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.telemetry.TbTelemetryService;

@TbCoreComponent
@Service
public class LocalReportDataService
implements ReportDataService {
    private final EntityQueryService entityQueryService;
    private final AlarmService alarmService;
    private final TbTelemetryService tbTelemetryService;
    private final AccessControlService accessControlService;
    private final ReportTemplateService reportTemplateService;
    private final ImageService imageService;
    private final ReportService reportService;

    public ReportTemplate findReportTemplate(ReportTemplateId templateId, TbReportCtx ctx) throws ThingsboardException {
        SecurityUser securityUser = this.getSecurityUser(ctx);
        ReportTemplate reportTemplate = (ReportTemplate)this.checkNotNull((Object)this.reportTemplateService.findReportTemplateById(securityUser.getTenantId(), templateId));
        this.accessControlService.checkPermission(securityUser, Resource.REPORT_TEMPLATE, Operation.READ, (EntityId)templateId, (TenantEntity)reportTemplate);
        return reportTemplate;
    }

    public byte[] downloadImage(String type, String key, TbReportCtx ctx) throws ThingsboardException {
        SecurityUser securityUser = this.getSecurityUser(ctx);
        TenantId tenantId = "system".equals(type) ? TenantId.SYS_TENANT_ID : securityUser.getTenantId();
        TbResourceInfo imageInfo = (TbResourceInfo)this.checkNotNull((Object)this.imageService.getImageInfoByTenantIdAndKey(tenantId, key));
        return (byte[])this.checkNotNull((Object)this.imageService.getImageData(tenantId, imageInfo.getId()));
    }

    public byte[] downloadPublicImage(String publicKey, TbReportCtx ctx) throws ThingsboardException {
        SecurityUser securityUser = this.getSecurityUser(ctx);
        TbResourceInfo imageInfo = (TbResourceInfo)this.checkNotNull((Object)this.imageService.getPublicImageInfoByKey(publicKey));
        return (byte[])this.checkNotNull((Object)this.imageService.getImageData(securityUser.getTenantId(), imageInfo.getId()));
    }

    public PageData<EntityData> findEntityDataByQuery(EntityDataQuery query, TbReportCtx ctx) {
        return this.entityQueryService.findEntityDataByQuery(this.getSecurityUser(ctx), query);
    }

    public Long countEntitiesByQuery(EntityCountQuery query, TbReportCtx ctx) {
        return this.entityQueryService.countEntitiesByQuery(this.getSecurityUser(ctx), query);
    }

    public PageData<AlarmData> findAlarmDataByQuery(AlarmDataQuery query, TbReportCtx ctx) {
        return this.entityQueryService.findAlarmDataByQuery(this.getSecurityUser(ctx), query);
    }

    public PageData<AlarmData> findAlarmDataByQueryForEntities(AlarmDataQuery query, Collection<EntityId> entityIds, TbReportCtx ctx) {
        SecurityUser securityUser = this.getSecurityUser(ctx);
        return this.alarmService.findAlarmDataByQueryForEntities(securityUser.getTenantId(), securityUser.getUserPermissions(), query, entityIds);
    }

    public Long countAlarmsByQuery(AlarmCountQuery query, TbReportCtx ctx) {
        return this.entityQueryService.countAlarmsByQuery(this.getSecurityUser(ctx), query);
    }

    public List<TsKvEntry> getTimeseries(EntityId entityId, List<String> keys, Long startTs, Long endTs, Interval interval, String timeZone, Aggregation agg, SortOrder.Direction sortOrder, Integer limit, boolean useStrictDataTypes, TbReportCtx ctx) {
        return (List)this.tbTelemetryService.getTimeseries(entityId, keys, startTs, endTs, interval.getIntervalType(), Long.valueOf(interval.getInterval()), timeZone, limit, agg, sortOrder.name(), Boolean.valueOf(useStrictDataTypes), this.getSecurityUser(ctx)).get();
    }

    public List<ReadTsKvQueryResult> findTimeseriesByQueries(EntityId entityId, List<BaseReadTsKvQuery> queries, TbReportCtx ctx) {
        return (List)this.tbTelemetryService.getTimeseriesByReadQueries(entityId, queries, this.getSecurityUser(ctx)).get();
    }

    public Report createReport(Report report, byte[] data, TbReportCtx ctx) throws ThingsboardException {
        this.accessControlService.checkPermission(this.getSecurityUser(ctx), Resource.REPORT, Operation.CREATE);
        return this.reportService.createReport(report, data);
    }

    private SecurityUser getSecurityUser(TbReportCtx ctx) {
        return ((LocalTbReportCtxProvider.LocalTbReportCtx)ctx).getSecurityUser();
    }

    private <T> T checkNotNull(T reference) throws ThingsboardException {
        if (reference == null) {
            throw new ThingsboardException("Requested item wasn't found!", ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        return reference;
    }

    @ConstructorProperties(value={"entityQueryService", "alarmService", "tbTelemetryService", "accessControlService", "reportTemplateService", "imageService", "reportService"})
    @Generated
    public LocalReportDataService(EntityQueryService entityQueryService, AlarmService alarmService, TbTelemetryService tbTelemetryService, AccessControlService accessControlService, ReportTemplateService reportTemplateService, ImageService imageService, ReportService reportService) {
        this.entityQueryService = entityQueryService;
        this.alarmService = alarmService;
        this.tbTelemetryService = tbTelemetryService;
        this.accessControlService = accessControlService;
        this.reportTemplateService = reportTemplateService;
        this.imageService = imageService;
        this.reportService = reportService;
    }
}

