/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.service.queue.TbTenantRuleEngineStats;
import org.thingsboard.server.service.queue.processing.TbRuleEngineProcessingResult;

public class TbRuleEngineConsumerStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineConsumerStats.class);
    public static final String TOTAL_MSGS = "totalMsgs";
    public static final String SUCCESSFUL_MSGS = "successfulMsgs";
    public static final String TMP_TIMEOUT = "tmpTimeout";
    public static final String TMP_FAILED = "tmpFailed";
    public static final String TIMEOUT_MSGS = "timeoutMsgs";
    public static final String FAILED_MSGS = "failedMsgs";
    public static final String SUCCESSFUL_ITERATIONS = "successfulIterations";
    public static final String FAILED_ITERATIONS = "failedIterations";
    public static final String TENANT_ID_TAG = "tenantId";
    private final StatsFactory statsFactory;
    private final StatsCounter totalMsgCounter;
    private final StatsCounter successMsgCounter;
    private final StatsCounter tmpTimeoutMsgCounter;
    private final StatsCounter tmpFailedMsgCounter;
    private final StatsCounter timeoutMsgCounter;
    private final StatsCounter failedMsgCounter;
    private final StatsCounter successIterationsCounter;
    private final StatsCounter failedIterationsCounter;
    private final List<StatsCounter> counters = new ArrayList();
    private final ConcurrentMap<UUID, TbTenantRuleEngineStats> tenantStats = new ConcurrentHashMap();
    private final ConcurrentMap<TenantId, Timer> tenantMsgProcessTimers = new ConcurrentHashMap();
    private final ConcurrentMap<TenantId, RuleEngineException> tenantExceptions = new ConcurrentHashMap();
    private final String queueName;
    private final TenantId tenantId;

    public TbRuleEngineConsumerStats(QueueKey queueKey, StatsFactory statsFactory) {
        this.queueName = queueKey.getQueueName();
        this.tenantId = queueKey.getTenantId();
        this.statsFactory = statsFactory;
        String statsKey = StatsType.RULE_ENGINE.getName() + "." + this.queueName;
        String tenant = this.tenantId == null || this.tenantId.isSysTenantId() ? "system" : this.tenantId.toString();
        this.totalMsgCounter = statsFactory.createStatsCounter(statsKey, TOTAL_MSGS, new String[]{TENANT_ID_TAG, tenant});
        this.successMsgCounter = statsFactory.createStatsCounter(statsKey, SUCCESSFUL_MSGS, new String[]{TENANT_ID_TAG, tenant});
        this.timeoutMsgCounter = statsFactory.createStatsCounter(statsKey, TIMEOUT_MSGS, new String[]{TENANT_ID_TAG, tenant});
        this.failedMsgCounter = statsFactory.createStatsCounter(statsKey, FAILED_MSGS, new String[]{TENANT_ID_TAG, tenant});
        this.tmpTimeoutMsgCounter = statsFactory.createStatsCounter(statsKey, TMP_TIMEOUT, new String[]{TENANT_ID_TAG, tenant});
        this.tmpFailedMsgCounter = statsFactory.createStatsCounter(statsKey, TMP_FAILED, new String[]{TENANT_ID_TAG, tenant});
        this.successIterationsCounter = statsFactory.createStatsCounter(statsKey, SUCCESSFUL_ITERATIONS, new String[]{TENANT_ID_TAG, tenant});
        this.failedIterationsCounter = statsFactory.createStatsCounter(statsKey, FAILED_ITERATIONS, new String[]{TENANT_ID_TAG, tenant});
        this.counters.add(this.totalMsgCounter);
        this.counters.add(this.successMsgCounter);
        this.counters.add(this.timeoutMsgCounter);
        this.counters.add(this.failedMsgCounter);
        this.counters.add(this.tmpTimeoutMsgCounter);
        this.counters.add(this.tmpFailedMsgCounter);
        this.counters.add(this.successIterationsCounter);
        this.counters.add(this.failedIterationsCounter);
    }

    public Timer getTimer(TenantId tenantId, String status) {
        return this.tenantMsgProcessTimers.computeIfAbsent(tenantId, id -> this.statsFactory.createTimer(StatsType.RULE_ENGINE.getName() + "." + this.queueName, new String[]{TENANT_ID_TAG, tenantId.getId().toString(), "status", status}));
    }

    public void log(TbRuleEngineProcessingResult msg, boolean finalIterationForPack) {
        int success = msg.getSuccessMap().size();
        int pending = msg.getPendingMap().size();
        int failed = msg.getFailedMap().size();
        this.totalMsgCounter.add(success + pending + failed);
        this.successMsgCounter.add(success);
        msg.getSuccessMap().values().forEach(m -> this.getTenantStats(m).logSuccess());
        if (finalIterationForPack) {
            if (pending > 0 || failed > 0) {
                this.timeoutMsgCounter.add(pending);
                this.failedMsgCounter.add(failed);
                if (pending > 0) {
                    msg.getPendingMap().values().forEach(m -> this.getTenantStats(m).logTimeout());
                }
                if (failed > 0) {
                    msg.getFailedMap().values().forEach(m -> this.getTenantStats(m).logFailed());
                }
                this.failedIterationsCounter.increment();
            } else {
                this.successIterationsCounter.increment();
            }
        } else {
            this.failedIterationsCounter.increment();
            this.tmpTimeoutMsgCounter.add(pending);
            this.tmpFailedMsgCounter.add(failed);
            if (pending > 0) {
                msg.getPendingMap().values().forEach(m -> this.getTenantStats(m).logTmpTimeout());
            }
            if (failed > 0) {
                msg.getFailedMap().values().forEach(m -> this.getTenantStats(m).logTmpFailed());
            }
        }
        msg.getExceptionsMap().forEach(this.tenantExceptions::putIfAbsent);
    }

    private TbTenantRuleEngineStats getTenantStats(TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg> m) {
        TransportProtos.ToRuleEngineMsg reMsg = (TransportProtos.ToRuleEngineMsg)m.getValue();
        return this.tenantStats.computeIfAbsent(new UUID(reMsg.getTenantIdMSB(), reMsg.getTenantIdLSB()), TbTenantRuleEngineStats::new);
    }

    public ConcurrentMap<UUID, TbTenantRuleEngineStats> getTenantStats() {
        return this.tenantStats;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ConcurrentMap<TenantId, RuleEngineException> getTenantExceptions() {
        return this.tenantExceptions;
    }

    public void printStats() {
        int total = this.totalMsgCounter.get();
        if (total > 0) {
            StringBuilder stats = new StringBuilder();
            this.counters.forEach(counter -> stats.append(counter.getName()).append(" = [").append(counter.get()).append("] "));
            if (this.tenantId.isSysTenantId()) {
                log.info("[{}] Stats: {}", (Object)this.queueName, (Object)stats);
            } else {
                log.info("[{}][{}] Stats: {}", new Object[]{this.queueName, this.tenantId, stats});
            }
        }
    }

    public void reset() {
        this.counters.forEach(DefaultCounter::clear);
        this.tenantStats.clear();
        this.tenantExceptions.clear();
    }
}

