/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;

public class TbCoreConsumerStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCoreConsumerStats.class);
    public static final String TOTAL_MSGS = "totalMsgs";
    public static final String SESSION_EVENTS = "sessionEvents";
    public static final String GET_ATTRIBUTE = "getAttr";
    public static final String ATTRIBUTE_SUBSCRIBES = "subToAttr";
    public static final String RPC_SUBSCRIBES = "subToRpc";
    public static final String TO_DEVICE_RPC_CALL_RESPONSES = "toDevRpc";
    public static final String SUBSCRIPTION_INFO = "subInfo";
    public static final String DEVICE_CLAIMS = "claimDevice";
    public static final String DEVICE_STATES = "deviceState";
    public static final String SUBSCRIPTION_MSGS = "subMsgs";
    public static final String SCHEDULER = "scheduler";
    public static final String CLOUD_NOTIFICATIONS = "cloudNfs";
    public static final String DEVICE_CONNECTS = "deviceConnect";
    public static final String DEVICE_ACTIVITIES = "deviceActivity";
    public static final String DEVICE_DISCONNECTS = "deviceDisconnect";
    public static final String DEVICE_INACTIVITIES = "deviceInactivity";
    public static final String DEVICE_INACTIVITY_TIMEOUT_UPDATES = "deviceInactivityTimeoutUpdate";
    public static final String TO_CORE_NF_INTEGRATION_DOWNLINK = "coreNfIntDlnk";
    public static final String TO_CORE_NF_INTEGRATION_VALIDATION_RESPONSE = "coreNfIntValRsp";
    public static final String TO_CORE_NF_REST_API_CALL_RESPONSE = "coreNfRestRsp";
    public static final String TO_CORE_NF_OTHER = "coreNfOther";
    public static final String TO_CORE_NF_COMPONENT_LIFECYCLE = "coreNfCompLfcl";
    public static final String TO_CORE_NF_DEVICE_RPC_RESPONSE = "coreNfDevRpcRsp";
    public static final String TO_CORE_NF_NOTIFICATION_RULE_PROCESSOR = "coreNfNfRlProc";
    public static final String TO_CORE_NF_QUEUE_UPDATE = "coreNfQueueUpd";
    public static final String TO_CORE_NF_QUEUE_DELETE = "coreNfQueueDel";
    public static final String TO_CORE_NF_SUBSCRIPTION_SERVICE = "coreNfSubSvc";
    public static final String TO_CORE_NF_SUBSCRIPTION_MANAGER = "coreNfSubMgr";
    public static final String TO_CORE_NF_VC_RESPONSE = "coreNfVCRsp";
    private final StatsCounter totalCounter;
    private final StatsCounter sessionEventCounter;
    private final StatsCounter getAttributesCounter;
    private final StatsCounter subscribeToAttributesCounter;
    private final StatsCounter subscribeToRPCCounter;
    private final StatsCounter toDeviceRPCCallResponseCounter;
    private final StatsCounter subscriptionInfoCounter;
    private final StatsCounter claimDeviceCounter;
    private final StatsCounter deviceStateCounter;
    private final StatsCounter subscriptionMsgCounter;
    private final StatsCounter cloudNotificationMsgCounter;
    private final StatsCounter deviceConnectsCounter;
    private final StatsCounter deviceActivitiesCounter;
    private final StatsCounter deviceDisconnectsCounter;
    private final StatsCounter deviceInactivitiesCounter;
    private final StatsCounter deviceInactivityTimeoutUpdatesCounter;
    private final StatsCounter schedulerMsgCounter;
    private final StatsCounter integrationDownlinkCounter;
    private final StatsCounter IntegartionValidationCounter;
    private final StatsCounter RestApiCallResponseCounter;
    private final StatsCounter toCoreNfOtherCounter;
    private final StatsCounter toCoreNfComponentLifecycleCounter;
    private final StatsCounter toCoreNfDeviceRpcResponseCounter;
    private final StatsCounter toCoreNfNotificationRuleProcessorCounter;
    private final StatsCounter toCoreNfQueueUpdateCounter;
    private final StatsCounter toCoreNfQueueDeleteCounter;
    private final StatsCounter toCoreNfSubscriptionServiceCounter;
    private final StatsCounter toCoreNfSubscriptionManagerCounter;
    private final StatsCounter toCoreNfVersionControlResponseCounter;
    private final List<StatsCounter> counters = new ArrayList(27);

    public TbCoreConsumerStats(StatsFactory statsFactory) {
        String statsKey = StatsType.CORE.getName();
        this.totalCounter = this.register(statsFactory.createStatsCounter(statsKey, TOTAL_MSGS, new String[0]));
        this.sessionEventCounter = this.register(statsFactory.createStatsCounter(statsKey, SESSION_EVENTS, new String[0]));
        this.getAttributesCounter = this.register(statsFactory.createStatsCounter(statsKey, GET_ATTRIBUTE, new String[0]));
        this.subscribeToAttributesCounter = this.register(statsFactory.createStatsCounter(statsKey, ATTRIBUTE_SUBSCRIBES, new String[0]));
        this.subscribeToRPCCounter = this.register(statsFactory.createStatsCounter(statsKey, RPC_SUBSCRIBES, new String[0]));
        this.toDeviceRPCCallResponseCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_DEVICE_RPC_CALL_RESPONSES, new String[0]));
        this.subscriptionInfoCounter = this.register(statsFactory.createStatsCounter(statsKey, SUBSCRIPTION_INFO, new String[0]));
        this.claimDeviceCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_CLAIMS, new String[0]));
        this.deviceStateCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_STATES, new String[0]));
        this.subscriptionMsgCounter = this.register(statsFactory.createStatsCounter(statsKey, SUBSCRIPTION_MSGS, new String[0]));
        this.cloudNotificationMsgCounter = this.register(statsFactory.createStatsCounter(statsKey, CLOUD_NOTIFICATIONS, new String[0]));
        this.deviceConnectsCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_CONNECTS, new String[0]));
        this.deviceActivitiesCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_ACTIVITIES, new String[0]));
        this.deviceDisconnectsCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_DISCONNECTS, new String[0]));
        this.deviceInactivitiesCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_INACTIVITIES, new String[0]));
        this.deviceInactivityTimeoutUpdatesCounter = this.register(statsFactory.createStatsCounter(statsKey, DEVICE_INACTIVITY_TIMEOUT_UPDATES, new String[0]));
        this.schedulerMsgCounter = this.register(statsFactory.createStatsCounter(statsKey, SCHEDULER, new String[0]));
        this.integrationDownlinkCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_INTEGRATION_DOWNLINK, new String[0]));
        this.IntegartionValidationCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_INTEGRATION_VALIDATION_RESPONSE, new String[0]));
        this.RestApiCallResponseCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_REST_API_CALL_RESPONSE, new String[0]));
        this.toCoreNfOtherCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_OTHER, new String[0]));
        this.toCoreNfComponentLifecycleCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_COMPONENT_LIFECYCLE, new String[0]));
        this.toCoreNfDeviceRpcResponseCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_DEVICE_RPC_RESPONSE, new String[0]));
        this.toCoreNfNotificationRuleProcessorCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_NOTIFICATION_RULE_PROCESSOR, new String[0]));
        this.toCoreNfQueueUpdateCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_QUEUE_UPDATE, new String[0]));
        this.toCoreNfQueueDeleteCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_QUEUE_DELETE, new String[0]));
        this.toCoreNfSubscriptionServiceCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_SUBSCRIPTION_SERVICE, new String[0]));
        this.toCoreNfSubscriptionManagerCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_SUBSCRIPTION_MANAGER, new String[0]));
        this.toCoreNfVersionControlResponseCounter = this.register(statsFactory.createStatsCounter(statsKey, TO_CORE_NF_VC_RESPONSE, new String[0]));
    }

    private StatsCounter register(StatsCounter counter) {
        this.counters.add(counter);
        return counter;
    }

    public void log(TransportProtos.TransportToDeviceActorMsg msg) {
        this.totalCounter.increment();
        if (msg.hasSessionEvent()) {
            this.sessionEventCounter.increment();
        }
        if (msg.hasGetAttributes()) {
            this.getAttributesCounter.increment();
        }
        if (msg.hasSubscribeToAttributes()) {
            this.subscribeToAttributesCounter.increment();
        }
        if (msg.hasSubscribeToRPC()) {
            this.subscribeToRPCCounter.increment();
        }
        if (msg.hasToDeviceRPCCallResponse()) {
            this.toDeviceRPCCallResponseCounter.increment();
        }
        if (msg.hasSubscriptionInfo()) {
            this.subscriptionInfoCounter.increment();
        }
        if (msg.hasClaimDevice()) {
            this.claimDeviceCounter.increment();
        }
    }

    public void log(TransportProtos.DeviceStateServiceMsgProto msg) {
        this.totalCounter.increment();
        this.deviceStateCounter.increment();
    }

    public void log(TransportProtos.SchedulerServiceMsgProto schedulerServiceMsg) {
        this.totalCounter.increment();
        this.schedulerMsgCounter.increment();
    }

    public void log(TransportProtos.CloudNotificationMsgProto msg) {
        this.totalCounter.increment();
        this.cloudNotificationMsgCounter.increment();
    }

    public void log(TransportProtos.DeviceConnectProto msg) {
        this.totalCounter.increment();
        this.deviceConnectsCounter.increment();
    }

    public void log(TransportProtos.DeviceActivityProto msg) {
        this.totalCounter.increment();
        this.deviceActivitiesCounter.increment();
    }

    public void log(TransportProtos.DeviceDisconnectProto msg) {
        this.totalCounter.increment();
        this.deviceDisconnectsCounter.increment();
    }

    public void log(TransportProtos.DeviceInactivityProto msg) {
        this.totalCounter.increment();
        this.deviceInactivitiesCounter.increment();
    }

    public void log(TransportProtos.DeviceInactivityTimeoutUpdateProto msg) {
        this.totalCounter.increment();
        this.deviceInactivityTimeoutUpdatesCounter.increment();
    }

    public void log(TransportProtos.SubscriptionMgrMsgProto msg) {
        this.totalCounter.increment();
        this.subscriptionMsgCounter.increment();
    }

    public void log(TransportProtos.ToCoreNotificationMsg msg) {
        this.totalCounter.increment();
        if (msg.hasToLocalSubscriptionServiceMsg()) {
            this.toCoreNfSubscriptionServiceCounter.increment();
        } else if (msg.hasFromDeviceRpcResponse()) {
            this.toCoreNfDeviceRpcResponseCounter.increment();
        } else if (msg.hasIntegrationDownlinkMsg()) {
            this.integrationDownlinkCounter.increment();
        } else if (msg.hasIntegrationValidationResponseMsg()) {
            this.IntegartionValidationCounter.increment();
        } else if (msg.hasRestApiCallResponseMsg()) {
            this.RestApiCallResponseCounter.increment();
        } else if (msg.hasComponentLifecycle()) {
            this.toCoreNfComponentLifecycleCounter.increment();
        } else if (msg.getQueueUpdateMsgsCount() > 0) {
            this.toCoreNfQueueUpdateCounter.increment();
        } else if (msg.getQueueDeleteMsgsCount() > 0) {
            this.toCoreNfQueueDeleteCounter.increment();
        } else if (msg.hasVcResponseMsg()) {
            this.toCoreNfVersionControlResponseCounter.increment();
        } else if (msg.hasToSubscriptionMgrMsg()) {
            this.toCoreNfSubscriptionManagerCounter.increment();
        } else if (msg.hasNotificationRuleProcessorMsg()) {
            this.toCoreNfNotificationRuleProcessorCounter.increment();
        } else {
            this.toCoreNfOtherCounter.increment();
        }
    }

    public void printStats() {
        int total = this.totalCounter.get();
        if (total > 0) {
            StringBuilder stats = new StringBuilder();
            this.counters.forEach(counter -> stats.append(counter.getName()).append(" = [").append(counter.get()).append("] "));
            log.info("Core Stats: {}", (Object)stats);
        }
    }

    public void reset() {
        this.counters.forEach(DefaultCounter::clear);
    }
}

