/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ota;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.OtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.ota.DeviceGroupOtaPackage;
import org.thingsboard.server.common.data.ota.OtaPackageKey;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.ota.OtaPackageUpdateStatus;
import org.thingsboard.server.common.data.ota.OtaPackageUtil;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.ota.OtaPackageStateService;

@Service
public class DefaultOtaPackageStateService
implements OtaPackageStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOtaPackageStateService.class);
    private final TbClusterService tbClusterService;
    private final OtaPackageService otaPackageService;
    private final DeviceService deviceService;
    private final RuleEngineTelemetryService telemetryService;
    private final AttributesService attributesService;
    private final DbCallbackExecutorService dbExecutor;
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> otaPackageStateMsgProducer;

    public DefaultOtaPackageStateService(@Lazy TbClusterService tbClusterService, OtaPackageService otaPackageService, DeviceService deviceService, @Lazy RuleEngineTelemetryService telemetryService, AttributesService attributesService, DbCallbackExecutorService dbExecutor, Optional<TbCoreQueueFactory> coreQueueFactory, Optional<TbRuleEngineQueueFactory> reQueueFactory) {
        this.tbClusterService = tbClusterService;
        this.otaPackageService = otaPackageService;
        this.deviceService = deviceService;
        this.telemetryService = telemetryService;
        this.attributesService = attributesService;
        this.dbExecutor = dbExecutor;
        this.otaPackageStateMsgProducer = coreQueueFactory.isPresent() ? coreQueueFactory.get().createToOtaPackageStateServiceMsgProducer() : reQueueFactory.get().createToOtaPackageStateServiceMsgProducer();
    }

    public void update(TenantId tenantId, DeviceGroupOtaPackage newDeviceGroupOtaPackage, DeviceGroupOtaPackage oldDeviceGroupOtaPackage) {
        long ts = System.currentTimeMillis();
        if (oldDeviceGroupOtaPackage == null) {
            OtaPackage newOtaPackage = this.otaPackageService.findOtaPackageById(tenantId, newDeviceGroupOtaPackage.getOtaPackageId());
            this.update(newDeviceGroupOtaPackage, (OtaPackageInfo)newOtaPackage, ts);
        } else if (newDeviceGroupOtaPackage == null) {
            OtaPackage oldOtaPackage = this.otaPackageService.findOtaPackageById(tenantId, oldDeviceGroupOtaPackage.getOtaPackageId());
            this.remove(oldDeviceGroupOtaPackage, (OtaPackageInfo)oldOtaPackage, ts);
        } else {
            OtaPackage newOtaPackage = this.otaPackageService.findOtaPackageById(tenantId, newDeviceGroupOtaPackage.getOtaPackageId());
            OtaPackage oldOtaPackage = this.otaPackageService.findOtaPackageById(tenantId, oldDeviceGroupOtaPackage.getOtaPackageId());
            this.update(newDeviceGroupOtaPackage, (OtaPackageInfo)newOtaPackage, ts);
            if (!newOtaPackage.getDeviceProfileId().equals((Object)oldOtaPackage.getDeviceProfileId())) {
                this.remove(oldDeviceGroupOtaPackage, (OtaPackageInfo)oldOtaPackage, ts);
            }
        }
    }

    private void update(DeviceGroupOtaPackage deviceGroupOtaPackage, OtaPackageInfo packageFromGroup, long ts) {
        PageData pageData;
        PageLink pageLink = this.createPageLink();
        do {
            pageData = this.deviceService.findByEntityGroupAndDeviceProfileAndEmptyOtaPackage(deviceGroupOtaPackage.getGroupId(), packageFromGroup.getDeviceProfileId(), deviceGroupOtaPackage.getOtaPackageType(), pageLink);
            pageData.getData().forEach(d -> this.send(d.getTenantId(), d.getId(), deviceGroupOtaPackage.getOtaPackageId(), ts, deviceGroupOtaPackage.getOtaPackageType()));
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
    }

    private void remove(DeviceGroupOtaPackage deviceGroupOtaPackage, OtaPackageInfo otaPackageFromGroup, long ts) {
        PageData pageData;
        OtaPackageType otaPackageType = deviceGroupOtaPackage.getOtaPackageType();
        PageLink pageLink = this.createPageLink();
        do {
            pageData = this.deviceService.findByEntityGroupAndDeviceProfileAndEmptyOtaPackage(deviceGroupOtaPackage.getGroupId(), otaPackageFromGroup.getDeviceProfileId(), otaPackageType, pageLink);
            pageData.getData().forEach(device -> {
                OtaPackageInfo otaPackageForDevice = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(device.getId(), deviceGroupOtaPackage.getOtaPackageType());
                if (otaPackageForDevice != null) {
                    ListenableFuture oldFirmwareIdFuture = this.attributesService.find(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.ID));
                    DonAsynchron.withCallback((ListenableFuture)oldFirmwareIdFuture, oldIdOpt -> {
                        if (oldIdOpt.isPresent()) {
                            OtaPackageId oldFirmwareId = new OtaPackageId(UUID.fromString(((AttributeKvEntry)oldIdOpt.get()).getValueAsString()));
                            if (!otaPackageForDevice.getId().equals((Object)oldFirmwareId)) {
                                this.send(device.getTenantId(), device.getId(), otaPackageForDevice.getId(), ts, otaPackageType);
                            }
                        } else {
                            log.trace("[{}] OtaPackage id attribute not found!", (Object)device.getId());
                        }
                    }, e -> log.error("Failed to get OtaPackage id attribute for device!", e), (Executor)this.dbExecutor);
                } else {
                    this.remove(device, otaPackageType);
                }
            });
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
    }

    public void update(TenantId tenantId, List<DeviceId> deviceIds, boolean isFirmware, boolean isSoftware) {
        deviceIds.forEach(id -> {
            if (isFirmware) {
                this.update(tenantId, id, OtaPackageType.FIRMWARE);
            }
            if (isSoftware) {
                this.update(tenantId, id, OtaPackageType.SOFTWARE);
            }
        });
    }

    private void update(TenantId tenantId, DeviceId deviceId, OtaPackageType otaPackageType) {
        OtaPackageInfo otaPackage = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(deviceId, otaPackageType);
        if (otaPackage != null) {
            ListenableFuture oldFirmwareIdFuture = this.attributesService.find(tenantId, (EntityId)deviceId, AttributeScope.SERVER_SCOPE, OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.ID));
            DonAsynchron.withCallback((ListenableFuture)oldFirmwareIdFuture, oldIdOpt -> {
                if (oldIdOpt.isPresent()) {
                    OtaPackageId otaPackageId = new OtaPackageId(UUID.fromString(((AttributeKvEntry)oldIdOpt.get()).getValueAsString()));
                    if (!otaPackage.getId().equals((Object)otaPackageId)) {
                        this.send(tenantId, deviceId, otaPackage.getId(), System.currentTimeMillis(), otaPackageType);
                    }
                } else {
                    this.send(tenantId, deviceId, otaPackage.getId(), System.currentTimeMillis(), otaPackageType);
                }
            }, e -> log.error("Failed to get OtaPackage id attribute for device!", e), (Executor)this.dbExecutor);
        } else {
            Device device = this.deviceService.findDeviceById(tenantId, deviceId);
            this.remove(device, otaPackageType);
        }
    }

    public void update(Device device) {
        this.updateFirmware(device);
        this.updateSoftware(device);
    }

    private void updateFirmware(Device device) {
        ListenableFuture oldFirmwareIdFuture = this.attributesService.find(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.FIRMWARE, (OtaPackageKey)OtaPackageKey.ID));
        DonAsynchron.withCallback((ListenableFuture)oldFirmwareIdFuture, oldIdOpt -> {
            OtaPackageInfo fw;
            OtaPackageId oldFirmwareId = null;
            if (oldIdOpt.isPresent()) {
                oldFirmwareId = new OtaPackageId(UUID.fromString(((AttributeKvEntry)oldIdOpt.get()).getValueAsString()));
            }
            if ((fw = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(device.getId(), OtaPackageType.FIRMWARE)) == null) {
                if (oldFirmwareId != null) {
                    this.remove(device, OtaPackageType.FIRMWARE);
                }
            } else if (!fw.getId().equals((Object)oldFirmwareId)) {
                this.send(device.getTenantId(), device.getId(), fw.getId(), System.currentTimeMillis(), OtaPackageType.FIRMWARE);
            }
        }, e -> log.error("Failed to get firmware id attribute!", e), (Executor)this.dbExecutor);
    }

    private void updateSoftware(Device device) {
        ListenableFuture oldSoftwareIdFuture = this.attributesService.find(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, OtaPackageUtil.getAttributeKey((OtaPackageType)OtaPackageType.SOFTWARE, (OtaPackageKey)OtaPackageKey.ID));
        DonAsynchron.withCallback((ListenableFuture)oldSoftwareIdFuture, oldIdOpt -> {
            OtaPackageInfo sw;
            OtaPackageId oldSoftwareId = null;
            if (oldIdOpt.isPresent()) {
                oldSoftwareId = new OtaPackageId(UUID.fromString(((AttributeKvEntry)oldIdOpt.get()).getValueAsString()));
            }
            if ((sw = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(device.getId(), OtaPackageType.SOFTWARE)) == null) {
                if (oldSoftwareId != null) {
                    this.remove(device, OtaPackageType.SOFTWARE);
                }
            } else if (!sw.getId().equals((Object)oldSoftwareId)) {
                this.send(device.getTenantId(), device.getId(), sw.getId(), System.currentTimeMillis(), OtaPackageType.SOFTWARE);
            }
        }, e -> log.error("Failed to get software id attribute!", e), (Executor)this.dbExecutor);
    }

    public void update(DeviceProfile deviceProfile, boolean isFirmwareChanged, boolean isSoftwareChanged) {
        TenantId tenantId = deviceProfile.getTenantId();
        if (isFirmwareChanged) {
            this.update(tenantId, deviceProfile, OtaPackageType.FIRMWARE);
        }
        if (isSoftwareChanged) {
            this.update(tenantId, deviceProfile, OtaPackageType.SOFTWARE);
        }
    }

    private void update(TenantId tenantId, DeviceProfile deviceProfile, OtaPackageType otaPackageType) {
        PageData pageData;
        Consumer<Device> updateConsumer;
        OtaPackageId packageId = OtaPackageUtil.getOtaPackageId((HasOtaPackage)deviceProfile, (OtaPackageType)otaPackageType);
        if (packageId != null) {
            long ts = System.currentTimeMillis();
            updateConsumer = d -> this.send(d.getTenantId(), d.getId(), packageId, ts, otaPackageType);
        } else {
            updateConsumer = d -> this.remove(d, otaPackageType);
        }
        PageLink pageLink = this.createPageLink();
        do {
            pageData = this.deviceService.findByDeviceProfileAndEmptyOtaPackage(tenantId, deviceProfile.getId(), otaPackageType, pageLink);
            pageData.getData().forEach(updateConsumer);
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
    }

    public boolean process(TransportProtos.ToOtaPackageStateServiceMsg msg) {
        boolean isSuccess = false;
        OtaPackageId targetOtaPackageId = new OtaPackageId(new UUID(msg.getOtaPackageIdMSB(), msg.getOtaPackageIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(msg.getDeviceIdMSB(), msg.getDeviceIdLSB()));
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
        OtaPackageType firmwareType = OtaPackageType.valueOf((String)msg.getType());
        long ts = msg.getTs();
        Device device = this.deviceService.findDeviceById(tenantId, deviceId);
        if (device == null) {
            log.warn("[{}] [{}] Device was removed during OtaPackage update msg was queued!", (Object)tenantId, (Object)deviceId);
        } else {
            OtaPackageInfo currentOtaPackage = this.otaPackageService.findOtaPackageInfoByDeviceIdAndType(deviceId, firmwareType);
            if (currentOtaPackage != null && targetOtaPackageId.equals((Object)currentOtaPackage.getId())) {
                this.update(device, currentOtaPackage, ts);
                isSuccess = true;
            } else {
                log.warn("[{}] [{}] Can`t update OtaPackage for the device, target firmwareId: [{}], current firmware: [{}]!", new Object[]{tenantId, deviceId, targetOtaPackageId, currentOtaPackage});
            }
        }
        return isSuccess;
    }

    private void send(TenantId tenantId, DeviceId deviceId, OtaPackageId otaPackageId, long ts, OtaPackageType otaPackageType) {
        this.dbExecutor.execute(() -> {
            TransportProtos.ToOtaPackageStateServiceMsg msg = TransportProtos.ToOtaPackageStateServiceMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setOtaPackageIdMSB(otaPackageId.getId().getMostSignificantBits()).setOtaPackageIdLSB(otaPackageId.getId().getLeastSignificantBits()).setType(otaPackageType.name()).setTs(ts).build();
            OtaPackageInfo firmware = this.otaPackageService.findOtaPackageInfoById(tenantId, otaPackageId);
            if (firmware == null) {
                log.warn("[{}] Failed to send OtaPackage update because firmware was already deleted", (Object)otaPackageId);
                return;
            }
            CountDownLatch latch = new CountDownLatch(1);
            ArrayList<BaseAttributeKvEntry> attributes = new ArrayList<BaseAttributeKvEntry>();
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.ID), firmware.getId().toString())));
            this.telemetryService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).scope(AttributeScope.SERVER_SCOPE).entries(attributes).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                log.error("Failed to await saving {} id to attributes.", (Object)otaPackageType);
                return;
            }
            ArrayList<BasicTsKvEntry> telemetry = new ArrayList<BasicTsKvEntry>();
            telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TITLE), firmware.getTitle())));
            telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.VERSION), firmware.getVersion())));
            if (StringUtils.isNotEmpty((String)firmware.getTag())) {
                telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TAG), firmware.getTag())));
            }
            telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TS), Long.valueOf(ts))));
            telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.STATE), OtaPackageUpdateStatus.QUEUED.name())));
            this.telemetryService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).entries(telemetry).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
            TopicPartitionInfo tpi = new TopicPartitionInfo(this.otaPackageStateMsgProducer.getDefaultTopic(), null, null, false);
            this.otaPackageStateMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), null);
        });
    }

    private void update(Device device, OtaPackageInfo otaPackage, long ts) {
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        OtaPackageType otaPackageType = otaPackage.getType();
        BasicTsKvEntry status = new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new StringDataEntry(OtaPackageUtil.getTelemetryKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.STATE), OtaPackageUpdateStatus.INITIATED.name()));
        this.telemetryService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).entry((TsKvEntry)status).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private void updateAttributes(Device device, OtaPackageInfo otaPackage, long ts, TenantId tenantId, DeviceId deviceId, OtaPackageType otaPackageType) {
        ArrayList<BaseAttributeKvEntry> attributes = new ArrayList<BaseAttributeKvEntry>();
        ArrayList<String> attrToRemove = new ArrayList<String>();
        attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TITLE), otaPackage.getTitle())));
        attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.VERSION), otaPackage.getVersion())));
        if (StringUtils.isNotEmpty((String)otaPackage.getTag())) {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TAG), otaPackage.getTag())));
        } else {
            attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TAG));
        }
        if (otaPackage.hasUrl()) {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.URL), otaPackage.getUrl())));
            if (otaPackage.getDataSize() == null) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE), otaPackage.getDataSize())));
            }
            if (otaPackage.getChecksumAlgorithm() == null) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM), otaPackage.getChecksumAlgorithm().name())));
            }
            if (StringUtils.isEmpty((String)otaPackage.getChecksum())) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM), otaPackage.getChecksum())));
            }
        } else {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE), otaPackage.getDataSize())));
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM), otaPackage.getChecksumAlgorithm().name())));
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM), otaPackage.getChecksum())));
            attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.URL));
        }
        this.remove(device, otaPackageType, attrToRemove);
        this.telemetryService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).scope(AttributeScope.SHARED_SCOPE).entries(attributes).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private void remove(Device device, OtaPackageType otaPackageType) {
        this.remove(device, otaPackageType, OtaPackageUtil.getAttributeKeys((OtaPackageType)otaPackageType));
        String idKey = OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.ID);
        List<String> idKeyList = Collections.singletonList(idKey);
        this.telemetryService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(device.getTenantId()).entityId((EntityId)device.getId()).scope(AttributeScope.SERVER_SCOPE).keys(idKeyList).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private void remove(Device device, OtaPackageType otaPackageType, List<String> attributesKeys) {
        this.telemetryService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(device.getTenantId()).entityId((EntityId)device.getId()).scope(AttributeScope.SHARED_SCOPE).keys(attributesKeys).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    private PageLink createPageLink() {
        return new PageLink(100);
    }
}

