/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.util.Collection;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.EntityActionNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.EntityActionTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EntityActionNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class EntityActionTriggerProcessor
implements NotificationRuleTriggerProcessor<EntityActionTrigger, EntityActionNotificationRuleTriggerConfig> {
    public boolean matchesFilter(EntityActionTrigger trigger, EntityActionNotificationRuleTriggerConfig triggerConfig) {
        return (trigger.getActionType() == ActionType.ADDED && triggerConfig.isCreated() || trigger.getActionType() == ActionType.UPDATED && triggerConfig.isUpdated() || trigger.getActionType() == ActionType.DELETED && triggerConfig.isDeleted()) && CollectionsUtil.emptyOrContains((Collection)triggerConfig.getEntityTypes(), (Object)trigger.getEntityId().getEntityType());
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(EntityActionTrigger trigger) {
        EntityId ownerId;
        Object customerId = trigger.getEntity() instanceof HasOwnerId ? ((ownerId = ((HasOwnerId)trigger.getEntity()).getOwnerId()) instanceof CustomerId ? (CustomerId)ownerId : null) : (trigger.getEntity() instanceof HasCustomerId ? ((HasCustomerId)trigger.getEntity()).getCustomerId() : trigger.getUser().getCustomerId());
        return EntityActionNotificationInfo.builder().entityId(trigger.getEntityId()).entityName(trigger.getEntity().getName()).actionType(trigger.getActionType()).userId(trigger.getUser().getUuidId()).userTitle(trigger.getUser().getTitle()).userEmail(trigger.getUser().getEmail()).userFirstName(trigger.getUser().getFirstName()).userLastName(trigger.getUser().getLastName()).customerId(customerId).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ENTITY_ACTION;
    }
}

