/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmStatusFilter;
import org.thingsboard.server.common.data.notification.info.AlarmNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.AlarmTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.AlarmNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class AlarmTriggerProcessor
implements NotificationRuleTriggerProcessor<AlarmTrigger, AlarmNotificationRuleTriggerConfig> {
    public boolean matchesFilter(AlarmTrigger trigger, AlarmNotificationRuleTriggerConfig triggerConfig) {
        AlarmApiCallResult alarmUpdate = trigger.getAlarmUpdate();
        AlarmInfo alarm = alarmUpdate.getAlarm();
        if (!this.typeMatches((Alarm)alarm, triggerConfig)) {
            return false;
        }
        if (alarmUpdate.isCreated()) {
            if (triggerConfig.getNotifyOn().contains(AlarmNotificationRuleTriggerConfig.AlarmAction.CREATED)) {
                return this.severityMatches((Alarm)alarm, triggerConfig);
            }
        } else {
            if (alarmUpdate.isSeverityChanged()) {
                if (triggerConfig.getNotifyOn().contains(AlarmNotificationRuleTriggerConfig.AlarmAction.SEVERITY_CHANGED)) {
                    return this.severityMatches(alarmUpdate.getOld(), triggerConfig) || this.severityMatches((Alarm)alarm, triggerConfig);
                }
                return !this.severityMatches(alarmUpdate.getOld(), triggerConfig) && this.severityMatches((Alarm)alarm, triggerConfig);
            }
            if (alarmUpdate.isAcknowledged() ? triggerConfig.getNotifyOn().contains(AlarmNotificationRuleTriggerConfig.AlarmAction.ACKNOWLEDGED) : alarmUpdate.isCleared() && triggerConfig.getNotifyOn().contains(AlarmNotificationRuleTriggerConfig.AlarmAction.CLEARED)) {
                return this.severityMatches((Alarm)alarm, triggerConfig);
            }
        }
        return false;
    }

    public boolean matchesClearRule(AlarmTrigger trigger, AlarmNotificationRuleTriggerConfig triggerConfig) {
        AlarmApiCallResult alarmUpdate = trigger.getAlarmUpdate();
        AlarmInfo alarm = alarmUpdate.getAlarm();
        if (!this.typeMatches((Alarm)alarm, triggerConfig)) {
            return false;
        }
        if (alarmUpdate.isDeleted()) {
            return true;
        }
        AlarmNotificationRuleTriggerConfig.ClearRule clearRule = triggerConfig.getClearRule();
        if (clearRule != null && CollectionUtils.isNotEmpty((Collection)clearRule.getAlarmStatuses())) {
            return AlarmStatusFilter.from((Collection)clearRule.getAlarmStatuses()).matches((Alarm)alarm);
        }
        return false;
    }

    private boolean severityMatches(Alarm alarm, AlarmNotificationRuleTriggerConfig triggerConfig) {
        return CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmSeverities(), (Object)alarm.getSeverity());
    }

    private boolean typeMatches(Alarm alarm, AlarmNotificationRuleTriggerConfig triggerConfig) {
        return CollectionsUtil.emptyOrContains((Collection)triggerConfig.getAlarmTypes(), (Object)alarm.getType());
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(AlarmTrigger trigger) {
        AlarmApiCallResult alarmUpdate = trigger.getAlarmUpdate();
        AlarmInfo alarmInfo = alarmUpdate.getAlarm();
        return AlarmNotificationInfo.builder().alarmId(alarmInfo.getUuidId()).alarmType(alarmInfo.getType()).action(alarmUpdate.isCreated() ? "created" : (alarmUpdate.isSeverityChanged() ? "severity changed" : (alarmUpdate.isAcknowledged() ? "acknowledged" : (alarmUpdate.isCleared() ? "cleared" : (alarmUpdate.isDeleted() ? "deleted" : null))))).alarmOriginator(alarmInfo.getOriginator()).alarmOriginatorName(alarmInfo.getOriginatorName()).alarmSeverity(alarmInfo.getSeverity()).alarmStatus(alarmInfo.getStatus()).acknowledged(alarmInfo.isAcknowledged()).cleared(alarmInfo.isCleared()).alarmCustomerId(alarmInfo.getCustomerId()).dashboardId(alarmInfo.getDashboardId()).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.ALARM;
    }
}

