/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.license;

import java.beans.ConstructorProperties;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.license.client.TbLicenseStatisticsService;
import org.thingsboard.license.shared.TbInstanceStatistics;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AggregationParams;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.converter.ConverterDao;
import org.thingsboard.server.dao.dashboard.DashboardDao;
import org.thingsboard.server.dao.device.DeviceDao;
import org.thingsboard.server.dao.entity.EntityDaoRegistry;
import org.thingsboard.server.dao.integration.IntegrationDao;
import org.thingsboard.server.dao.mobile.QrCodeSettingsDao;
import org.thingsboard.server.dao.report.ReportDao;
import org.thingsboard.server.dao.report.ReportTemplateDao;
import org.thingsboard.server.dao.rule.RuleNodeDao;
import org.thingsboard.server.dao.secret.SecretDao;
import org.thingsboard.server.dao.sql.job.JpaJobDao;
import org.thingsboard.server.dao.tenant.TenantDao;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.usagerecord.ApiUsageStateDao;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.install.ProjectInfo;
import org.thingsboard.server.service.solutions.SolutionService;
import org.thingsboard.server.service.solutions.data.solution.SolutionTemplate;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInfo;

@Service
@TbCoreComponent
@ConditionalOnProperty(prefix="license.stats", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class DefaultTbLicenseStatisticsService
implements TbLicenseStatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbLicenseStatisticsService.class);
    private static final List<EntityType> COUNTED_TYPES = List.of(EntityType.TENANT, EntityType.CUSTOMER, EntityType.USER, EntityType.DEVICE, EntityType.ASSET, EntityType.RULE_CHAIN, EntityType.DASHBOARD, EntityType.CALCULATED_FIELD, EntityType.DOMAIN, EntityType.QUEUE, EntityType.MOBILE_APP);
    private final EntityDaoRegistry entityDaoRegistry;
    private final IntegrationDao integrationDao;
    private final RuleNodeDao ruleNodeDao;
    private final ConverterDao converterDao;
    private final DashboardDao dashboardDao;
    private final ApiUsageStateDao apiUsageStateDao;
    private final TimeseriesService timeseriesService;
    private final TenantDao tenantDao;
    private final JpaJobDao jpaJobDao;
    private final SecretDao secretDao;
    private final QrCodeSettingsDao qrCodeSettingsDao;
    private final DeviceDao deviceDao;
    private final ProjectInfo projectInfo;
    private final SolutionService solutionService;
    private final JdbcTemplate jdbcTemplate;
    private final PartitionService partitionService;
    private final ReportDao reportDao;
    private final ReportTemplateDao reportTemplateDao;
    @Value(value="#{('${database.ts.type}' == 'cassandra') or ('${database.ts_latest.type}' == 'cassandra')}")
    private boolean cassandra;
    @Value(value="#{('${database.ts.type}' == 'timescale') or ('${database.ts_latest.type}' == 'timescale')}")
    private boolean timescale;

    public TbInstanceStatistics getCurrentStatistics() {
        if (this.partitionService.isSystemPartitionMine(ServiceType.TB_CORE)) {
            return this.getTbInstanceStatistics();
        }
        return null;
    }

    private TbInstanceStatistics getTbInstanceStatistics() {
        TbInstanceStatistics statistics = new TbInstanceStatistics();
        HashMap<String, Long> entitiesCounts = new HashMap<String, Long>();
        for (EntityType entityType : COUNTED_TYPES) {
            entitiesCounts.put(entityType.name(), this.getSafely(() -> this.entityDaoRegistry.getDao(entityType).count()));
        }
        statistics.setEntitiesCounts(entitiesCounts);
        statistics.setRuleNodeTypes((Map)this.getSafely(() -> this.ruleNodeDao.countRuleNodesPerType().entrySet().stream().collect(Collectors.toMap(entry -> this.prepareRuleNodeType((String)entry.getKey()), Map.Entry::getValue)), Collections.emptyMap()));
        statistics.setIntegrationsCountsPerType((Map)this.getSafely(() -> ((IntegrationDao)this.integrationDao).countIntegrationsPerType(), null));
        statistics.setDevicesCountsPerTransportType((Map)this.getSafely(() -> ((DeviceDao)this.deviceDao).countDevicesPerTransportType(), null));
        statistics.setJobsByTypeAndStatusLastMonth((Map)this.getSafely(() -> ((JpaJobDao)this.jpaJobDao).countJobsByTypeAndStatusLastMonth(), null));
        statistics.setSecretsPerType((Map)this.getSafely(() -> ((SecretDao)this.secretDao).countSecretsPerType(), null));
        statistics.setReportsCountsPerFormatType((Map)this.getSafely(() -> ((ReportDao)this.reportDao).countReportsByType(), null));
        statistics.setReportTemplatesByFormatAndType((Map)this.getSafely(() -> ((ReportTemplateDao)this.reportTemplateDao).countTemplateByFormatAndType(), null));
        statistics.setGenericConverters(this.getSafely(() -> ((ConverterDao)this.converterDao).countGenericConverters()).longValue());
        statistics.setTypedConverters(this.getSafely(() -> ((ConverterDao)this.converterDao).countTypedConverters()).longValue());
        statistics.setDedicatedConverters(this.getSafely(() -> ((ConverterDao)this.converterDao).countDedicatedConverters()).longValue());
        statistics.setJsConvertersCount(this.getSafely(() -> ((ConverterDao)this.converterDao).countByJsScriptLang()).longValue());
        statistics.setTbelConvertersCount(this.getSafely(() -> ((ConverterDao)this.converterDao).countByTbelScriptLang()).longValue());
        statistics.setScadaDashboardsCount(this.getSafely(() -> ((DashboardDao)this.dashboardDao).countScadaDashboards()).longValue());
        statistics.setPostgresDbSize(((Double)this.getSafely(() -> this.getDatabaseSize(), (Object)-1.0)).doubleValue());
        statistics.setQrCodeUsage(this.getSafely(() -> ((QrCodeSettingsDao)this.qrCodeSettingsDao).count()).longValue());
        statistics.setTbVersion(this.projectInfo.getProjectVersion());
        statistics.setCassandra(this.cassandra);
        statistics.setTimescale(this.timescale);
        statistics.setPlatform((String)this.getSafely(() -> System.getProperty("platform", "deb"), (Object)"deb"));
        statistics.setSolutionTemplatesCountPerName((Map)this.getSafely(() -> this.tenantDao.findTenantsIds().stream().map(tenantId -> {
            try {
                return this.solutionService.getSolutionInfos(tenantId).stream().filter(TenantSolutionTemplateInfo::isInstalled).collect(Collectors.groupingBy(SolutionTemplate::getId, Collectors.counting()));
            }
            catch (Exception e) {
                log.debug("solution template: unable to execute task", (Throwable)e);
                return Collections.emptyMap();
            }
        }).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Long)entry.getValue(), Long::sum)), Collections.emptyMap()));
        statistics.setApiUsageInLastDay((Map)this.getSafely(() -> {
            ApiUsageState apiUsage = this.apiUsageStateDao.findTenantApiUsageState(TenantId.SYS_TENANT_ID.getId());
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime endDay = now.truncatedTo(ChronoUnit.DAYS);
            ZonedDateTime startDay = endDay.minusDays(1L);
            long startTs = startDay.toInstant().toEpochMilli();
            long endTs = endDay.toInstant().toEpochMilli();
            List queries = Arrays.stream(ApiUsageRecordKey.values()).map(ApiUsageRecordKey::getApiCountKey).filter(Objects::nonNull).map(key -> new BaseReadTsKvQuery(key + "Hourly", startTs, endTs, AggregationParams.none(), 24, "DESC")).collect(Collectors.toList());
            try {
                return ((List)this.timeseriesService.findAllByQueries(TenantId.SYS_TENANT_ID, (EntityId)apiUsage.getId(), queries).get(30L, TimeUnit.SECONDS)).stream().map(ReadTsKvQueryResult::getData).filter(e -> !e.isEmpty()).flatMap(Collection::stream).collect(Collectors.groupingBy(KvEntry::getKey, Collectors.toMap(TsKvEntry::getTs, e -> e.getLongValue().orElse(-1L))));
            }
            catch (Exception e2) {
                log.debug("api usage: unable to execute task", (Throwable)e2);
                return Collections.emptyMap();
            }
        }, Collections.emptyMap()));
        return statistics;
    }

    private Long getSafely(Supplier<Long> task) {
        return (Long)this.getSafely(task, (Object)-1L);
    }

    private <T> T getSafely(Supplier<T> task, T defaultValue) {
        try {
            return task.get();
        }
        catch (Exception e) {
            log.debug("getSafely: unable to execute task", (Throwable)e);
            return defaultValue;
        }
    }

    private String prepareRuleNodeType(String type) {
        if (!type.startsWith("org.thingsboard")) {
            return "custom." + type.substring(type.lastIndexOf(46) + 1);
        }
        return type;
    }

    private double getDatabaseSize() {
        String sql = "SELECT ROUND(pg_database_size(current_database())::numeric/POWER(1024::numeric,3),2)";
        try {
            return (Double)this.jdbcTemplate.queryForObject(sql, Double.class);
        }
        catch (Exception e) {
            log.debug("getDatabaseSize(): unable to execute task", (Throwable)e);
            return -1.0;
        }
    }

    @ConstructorProperties(value={"entityDaoRegistry", "integrationDao", "ruleNodeDao", "converterDao", "dashboardDao", "apiUsageStateDao", "timeseriesService", "tenantDao", "jpaJobDao", "secretDao", "qrCodeSettingsDao", "deviceDao", "projectInfo", "solutionService", "jdbcTemplate", "partitionService", "reportDao", "reportTemplateDao"})
    @Generated
    public DefaultTbLicenseStatisticsService(EntityDaoRegistry entityDaoRegistry, IntegrationDao integrationDao, RuleNodeDao ruleNodeDao, ConverterDao converterDao, DashboardDao dashboardDao, ApiUsageStateDao apiUsageStateDao, TimeseriesService timeseriesService, TenantDao tenantDao, JpaJobDao jpaJobDao, SecretDao secretDao, QrCodeSettingsDao qrCodeSettingsDao, DeviceDao deviceDao, ProjectInfo projectInfo, SolutionService solutionService, JdbcTemplate jdbcTemplate, PartitionService partitionService, ReportDao reportDao, ReportTemplateDao reportTemplateDao) {
        this.entityDaoRegistry = entityDaoRegistry;
        this.integrationDao = integrationDao;
        this.ruleNodeDao = ruleNodeDao;
        this.converterDao = converterDao;
        this.dashboardDao = dashboardDao;
        this.apiUsageStateDao = apiUsageStateDao;
        this.timeseriesService = timeseriesService;
        this.tenantDao = tenantDao;
        this.jpaJobDao = jpaJobDao;
        this.secretDao = secretDao;
        this.qrCodeSettingsDao = qrCodeSettingsDao;
        this.deviceDao = deviceDao;
        this.projectInfo = projectInfo;
        this.solutionService = solutionService;
        this.jdbcTemplate = jdbcTemplate;
        this.partitionService = partitionService;
        this.reportDao = reportDao;
        this.reportTemplateDao = reportTemplateDao;
    }
}

