/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.JavaSerDesUtil;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.event.ConverterDebugEvent;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.event.IntegrationDebugEvent;
import org.thingsboard.server.common.data.event.LifecycleEvent;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.ConnectRequestMsg;
import org.thingsboard.server.gen.integration.ConnectResponseCode;
import org.thingsboard.server.gen.integration.ConnectResponseMsg;
import org.thingsboard.server.gen.integration.ConverterConfigurationProto;
import org.thingsboard.server.gen.integration.ConverterUpdateMsg;
import org.thingsboard.server.gen.integration.DeviceDownlinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.DownlinkMsg;
import org.thingsboard.server.gen.integration.EntityViewDataProto;
import org.thingsboard.server.gen.integration.IntegrationConfigurationProto;
import org.thingsboard.server.gen.integration.IntegrationStatisticsProto;
import org.thingsboard.server.gen.integration.IntegrationUpdateMsg;
import org.thingsboard.server.gen.integration.RequestMsg;
import org.thingsboard.server.gen.integration.ResponseMsg;
import org.thingsboard.server.gen.integration.TbEventProto;
import org.thingsboard.server.gen.integration.UplinkMsg;
import org.thingsboard.server.gen.integration.UplinkResponseMsg;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.integration.IntegrationContextComponent;
import org.thingsboard.server.service.integration.rpc.IntegrationGrpcSession;
import org.thingsboard.server.service.integration.rpc.SyncedStreamObserver;

public final class IntegrationGrpcSession
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationGrpcSession.class);
    private static final ReentrantLock entityCreationLock = new ReentrantLock();
    private final Gson gson = new Gson();
    private final UUID sessionId = UUID.randomUUID();
    private final BiConsumer<IntegrationId, IntegrationGrpcSession> sessionOpenListener;
    private final Consumer<IntegrationId> sessionCloseListener;
    private final SyncedStreamObserver<ResponseMsg> outputStream;
    private IntegrationContextComponent ctx;
    private Integration configuration;
    private StreamObserver<RequestMsg> inputStream;
    private volatile boolean connected;
    private String serviceId;

    IntegrationGrpcSession(IntegrationContextComponent ctx, StreamObserver<ResponseMsg> outputStream, BiConsumer<IntegrationId, IntegrationGrpcSession> sessionOpenListener, Consumer<IntegrationId> sessionCloseListener) {
        this.ctx = ctx;
        this.outputStream = new SyncedStreamObserver(outputStream);
        this.sessionOpenListener = sessionOpenListener;
        this.sessionCloseListener = sessionCloseListener;
        this.initInputStream();
    }

    private void initInputStream() {
        this.inputStream = new /* Unavailable Anonymous Inner Class!! */;
    }

    private ConnectResponseMsg processConnect(ConnectRequestMsg request) {
        Optional optional = this.ctx.getIntegrationService().findIntegrationByRoutingKey(TenantId.SYS_TENANT_ID, request.getIntegrationRoutingKey());
        if (optional.isPresent()) {
            this.configuration = (Integration)optional.get();
            try {
                if (this.configuration.isRemote().booleanValue() && this.configuration.getSecret().equals(request.getIntegrationSecret())) {
                    Converter defaultConverter = this.ctx.getConverterService().findConverterById(this.configuration.getTenantId(), this.configuration.getDefaultConverterId());
                    ConverterConfigurationProto defaultConverterProto = this.constructConverterConfigProto(defaultConverter);
                    ConverterConfigurationProto downLinkConverterProto = ConverterConfigurationProto.getDefaultInstance();
                    if (this.configuration.getDownlinkConverterId() != null) {
                        Converter downlinkConverter = this.ctx.getConverterService().findConverterById(this.configuration.getTenantId(), this.configuration.getDownlinkConverterId());
                        downLinkConverterProto = this.constructConverterConfigProto(downlinkConverter);
                    }
                    this.connected = true;
                    this.sessionOpenListener.accept(this.configuration.getId(), this);
                    return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.ACCEPTED).setErrorMsg("").setConfiguration(this.constructIntegrationConfigProto(this.configuration, defaultConverterProto, downLinkConverterProto)).build();
                }
                return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.BAD_CREDENTIALS).setErrorMsg("Failed to validate the integration!").setConfiguration(IntegrationConfigurationProto.getDefaultInstance()).build();
            }
            catch (Exception e) {
                log.error("[{}] Failed to process integration connection!", (Object)request.getIntegrationRoutingKey(), (Object)e);
                return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.SERVER_UNAVAILABLE).setErrorMsg("Failed to process integration connection!").setConfiguration(IntegrationConfigurationProto.getDefaultInstance()).build();
            }
        }
        return ConnectResponseMsg.newBuilder().setResponseCode(ConnectResponseCode.BAD_CREDENTIALS).setErrorMsg("Failed to find the integration! Routing key: " + request.getIntegrationRoutingKey()).setConfiguration(IntegrationConfigurationProto.getDefaultInstance()).build();
    }

    UplinkResponseMsg processUplinkMsg(UplinkMsg msg) {
        try {
            TbMsg tbMsg;
            if (msg.getDeviceDataCount() > 0) {
                for (DeviceUplinkDataProto data : msg.getDeviceDataList()) {
                    this.ctx.getRateLimitService().checkLimit(this.configuration.getTenantId(), () -> ((DeviceUplinkDataProto)data).toString());
                    this.ctx.getRateLimitService().checkLimitPerDevice(this.configuration.getTenantId(), data.getDeviceName(), () -> ((DeviceUplinkDataProto)data).toString());
                    UUID sessionId = this.sessionId;
                    this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, sessionId, data, null).run();
                }
            }
            if (msg.getAssetDataCount() > 0) {
                for (DeviceUplinkDataProto data : msg.getAssetDataList()) {
                    this.ctx.getRateLimitService().checkLimit(this.configuration.getTenantId(), () -> ((AssetUplinkDataProto)data).toString());
                    this.ctx.getRateLimitService().checkLimitPerAsset(this.configuration.getTenantId(), data.getAssetName(), () -> ((AssetUplinkDataProto)data).toString());
                    this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, (AssetUplinkDataProto)data, null).run();
                }
            }
            if (msg.getEntityViewDataCount() > 0) {
                for (DeviceUplinkDataProto data : msg.getEntityViewDataList()) {
                    this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, (EntityViewDataProto)data, null).run();
                }
            }
            if (msg.getIntegrationStatisticsCount() > 0) {
                for (DeviceUplinkDataProto data : msg.getIntegrationStatisticsList()) {
                    this.processIntegrationStatistics((IntegrationStatisticsProto)data);
                }
            }
            if (msg.getEventsDataCount() > 0) {
                for (TbEventProto proto : msg.getEventsDataList()) {
                    switch (4.$SwitchMap$org$thingsboard$server$gen$integration$TbEventSource[proto.getSource().ordinal()]) {
                        case 1: {
                            this.ctx.getRateLimitService().checkLimit(this.configuration.getTenantId(), this.configuration.getId(), true);
                            this.saveEvent(this.configuration.getTenantId(), (EntityId)this.configuration.getId(), proto);
                            break;
                        }
                        case 2: {
                            if (this.ctx.getRateLimitService().checkLimit(this.configuration.getTenantId(), this.configuration.getDefaultConverterId(), false)) {
                                this.saveEvent(this.configuration.getTenantId(), (EntityId)this.configuration.getDefaultConverterId(), proto);
                                break;
                            }
                            this.sendConverterRateLimitEvent(proto);
                            break;
                        }
                        case 3: {
                            this.saveEvent(this.configuration.getTenantId(), (EntityId)this.configuration.getDownlinkConverterId(), proto);
                            break;
                        }
                        case 4: {
                            Device device = this.ctx.getDeviceService().findDeviceByTenantIdAndName(this.configuration.getTenantId(), proto.getDeviceName());
                            if (device == null) break;
                            this.saveEvent(this.configuration.getTenantId(), (EntityId)device.getId(), proto);
                        }
                    }
                }
            }
            if (msg.getTbMsgCount() > 0) {
                for (ByteString tbMsgByteString : msg.getTbMsgList()) {
                    tbMsg = TbMsg.fromProto(null, null, (ByteString)tbMsgByteString, (TbMsgCallback)TbMsgCallback.EMPTY);
                    this.ctx.getPlatformIntegrationService().process(this.configuration.getTenantId(), tbMsg, null);
                }
            }
            if (msg.getTbMsgProtoCount() > 0) {
                for (MsgProtos.TbMsgProto tbMsgProto : msg.getTbMsgProtoList()) {
                    tbMsg = TbMsg.fromProto(null, (MsgProtos.TbMsgProto)tbMsgProto, null, (TbMsgCallback)TbMsgCallback.EMPTY);
                    this.ctx.getPlatformIntegrationService().process(this.configuration.getTenantId(), tbMsg, null);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof TbRateLimitsException) {
                this.sendIntegrationRateLimitEvent((TbRateLimitsException)e, msg.toString());
            }
            String errorMsg = e.getMessage() != null ? e.getMessage() : "";
            return UplinkResponseMsg.newBuilder().setSuccess(false).setErrorMsg(errorMsg).build();
        }
        return UplinkResponseMsg.newBuilder().setSuccess(true).setErrorMsg("").build();
    }

    private void sendIntegrationRateLimitEvent(TbRateLimitsException exception, String message) {
        IntegrationId integrationId = this.configuration.getId();
        EntityType limitedEntity = exception.getEntityType();
        if (this.ctx.getRateLimitService().alreadyProcessed((EntityId)integrationId, limitedEntity)) {
            log.trace("[{}] [{}] [{}] Rate limited debug event already sent.", new Object[]{this.configuration.getTenantId(), integrationId, limitedEntity});
            return;
        }
        IntegrationDebugEvent.IntegrationDebugEventBuilder event = IntegrationDebugEvent.builder().tenantId(this.configuration.getTenantId()).entityId(this.configuration.getId().getId()).serviceId(this.serviceId).eventType("Uplink").message(message).status("ERROR").error(exception.getMessage());
        this.saveEvent(this.configuration.getTenantId(), (EntityId)this.configuration.getId(), (Event)event.build());
    }

    private void sendConverterRateLimitEvent(TbEventProto proto) {
        ConverterId converterId = this.configuration.getDefaultConverterId();
        if (this.ctx.getRateLimitService().alreadyProcessed((EntityId)converterId, EntityType.CONVERTER)) {
            log.trace("[{}] [{}] Converter rate limited debug event already sent.", (Object)this.configuration.getTenantId(), (Object)converterId);
            return;
        }
        ConverterDebugEvent event = (ConverterDebugEvent)JavaSerDesUtil.decode((byte[])proto.getEvent().toByteArray());
        ConverterDebugEvent.ConverterDebugEventBuilder newConverterEvent = ConverterDebugEvent.builder().tenantId(this.configuration.getTenantId()).entityId(converterId.getId()).serviceId(this.getServiceId()).eventType("Uplink").inMsgType(event.getInMsgType()).inMsg(event.getInMsg()).outMsgType(null).outMsg(null).metadata(event.getMetadata()).error("Converter debug rate limits reached!");
        this.saveEvent(this.configuration.getTenantId(), (EntityId)converterId, (Event)newConverterEvent.build());
    }

    private void saveEvent(TenantId tenantId, EntityId entityId, TbEventProto proto) {
        try {
            if (!proto.getEvent().isEmpty()) {
                Event event = (Event)JavaSerDesUtil.decode((byte[])proto.getEvent().toByteArray());
                if (event != null) {
                    event.setTenantId(tenantId);
                    event.setEntityId(entityId.getId());
                    this.saveEvent(tenantId, entityId, event);
                } else {
                    log.warn("[{}][{}] Failed to decode event. Remote integration [{}] version is not compatible with new event api", new Object[]{tenantId, this.configuration.getId(), this.configuration.getName()});
                }
            } else {
                log.warn("[{}][{}] Remote integration [{}] version is not compatible with new event api", new Object[]{tenantId, this.configuration.getId(), this.configuration.getName()});
            }
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to convert event body from remote integration [{}]!", new Object[]{tenantId, this.configuration.getId(), this.configuration.getName(), e});
        }
    }

    private void saveEvent(TenantId tenantId, EntityId entityId, Event event) {
        try {
            ListenableFuture future = this.ctx.getEventService().saveAsync(event);
            if (entityId.getEntityType().equals((Object)EntityType.INTEGRATION) && event.getType().equals((Object)EventType.LC_EVENT)) {
                LifecycleEvent lcEvent = (LifecycleEvent)event;
                String key = "integration_status_" + event.getServiceId().toLowerCase();
                if (lcEvent.getLcEventType().equals("STARTED") || lcEvent.getLcEventType().equals("UPDATED")) {
                    ObjectNode value = JacksonUtil.newObjectNode();
                    if (lcEvent.isSuccess()) {
                        value.put("success", true);
                    } else {
                        value.put("success", false);
                        value.put("serviceId", lcEvent.getServiceId());
                        value.put("error", lcEvent.getError());
                    }
                    BaseAttributeKvEntry attr = new BaseAttributeKvEntry((KvEntry)new JsonDataEntry(key, JacksonUtil.toString((Object)value)), event.getCreatedTime());
                    future = Futures.transform((ListenableFuture)future, arg_0 -> this.lambda$saveEvent$0(tenantId, entityId, (AttributeKvEntry)attr, arg_0), (Executor)MoreExecutors.directExecutor());
                } else if (lcEvent.getLcEventType().equals("STOPPED")) {
                    future = Futures.transform((ListenableFuture)future, v -> {
                        this.ctx.getAttributesService().removeAll(tenantId, entityId, AttributeScope.SERVER_SCOPE, Collections.singletonList(key));
                        return null;
                    }, (Executor)MoreExecutors.directExecutor());
                }
            }
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            log.warn("[{}] Failed to save event!", (Object)event, (Object)e);
        }
    }

    private IntegrationConfigurationProto constructIntegrationConfigProto(Integration configuration, ConverterConfigurationProto defaultConverterProto, ConverterConfigurationProto downLinkConverterProto) throws JsonProcessingException {
        Integration copy = new Integration(configuration);
        this.ctx.getSecretConfigurationService().replaceSecretUsages(copy.getTenantId(), copy.getConfiguration());
        IntegrationConfigurationProto.Builder builder = IntegrationConfigurationProto.newBuilder().setIntegrationIdMSB(copy.getId().getId().getMostSignificantBits()).setIntegrationIdLSB(copy.getId().getId().getLeastSignificantBits()).setTenantIdMSB(copy.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(copy.getTenantId().getId().getLeastSignificantBits()).setUplinkConverter(defaultConverterProto).setDownlinkConverter(downLinkConverterProto).setName(copy.getName()).setRoutingKey(copy.getRoutingKey()).setType(copy.getType().toString()).setConfiguration(JacksonUtil.writeValueAsString((Object)copy.getConfiguration())).setAdditionalInfo(JacksonUtil.writeValueAsString((Object)copy.getAdditionalInfo())).setEnabled(copy.isEnabled().booleanValue());
        if (copy.getDebugSettings() != null) {
            builder.setDebugSettings(JacksonUtil.toString((Object)copy.getDebugSettings()));
        }
        return builder.build();
    }

    private ConverterConfigurationProto constructConverterConfigProto(Converter converter) throws JsonProcessingException {
        ConverterConfigurationProto.Builder builder = ConverterConfigurationProto.newBuilder().setTenantIdMSB(converter.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(converter.getTenantId().getId().getLeastSignificantBits()).setConverterIdMSB(converter.getId().getId().getMostSignificantBits()).setConverterIdLSB(converter.getId().getId().getLeastSignificantBits()).setName(converter.getName()).setConfiguration(JacksonUtil.toString((Object)converter.getConfiguration())).setAdditionalInfo(JacksonUtil.toString((Object)converter.getAdditionalInfo()));
        if (converter.getDebugSettings() != null) {
            builder.setDebugSettings(JacksonUtil.toString((Object)converter.getDebugSettings()));
        }
        if (converter.getIntegrationType() != null) {
            builder.setIntegrationType(converter.getIntegrationType().toString());
        }
        return builder.build();
    }

    @Override
    public void close() {
        log.debug("[{}][{}] Closing session", (Object)this.sessionId, (Object)this.configuration.getId());
        this.connected = false;
        try {
            this.outputStream.onCompleted();
        }
        catch (Exception e) {
            log.debug("[{}] Failed to close output stream: {}", (Object)this.sessionId, (Object)e.getMessage());
        }
    }

    void onConfigurationUpdate(Integration configuration) {
        try {
            Converter defaultConverter = this.ctx.getConverterService().findConverterById(configuration.getTenantId(), configuration.getDefaultConverterId());
            ConverterConfigurationProto defaultConverterProto = this.constructConverterConfigProto(defaultConverter);
            ConverterConfigurationProto downLinkConverterProto = ConverterConfigurationProto.getDefaultInstance();
            if (configuration.getDownlinkConverterId() != null) {
                Converter downlinkConverter = this.ctx.getConverterService().findConverterById(configuration.getTenantId(), configuration.getDownlinkConverterId());
                downLinkConverterProto = this.constructConverterConfigProto(downlinkConverter);
            }
            this.configuration = configuration;
            this.outputStream.onNext((Object)ResponseMsg.newBuilder().setIntegrationUpdateMsg(IntegrationUpdateMsg.newBuilder().setConfiguration(this.constructIntegrationConfigProto(configuration, defaultConverterProto, downLinkConverterProto)).build()).build());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to construct proto objects!", (Throwable)e);
        }
    }

    void onConverterUpdate(Converter converter) {
        try {
            ConverterConfigurationProto defaultConverterProto = this.constructConverterConfigProto(converter);
            this.outputStream.onNext((Object)ResponseMsg.newBuilder().setConverterUpdateMsg(ConverterUpdateMsg.newBuilder().setConfiguration(defaultConverterProto).build()).build());
        }
        catch (JsonProcessingException e) {
            log.error("Failed to construct proto objects!", (Throwable)e);
        }
    }

    void onDownlink(Device device, IntegrationDownlinkMsg msg) {
        log.debug("[{}] Sending downlink msg [{}]", (Object)this.sessionId, (Object)msg);
        if (this.isConnected()) {
            try {
                this.outputStream.onNext((Object)ResponseMsg.newBuilder().setDownlinkMsg(DownlinkMsg.newBuilder().setDeviceData(DeviceDownlinkDataProto.newBuilder().setDeviceName(device.getName()).setDeviceType(device.getType()).setTbMsgProto(TbMsg.toProto((TbMsg)msg.getTbMsg())).build()).build()).build());
            }
            catch (Exception e) {
                log.error("[{}] Failed to send downlink msg [{}]", new Object[]{this.sessionId, msg, e});
                this.connected = false;
                this.sessionCloseListener.accept(this.configuration.getId());
            }
            log.debug("[{}] Downlink msg successfully sent [{}]", (Object)this.sessionId, (Object)msg);
        } else {
            log.debug("[{}] Ignore downlink due to disconnected session", (Object)this.sessionId);
        }
    }

    private void processIntegrationStatistics(IntegrationStatisticsProto data) {
        ArrayList<BasicTsKvEntry> statsTs = new ArrayList<BasicTsKvEntry>();
        for (TransportProtos.TsKvListProto tsKvListProto : data.getPostTelemetryMsg().getTsKvListList()) {
            for (TransportProtos.KeyValueProto keyValueProto : tsKvListProto.getKvList()) {
                if (keyValueProto.getType().equals((Object)TransportProtos.KeyValueType.LONG_V)) {
                    statsTs.add(new BasicTsKvEntry(tsKvListProto.getTs(), (KvEntry)new LongDataEntry(keyValueProto.getKey(), Long.valueOf(keyValueProto.getLongV()))));
                    continue;
                }
                if (keyValueProto.getType().equals((Object)TransportProtos.KeyValueType.DOUBLE_V)) {
                    statsTs.add(new BasicTsKvEntry(tsKvListProto.getTs(), (KvEntry)new DoubleDataEntry(keyValueProto.getKey(), Double.valueOf(keyValueProto.getDoubleV()))));
                    continue;
                }
                if (keyValueProto.getType().equals((Object)TransportProtos.KeyValueType.BOOLEAN_V)) {
                    statsTs.add(new BasicTsKvEntry(tsKvListProto.getTs(), (KvEntry)new BooleanDataEntry(keyValueProto.getKey(), Boolean.valueOf(keyValueProto.getBoolV()))));
                    continue;
                }
                statsTs.add(new BasicTsKvEntry(tsKvListProto.getTs(), (KvEntry)new StringDataEntry(keyValueProto.getKey(), keyValueProto.getStringV())));
            }
        }
        this.ctx.getTelemetrySubscriptionService().saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(this.configuration.getTenantId()).entityId((EntityId)this.configuration.getId()).entries(statsTs).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public UUID getSessionId() {
        return this.sessionId;
    }

    @Generated
    public BiConsumer<IntegrationId, IntegrationGrpcSession> getSessionOpenListener() {
        return this.sessionOpenListener;
    }

    @Generated
    public Consumer<IntegrationId> getSessionCloseListener() {
        return this.sessionCloseListener;
    }

    @Generated
    public SyncedStreamObserver<ResponseMsg> getOutputStream() {
        return this.outputStream;
    }

    @Generated
    public IntegrationContextComponent getCtx() {
        return this.ctx;
    }

    @Generated
    public Integration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public StreamObserver<RequestMsg> getInputStream() {
        return this.inputStream;
    }

    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setCtx(IntegrationContextComponent ctx) {
        this.ctx = ctx;
    }

    @Generated
    public void setConfiguration(Integration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setInputStream(StreamObserver<RequestMsg> inputStream) {
        this.inputStream = inputStream;
    }

    @Generated
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationGrpcSession)) {
            return false;
        }
        IntegrationGrpcSession other = (IntegrationGrpcSession)o;
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        if (this$gson == null ? other$gson != null : !this$gson.equals(other$gson)) {
            return false;
        }
        UUID this$sessionId = this.getSessionId();
        UUID other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        BiConsumer this$sessionOpenListener = this.getSessionOpenListener();
        BiConsumer other$sessionOpenListener = other.getSessionOpenListener();
        if (this$sessionOpenListener == null ? other$sessionOpenListener != null : !this$sessionOpenListener.equals(other$sessionOpenListener)) {
            return false;
        }
        Consumer this$sessionCloseListener = this.getSessionCloseListener();
        Consumer other$sessionCloseListener = other.getSessionCloseListener();
        if (this$sessionCloseListener == null ? other$sessionCloseListener != null : !this$sessionCloseListener.equals(other$sessionCloseListener)) {
            return false;
        }
        SyncedStreamObserver this$outputStream = this.getOutputStream();
        SyncedStreamObserver other$outputStream = other.getOutputStream();
        if (this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream)) {
            return false;
        }
        IntegrationContextComponent this$ctx = this.getCtx();
        IntegrationContextComponent other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        Integration this$configuration = this.getConfiguration();
        Integration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        StreamObserver this$inputStream = this.getInputStream();
        StreamObserver other$inputStream = other.getInputStream();
        if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConnected() ? 79 : 97);
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        UUID $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        BiConsumer $sessionOpenListener = this.getSessionOpenListener();
        result = result * 59 + ($sessionOpenListener == null ? 43 : $sessionOpenListener.hashCode());
        Consumer $sessionCloseListener = this.getSessionCloseListener();
        result = result * 59 + ($sessionCloseListener == null ? 43 : $sessionCloseListener.hashCode());
        SyncedStreamObserver $outputStream = this.getOutputStream();
        result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
        IntegrationContextComponent $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        Integration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        StreamObserver $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegrationGrpcSession(gson=" + String.valueOf(this.getGson()) + ", sessionId=" + String.valueOf(this.getSessionId()) + ", sessionOpenListener=" + String.valueOf(this.getSessionOpenListener()) + ", sessionCloseListener=" + String.valueOf(this.getSessionCloseListener()) + ", outputStream=" + String.valueOf(this.getOutputStream()) + ", ctx=" + String.valueOf(this.getCtx()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", inputStream=" + String.valueOf(this.getInputStream()) + ", connected=" + this.isConnected() + ", serviceId=" + this.getServiceId() + ")";
    }

    private /* synthetic */ Void lambda$saveEvent$0(TenantId tenantId, EntityId entityId, AttributeKvEntry attr, Void v) {
        this.ctx.getAttributesService().save(tenantId, entityId, AttributeScope.SERVER_SCOPE, Collections.singletonList(attr));
        return null;
    }
}

