/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.transport.activity.AbstractActivityManager;
import org.thingsboard.server.common.transport.activity.ActivityReportCallback;
import org.thingsboard.server.common.transport.activity.ActivityState;
import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategy;
import org.thingsboard.server.common.transport.activity.strategy.ActivityStrategyType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.integration.IntegrationActivityKey;

public abstract class IntegrationActivityManager
extends AbstractActivityManager<IntegrationActivityKey, Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationActivityManager.class);
    @Autowired
    protected PartitionService partitionService;
    @Autowired
    @Lazy
    protected TbQueueProducerProvider producerProvider;
    protected TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> tbCoreMsgProducer;
    @Value(value="${integrations.activity.reporting_period:3000}")
    private long reportingPeriodMillis;
    @Value(value="${integrations.activity.reporting_strategy:LAST}")
    private ActivityStrategyType reportingStrategyType;

    @PostConstruct
    public void init() {
        super.init();
        this.tbCoreMsgProducer = this.producerProvider.getTbCoreMsgProducer();
    }

    protected long getReportingPeriodMillis() {
        return this.reportingPeriodMillis;
    }

    protected ActivityStrategy getStrategy() {
        return this.reportingStrategyType.toStrategy();
    }

    protected ActivityState<Void> updateState(IntegrationActivityKey key, ActivityState<Void> state) {
        return state;
    }

    protected boolean hasExpired(long lastRecordedTime) {
        return this.getCurrentTimeMillis() - this.reportingPeriodMillis > lastRecordedTime;
    }

    protected void onStateExpiry(IntegrationActivityKey key, Void currentMetadata) {
    }

    protected void reportActivity(IntegrationActivityKey key, Void metadata, long timeToReport, ActivityReportCallback<IntegrationActivityKey> callback) {
        TenantId tenantId = key.getTenantId();
        DeviceId deviceId = key.getDeviceId();
        log.debug("[{}][{}] Reporting activity state. Time to report: [{}].", new Object[]{tenantId.getId(), deviceId.getId(), timeToReport});
        TransportProtos.ToCoreMsg toCoreMsg = this.buildActivityMsg(tenantId, deviceId, timeToReport);
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)deviceId);
        this.tbCoreMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(deviceId.getId(), (GeneratedMessageV3)toCoreMsg), (TbQueueCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private TransportProtos.ToCoreMsg buildActivityMsg(TenantId tenantId, DeviceId deviceId, long lastActivityTime) {
        UUID tenantUuid = tenantId.getId();
        UUID deviceUuid = deviceId.getId();
        TransportProtos.DeviceActivityProto deviceActivityMsg = TransportProtos.DeviceActivityProto.newBuilder().setTenantIdMSB(tenantUuid.getMostSignificantBits()).setTenantIdLSB(tenantUuid.getLeastSignificantBits()).setDeviceIdMSB(deviceUuid.getMostSignificantBits()).setDeviceIdLSB(deviceUuid.getLeastSignificantBits()).setLastActivityTime(lastActivityTime).build();
        return TransportProtos.ToCoreMsg.newBuilder().setDeviceActivityMsg(deviceActivityMsg).build();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

