/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.IntegrationId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.integration.IntegrationInfo;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.gen.MsgProtos;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TbMsgCallback;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.cache.CacheExecutorService;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.gen.integration.ConverterRequestProto;
import org.thingsboard.server.gen.integration.IntegrationApiRequestMsg;
import org.thingsboard.server.gen.integration.IntegrationApiResponseMsg;
import org.thingsboard.server.gen.integration.IntegrationInfoListRequestProto;
import org.thingsboard.server.gen.integration.IntegrationInfoListResponseProto;
import org.thingsboard.server.gen.integration.IntegrationInfoProto;
import org.thingsboard.server.gen.integration.IntegrationRequestProto;
import org.thingsboard.server.gen.integration.TenantProfileRequestProto;
import org.thingsboard.server.gen.integration.ToCoreIntegrationMsg;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueHandler;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.TbQueueResponseTemplate;
import org.thingsboard.server.queue.common.DefaultTbQueueResponseTemplate;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.integration.IntegrationApiCallback;
import org.thingsboard.server.service.integration.PlatformIntegrationService;
import org.thingsboard.server.service.integration.TbCoreIntegrationApiService;

@Service
@TbCoreComponent
public class DefaultTbCoreIntegrationApiService
implements TbCoreIntegrationApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCoreIntegrationApiService.class);
    private final TbCoreQueueFactory tbCoreQueueFactory;
    private final StatsFactory statsFactory;
    private final IntegrationService integrationService;
    private final ConverterService converterService;
    private final TbTenantProfileCache tenantProfileCache;
    private final PlatformIntegrationService platformIntegrationService;
    private final SecretConfigurationService secretConfigurationService;
    private final CacheExecutorService cacheExecutorService;
    @Value(value="${queue.integration_api.max_pending_requests:10000}")
    private int maxPendingRequests;
    @Value(value="${queue.integration_api.max_requests_timeout:10000}")
    private long requestTimeout;
    @Value(value="${queue.integration_api.request_poll_interval:25}")
    private int responsePollDuration;
    @Value(value="${queue.integration_api.max_callback_threads:10}")
    private int maxCallbackThreads;
    private ExecutorService integrationCallbackExecutor;
    private TbQueueResponseTemplate<TbProtoQueueMsg<IntegrationApiRequestMsg>, TbProtoQueueMsg<IntegrationApiResponseMsg>> integrationApiTemplate;

    @PostConstruct
    public void init() {
        this.integrationCallbackExecutor = ThingsBoardExecutors.newWorkStealingPool((int)this.maxCallbackThreads, this.getClass());
        TbQueueProducer producer = this.tbCoreQueueFactory.createIntegrationApiResponseProducer();
        TbQueueConsumer consumer = this.tbCoreQueueFactory.createIntegrationApiRequestConsumer();
        String key = StatsType.INTEGRATION.getName();
        MessagesStats queueStats = this.statsFactory.createMessagesStats(key);
        DefaultTbQueueResponseTemplate.DefaultTbQueueResponseTemplateBuilder builder = DefaultTbQueueResponseTemplate.builder();
        builder.requestTemplate(consumer);
        builder.responseTemplate(producer);
        builder.maxPendingRequests(this.maxPendingRequests);
        builder.requestTimeout(this.requestTimeout);
        builder.pollInterval((long)this.responsePollDuration);
        builder.executor(this.integrationCallbackExecutor);
        builder.stats(queueStats);
        this.integrationApiTemplate = builder.build();
    }

    @AfterStartUp(order=11)
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        log.info("Received application ready event. Starting polling for events.");
        this.integrationApiTemplate.subscribe();
        this.integrationApiTemplate.launch((TbQueueHandler)this);
    }

    @PreDestroy
    public void destroy() {
        if (this.integrationApiTemplate != null) {
            this.integrationApiTemplate.stop();
        }
        if (this.integrationCallbackExecutor != null) {
            this.integrationCallbackExecutor.shutdownNow();
        }
    }

    public ListenableFuture<TbProtoQueueMsg<IntegrationApiResponseMsg>> handle(TbProtoQueueMsg<IntegrationApiRequestMsg> tbProtoQueueMsg) {
        IntegrationApiRequestMsg integrationApiRequest = (IntegrationApiRequestMsg)tbProtoQueueMsg.getValue();
        ListenableFuture result = null;
        if (integrationApiRequest.hasIntegrationListRequest()) {
            result = this.handleListRequest(integrationApiRequest.getIntegrationListRequest());
        } else if (integrationApiRequest.hasIntegrationRequest()) {
            result = this.handleIntegrationRequest(integrationApiRequest.getIntegrationRequest());
        } else if (integrationApiRequest.hasConverterRequest()) {
            result = this.handleConverterRequest(integrationApiRequest.getConverterRequest());
        } else if (integrationApiRequest.hasTenantProfileRequest()) {
            result = this.handleTenantProfileRequest(integrationApiRequest.getTenantProfileRequest());
        } else {
            throw new RuntimeException("Not Implemented!");
        }
        return Futures.transform((ListenableFuture)result, value -> new TbProtoQueueMsg(tbProtoQueueMsg.getKey(), (GeneratedMessageV3)value, tbProtoQueueMsg.getHeaders()), (Executor)MoreExecutors.directExecutor());
    }

    public void handle(Collection<TbProtoQueueMsg<ToCoreIntegrationMsg>> msgs, TbCallback callback) {
        ArrayList<Pair> futures = new ArrayList<Pair>(msgs.size());
        for (TbProtoQueueMsg<ToCoreIntegrationMsg> msg : msgs) {
            try {
                ListenableFuture future = this.cacheExecutorService.executeAsync(() -> this.handle(msg, TbCallback.EMPTY));
                futures.add(Pair.of(msg, (Object)future));
            }
            catch (Throwable e) {
                log.warn("Failed to process integration msg: {}", msg, (Object)e);
            }
        }
        for (Pair future : futures) {
            try {
                ((Runnable)((ListenableFuture)future.getSecond()).get(20L, TimeUnit.SECONDS)).run();
            }
            catch (Throwable e) {
                log.warn("Failed to process integration msg: {}", future.getFirst(), (Object)e);
            }
        }
        callback.onSuccess();
    }

    Runnable handle(TbProtoQueueMsg<ToCoreIntegrationMsg> envelope, TbCallback callback) {
        ToCoreIntegrationMsg msg = (ToCoreIntegrationMsg)envelope.getValue();
        if (msg.hasIntegration()) {
            IntegrationInfo info = ProtoUtils.fromProto((IntegrationInfoProto)msg.getIntegration());
            if (msg.hasDeviceUplinkProto()) {
                return this.platformIntegrationService.processUplinkData((AbstractIntegration)info, msg.getDeviceUplinkProto(), (IntegrationCallback)new IntegrationApiCallback(callback));
            }
            if (msg.hasAssetUplinkProto()) {
                return this.platformIntegrationService.processUplinkData((AbstractIntegration)info, msg.getAssetUplinkProto(), (IntegrationCallback)new IntegrationApiCallback(callback));
            }
            if (msg.hasEntityViewDataProto()) {
                return this.platformIntegrationService.processUplinkData((AbstractIntegration)info, msg.getEntityViewDataProto(), (IntegrationCallback)new IntegrationApiCallback(callback));
            }
            if (!msg.getCustomTbMsg().isEmpty()) {
                return () -> this.platformIntegrationService.processUplinkData((AbstractIntegration)info, TbMsg.fromProto(null, (MsgProtos.TbMsgProto)msg.getCustomTbMsgProto(), (ByteString)msg.getCustomTbMsg(), (TbMsgCallback)TbMsgCallback.EMPTY), new IntegrationApiCallback(callback));
            }
            callback.onFailure((Throwable)new RuntimeException("Empty or not supported ToCoreIntegrationMsg!"));
        } else {
            if (msg.hasEventProto()) {
                return () -> this.platformIntegrationService.processUplinkData(msg.getEventProto(), new IntegrationApiCallback(callback));
            }
            if (msg.hasTsDataProto()) {
                return () -> this.platformIntegrationService.processUplinkData(msg.getTsDataProto(), new IntegrationApiCallback(callback));
            }
            callback.onFailure((Throwable)new IllegalArgumentException("Unsupported integration msg!"));
        }
        return () -> {};
    }

    private ListenableFuture<IntegrationApiResponseMsg> handleConverterRequest(ConverterRequestProto request) {
        ConverterId converterId = new ConverterId(new UUID(request.getConverterIdMSB(), request.getConverterIdLSB()));
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(request.getTenantIdMSB(), request.getTenantIdLSB()));
        ListenableFuture future = this.converterService.findConverterByIdAsync(tenantId, converterId);
        return Futures.transform((ListenableFuture)future, converter -> IntegrationApiResponseMsg.newBuilder().setConverterResponse(ProtoUtils.toProto((Converter)converter)).build(), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<IntegrationApiResponseMsg> handleIntegrationRequest(IntegrationRequestProto request) {
        ListenableFuture future;
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(request.getTenantIdMSB(), request.getTenantIdLSB()));
        if (request.getIntegrationIdMSB() != 0L || request.getIntegrationIdLSB() != 0L) {
            IntegrationId integrationId = new IntegrationId(new UUID(request.getIntegrationIdMSB(), request.getIntegrationIdLSB()));
            future = this.integrationService.findIntegrationByIdAsync(tenantId, integrationId);
        } else {
            future = StringUtils.isNotEmpty((String)request.getRoutingKey()) ? Futures.transform((ListenableFuture)Futures.immediateFuture((Object)this.integrationService.findIntegrationByRoutingKey(tenantId, request.getRoutingKey())), opt -> opt.orElse(null), (Executor)MoreExecutors.directExecutor()) : Futures.immediateFailedFuture((Throwable)new RuntimeException("Invalid request parameters!"));
        }
        return Futures.transform((ListenableFuture)future, integration -> {
            IntegrationApiResponseMsg.Builder builder = IntegrationApiResponseMsg.newBuilder();
            if (integration != null) {
                Integration copy = new Integration(integration);
                this.secretConfigurationService.replaceSecretUsages(tenantId, copy.getConfiguration());
                builder.setIntegrationResponse(ProtoUtils.toProto((Integration)copy));
            }
            return builder.build();
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<IntegrationApiResponseMsg> handleListRequest(IntegrationInfoListRequestProto request) {
        IntegrationType integrationType = IntegrationType.valueOf((String)request.getType());
        List data = this.integrationService.findAllCoreIntegrationInfos(integrationType, false, request.getEnabled());
        List integrationInfoList = data.stream().map(ProtoUtils::toProto).collect(Collectors.toList());
        return Futures.immediateFuture((Object)IntegrationApiResponseMsg.newBuilder().setIntegrationListResponse(IntegrationInfoListResponseProto.newBuilder().addAllIntegrationInfoList(integrationInfoList).build()).build());
    }

    private ListenableFuture<IntegrationApiResponseMsg> handleTenantProfileRequest(TenantProfileRequestProto request) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(request.getTenantIdMSB(), request.getTenantIdLSB()));
        TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
        return Futures.immediateFuture((Object)IntegrationApiResponseMsg.newBuilder().setTenantProfileResponse(ProtoUtils.toProto((TenantProfile)tenantProfile)).build());
    }

    @ConstructorProperties(value={"tbCoreQueueFactory", "statsFactory", "integrationService", "converterService", "tenantProfileCache", "platformIntegrationService", "secretConfigurationService", "cacheExecutorService"})
    @Generated
    public DefaultTbCoreIntegrationApiService(TbCoreQueueFactory tbCoreQueueFactory, StatsFactory statsFactory, IntegrationService integrationService, ConverterService converterService, TbTenantProfileCache tenantProfileCache, PlatformIntegrationService platformIntegrationService, SecretConfigurationService secretConfigurationService, CacheExecutorService cacheExecutorService) {
        this.tbCoreQueueFactory = tbCoreQueueFactory;
        this.statsFactory = statsFactory;
        this.integrationService = integrationService;
        this.converterService = converterService;
        this.tenantProfileCache = tenantProfileCache;
        this.platformIntegrationService = platformIntegrationService;
        this.secretConfigurationService = secretConfigurationService;
        this.cacheExecutorService = cacheExecutorService;
    }
}

