/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasEntityType;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.service.install.update.PaginatedUpdater;

public abstract class EntityGroupAllPaginatedUpdater<I extends UUIDBased, D extends BaseData<I> & HasCustomerId>
extends PaginatedUpdater<TenantId, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityGroupAllPaginatedUpdater.class);
    protected final EntityGroup groupAll;
    private final CustomerService customerService;
    private final EntityGroupService entityGroupService;
    private final boolean fetchAllTenantEntities;
    private final BiFunction<TenantId, PageLink, PageData<D>> findAllTenantEntitiesFunction;
    private final BiFunction<TenantId, List<I>, ListenableFuture<List<D>>> idsToEntitiesAsyncFunction;
    private final Function<EntityId, I> toIdFunction;
    private final Function<D, EntityId> getEntityIdFunction;
    private Map<CustomerId, Optional<EntityGroupId>> customersGroupMap = new HashMap();

    public EntityGroupAllPaginatedUpdater(CustomerService customerService, EntityGroupService entityGroupService, EntityGroup groupAll, boolean fetchAllTenantEntities, BiFunction<TenantId, PageLink, PageData<D>> findAllTenantEntitiesFunction, BiFunction<TenantId, List<I>, ListenableFuture<List<D>>> idsToEntitiesAsyncFunction, Function<EntityId, I> toIdFunction, Function<D, EntityId> getEntityIdFunction) {
        this.customerService = customerService;
        this.entityGroupService = entityGroupService;
        this.groupAll = groupAll;
        this.fetchAllTenantEntities = fetchAllTenantEntities;
        this.findAllTenantEntitiesFunction = findAllTenantEntitiesFunction;
        this.idsToEntitiesAsyncFunction = idsToEntitiesAsyncFunction;
        this.toIdFunction = toIdFunction;
        this.getEntityIdFunction = getEntityIdFunction;
    }

    protected PageData<D> findEntities(TenantId id, PageLink pageLink) {
        if (this.fetchAllTenantEntities) {
            return (PageData)this.findAllTenantEntitiesFunction.apply(id, pageLink);
        }
        try {
            List entityIds = (List)this.entityGroupService.findAllEntityIdsAsync(TenantId.SYS_TENANT_ID, this.groupAll.getId(), new PageLink(Integer.MAX_VALUE)).get();
            List ids = entityIds.stream().map(entityId -> (UUIDBased)this.toIdFunction.apply(entityId)).collect(Collectors.toList());
            List entities = !ids.isEmpty() ? (List)((ListenableFuture)this.idsToEntitiesAsyncFunction.apply(id, ids)).get() : Collections.emptyList();
            return new PageData(entities, 1, (long)entities.size(), false);
        }
        catch (Exception e) {
            log.error("Failed to get entities from group all!", (Throwable)e);
            throw new RuntimeException("Failed to get entities from group all!", e);
        }
    }

    protected void updateEntity(D entity) {
        EntityId entityId = (EntityId)this.getEntityIdFunction.apply(entity);
        this.entityGroupService.addEntityToEntityGroupAll(TenantId.SYS_TENANT_ID, (EntityId)((HasTenantId)entity).getTenantId(), entityId);
        if (((HasCustomerId)entity).getCustomerId() != null && !((HasCustomerId)entity).getCustomerId().isNullUid()) {
            Optional customerEntityGroupId = this.customersGroupMap.computeIfAbsent(((HasCustomerId)entity).getCustomerId(), customerId -> {
                Customer customer = this.customerService.findCustomerById(((HasTenantId)entity).getTenantId(), customerId);
                if (customer != null) {
                    EntityGroupId entityGroupId = this.entityGroupService.findOrCreateReadOnlyEntityGroupForCustomer(((HasTenantId)entity).getTenantId(), customerId, ((HasEntityType)entity).getEntityType()).getId();
                    return Optional.of(entityGroupId);
                }
                return Optional.empty();
            });
            if (customerEntityGroupId.isPresent()) {
                this.entityGroupService.addEntityToEntityGroup(TenantId.SYS_TENANT_ID, (EntityGroupId)customerEntityGroupId.get(), entityId);
            }
            this.unassignFromCustomer(entity);
        }
    }

    protected abstract void unassignFromCustomer(D var1);
}

