/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.SecretType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.FilterPredicateValue;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.secret.Secret;
import org.thingsboard.server.common.data.sync.vc.RepositoryAuthMethod;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cloud.EdgeSettingsService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.encryptionkey.EncryptionService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.secret.SecretService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.component.RuleNodeClassInfo;
import org.thingsboard.server.service.install.DbUpgradeExecutorService;
import org.thingsboard.server.service.install.SystemDataLoaderService;
import org.thingsboard.server.service.install.update.DataUpdateService;
import org.thingsboard.server.service.install.update.PaginatedUpdater;
import org.thingsboard.server.utils.TbNodeUpgradeUtils;

@Service
@Profile(value={"install"})
public class DefaultDataUpdateService
implements DataUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDataUpdateService.class);
    private static final int MAX_PENDING_SAVE_RULE_NODE_FUTURES = 256;
    private static final int DEFAULT_PAGE_SIZE = 1024;
    private static final int DEFAULT_LIMIT = 100;
    private final TenantService tenantService;
    private final RelationService relationService;
    private final RuleChainService ruleChainService;
    private final IntegrationService integrationService;
    private final EntityGroupService entityGroupService;
    private final UserService userService;
    private final WhiteLabelingService whiteLabelingService;
    private final CustomerService customerService;
    private final AssetService assetService;
    private final DeviceService deviceService;
    private final DashboardService dashboardService;
    private final EntityViewService entityViewService;
    private final EdgeService edgeService;
    private final SystemDataLoaderService systemDataLoaderService;
    private final WidgetsBundleService widgetsBundleService;
    private final EdgeSettingsService edgeSettingsService;
    private final ComponentDiscoveryService componentDiscoveryService;
    private final DbUpgradeExecutorService executorService;
    private final AttributesService attributesService;
    private final AdminSettingsService adminSettingsService;
    private final SecretService secretService;
    private final EncryptionService encryptionService;
    private PaginatedUpdater<String, Tenant> tenantsCustomersGroupAllUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private PaginatedUpdater<String, Tenant> tenantEntitiesGroupAllUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private PaginatedUpdater<String, Tenant> tenantIntegrationUpdater = new /* Unavailable Anonymous Inner Class!! */;
    private final PaginatedUpdater<String, Tenant> tenantsFullSyncRequiredUpdater = new /* Unavailable Anonymous Inner Class!! */;

    public void updateData(boolean fromCe) throws Exception {
        log.info("Updating data ...");
        if (fromCe) {
            this.updateDataFromCe();
        } else {
            this.encryptionService.createEncryptionKey(TenantId.SYS_TENANT_ID);
            this.migrateTenantAttributeSettingsToAdminSettings();
            this.migrateSensitiveSettingsToUseSecrets();
        }
        this.tenantsFullSyncRequiredUpdater.updateEntities(null);
        log.info("Data updated.");
    }

    private void updateDataFromCe() throws Exception {
        this.tenantsCustomersGroupAllUpdater.updateEntities();
        this.tenantEntitiesGroupAllUpdater.updateEntities();
        this.tenantIntegrationUpdater.updateEntities();
        JsonNode mailTemplatesSettings = this.whiteLabelingService.findMailTemplatesByTenantId(TenantId.SYS_TENANT_ID, TenantId.SYS_TENANT_ID);
        if (mailTemplatesSettings.isEmpty()) {
            this.systemDataLoaderService.loadMailTemplates();
        } else {
            this.systemDataLoaderService.updateMailTemplates(mailTemplatesSettings);
        }
    }

    private void migrateTenantAttributeSettingsToAdminSettings() {
        log.info("Starting migration of tenant attribute settings to admin_settings...");
        List<String> migratedKeys = List.of("mail", "sms", "jwt", "twoFaSettings");
        PageDataIterable tenantIds = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 1024);
        for (TenantId tenantId : tenantIds) {
            try {
                List attributeKvEntries = (List)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, migratedKeys).get(30L, TimeUnit.SECONDS);
                if (attributeKvEntries.isEmpty()) continue;
                ArrayList<String> migratedForTenant = new ArrayList<String>(attributeKvEntries.size());
                for (AttributeKvEntry entry : attributeKvEntries) {
                    String key = entry.getKey();
                    if (this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, key) != null) {
                        log.debug("Skipping migration of [{}] for tenant {}: already exists", (Object)key, (Object)tenantId);
                        continue;
                    }
                    try {
                        JsonNode jsonValue = JacksonUtil.toJsonNode((String)entry.getValueAsString());
                        AdminSettings adminSettings = new AdminSettings();
                        adminSettings.setTenantId(tenantId);
                        adminSettings.setKey(key);
                        adminSettings.setJsonValue(jsonValue);
                        this.adminSettingsService.saveAdminSettings(tenantId, adminSettings);
                        migratedForTenant.add(key);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Failed to parse/migrate attribute [{}]", new Object[]{tenantId, key, e});
                    }
                }
                if (migratedForTenant.isEmpty()) continue;
                this.attributesService.removeAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, migratedForTenant).get(30L, TimeUnit.SECONDS);
                log.info("[{}] tenant : migrated keys {}", (Object)tenantId, migratedForTenant);
            }
            catch (Exception e) {
                log.error("Failed to find attribute for tenant {}", (Object)tenantId, (Object)e);
            }
        }
        log.info("Tenant attribute settings migration fully completed.");
    }

    private void migrateSensitiveSettingsToUseSecrets() {
        this.migrateMailSettingsToSecrets(TenantId.SYS_TENANT_ID);
        PageDataIterable tenantIds = new PageDataIterable(arg_0 -> ((TenantService)this.tenantService).findTenantsIds(arg_0), 1024);
        for (TenantId tenantId : tenantIds) {
            this.migrateVersionControlSettingsToSecrets(tenantId);
            this.migrateMailSettingsToSecrets(tenantId);
        }
        log.info("Tenant sensitive settings migration to secrets fully completed.");
    }

    private void migrateVersionControlSettingsToSecrets(TenantId tenantId) {
        try {
            AdminSettings versionControl = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, "entitiesVersionControl");
            if (versionControl == null) {
                return;
            }
            RepositorySettings settings = (RepositorySettings)JacksonUtil.convertValue((Object)versionControl.getJsonValue(), RepositorySettings.class);
            if (settings == null) {
                return;
            }
            String description = "Auto-generated from version control settings.";
            if (settings.getAuthMethod() == RepositoryAuthMethod.USERNAME_PASSWORD) {
                if (!this.isSecretPlaceholder(settings.getPassword()) && StringUtils.isNotBlank((String)settings.getPassword())) {
                    String password = this.createSecretAsPlaceholder(tenantId, "Git repository password", settings.getPassword(), SecretType.TEXT, description);
                    settings.setPassword(password);
                }
            } else {
                if (!this.isSecretPlaceholder(settings.getPrivateKeyPassword()) && StringUtils.isNotBlank((String)settings.getPrivateKeyPassword())) {
                    String passphrase = this.createSecretAsPlaceholder(tenantId, "Git repository private key passphrase", settings.getPrivateKeyPassword(), SecretType.TEXT, description);
                    settings.setPrivateKeyPassword(passphrase);
                }
                if (!this.isSecretPlaceholder(settings.getPrivateKey()) && StringUtils.isNotBlank((String)settings.getPrivateKey())) {
                    String file = this.createSecretAsPlaceholder(tenantId, "Git repository private key", settings.getPrivateKey(), SecretType.TEXT_FILE, description);
                    settings.setPrivateKey(file);
                }
            }
            JsonNode jsonNode = JacksonUtil.valueToTree((Object)settings);
            versionControl.setJsonValue(jsonNode);
            this.adminSettingsService.saveAdminSettings(tenantId, versionControl);
        }
        catch (Exception e) {
            log.error("Failed to migrate version control settings to secrets storage for tenant {}", (Object)tenantId, (Object)e);
        }
    }

    private void migrateMailSettingsToSecrets(TenantId tenantId) {
        try {
            AdminSettings mail = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, "mail");
            if (mail == null) {
                return;
            }
            ObjectNode config = JacksonUtil.asObject((JsonNode)mail.getJsonValue());
            JsonNode password = config.get("password");
            if (password != null && !password.isNull() && StringUtils.isNotBlank((String)password.asText()) && !this.isSecretPlaceholder(password.asText())) {
                String description = "Auto-generated from mail settings.";
                String placeholder = this.createSecretAsPlaceholder(tenantId, "Mail server password", password.asText(), SecretType.TEXT, description);
                config.put("password", placeholder);
                mail.setJsonValue((JsonNode)config);
                this.adminSettingsService.saveAdminSettings(tenantId, mail);
            }
        }
        catch (Exception e) {
            log.error("Failed to migrate mail settings to secrets storage for tenant {}", (Object)tenantId, (Object)e);
        }
    }

    private String createSecretAsPlaceholder(TenantId tenantId, String baseName, String value, SecretType type, String description) {
        Object name = baseName;
        int counter = 1;
        while (this.secretService.findSecretInfoByName(tenantId, (String)name) != null) {
            name = baseName + " (" + counter++ + ")";
        }
        Secret secret = new Secret();
        secret.setTenantId(tenantId);
        secret.setName((String)name);
        secret.setValue(value);
        secret.setType(type);
        secret.setDescription(description);
        Secret secretInfo = this.secretService.saveSecret(tenantId, secret);
        return String.format("${secret:%s;type:%s}", secretInfo.getName(), secretInfo.getType());
    }

    private boolean isSecretPlaceholder(String value) {
        return StringUtils.isNotBlank((String)value) && value.startsWith("${secret:") && value.endsWith("}");
    }

    public void upgradeRuleNodes() {
        int totalRuleNodesUpgraded = 0;
        log.info("Starting rule nodes upgrade ...");
        List nodeClassToVersionMap = this.componentDiscoveryService.getVersionedNodes();
        log.debug("Found {} versioned nodes to check for upgrade!", (Object)nodeClassToVersionMap.size());
        for (RuleNodeClassInfo ruleNodeClassInfo : nodeClassToVersionMap) {
            String ruleNodeTypeForLogs = ruleNodeClassInfo.getSimpleName();
            int toVersion = ruleNodeClassInfo.getCurrentVersion();
            try {
                log.debug("Going to check for nodes with type: {} to upgrade to version: {}.", (Object)ruleNodeTypeForLogs, (Object)toVersion);
                List ruleNodesIdsToUpgrade = this.getRuleNodesIdsWithTypeAndVersionLessThan(ruleNodeClassInfo.getClassName(), toVersion);
                if (ruleNodesIdsToUpgrade.isEmpty()) {
                    log.debug("There are no active nodes with type {}, or all nodes with this type already set to latest version!", (Object)ruleNodeTypeForLogs);
                    continue;
                }
                List ruleNodeIdsPartitions = Lists.partition((List)ruleNodesIdsToUpgrade, (int)256);
                for (List ruleNodePack : ruleNodeIdsPartitions) {
                    log.info("{} upgraded rule nodes so far ...", (Object)(totalRuleNodesUpgraded += this.processRuleNodePack(ruleNodePack, ruleNodeClassInfo)));
                }
            }
            catch (Exception e) {
                log.error("Unexpected error during {} rule nodes upgrade: ", (Object)ruleNodeTypeForLogs, (Object)e);
            }
        }
        log.info("Finished rule nodes upgrade. Upgraded rule nodes count: {}", (Object)totalRuleNodesUpgraded);
    }

    private int processRuleNodePack(List<RuleNodeId> ruleNodeIdsBatch, RuleNodeClassInfo ruleNodeClassInfo) {
        ArrayList<ListenableFuture> saveFutures = new ArrayList<ListenableFuture>(256);
        String ruleNodeType = ruleNodeClassInfo.getSimpleName();
        int toVersion = ruleNodeClassInfo.getCurrentVersion();
        List ruleNodesPack = this.ruleChainService.findAllRuleNodesByIds(ruleNodeIdsBatch);
        for (RuleNode ruleNode : ruleNodesPack) {
            if (ruleNode == null) continue;
            RuleNodeId ruleNodeId = ruleNode.getId();
            int fromVersion = ruleNode.getConfigurationVersion();
            log.debug("Going to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
            try {
                TbNodeUpgradeUtils.upgradeConfigurationAndVersion((RuleNode)ruleNode, (RuleNodeClassInfo)ruleNodeClassInfo);
                saveFutures.add(this.executorService.submit(() -> {
                    this.ruleChainService.saveRuleNode(TenantId.SYS_TENANT_ID, ruleNode);
                    log.debug("Successfully upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
                }));
            }
            catch (Exception e) {
                log.warn("Failed to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {} due to: ", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion, e});
            }
        }
        try {
            return ((List)Futures.allAsList(saveFutures).get()).size();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to process save rule nodes requests due to: ", e);
        }
    }

    private List<RuleNodeId> getRuleNodesIdsWithTypeAndVersionLessThan(String type, int toVersion) {
        ArrayList<RuleNodeId> ruleNodeIds = new ArrayList<RuleNodeId>();
        new PageDataIterable(pageLink -> this.ruleChainService.findAllRuleNodeIdsByTypeAndVersionLessThan(type, toVersion, pageLink), 1024).forEach(ruleNodeIds::add);
        return ruleNodeIds;
    }

    boolean convertDeviceProfileForVersion330(JsonNode profileData) {
        boolean isUpdated = false;
        if (profileData.has("alarms") && !profileData.get("alarms").isNull()) {
            JsonNode alarms = profileData.get("alarms");
            for (JsonNode alarm : alarms) {
                JsonNode spec;
                if (alarm.has("createRules")) {
                    JsonNode createRules = alarm.get("createRules");
                    for (AlarmSeverity severity : AlarmSeverity.values()) {
                        JsonNode spec2;
                        if (!createRules.has(severity.name()) || !this.convertDeviceProfileAlarmRulesForVersion330(spec2 = createRules.get(severity.name()).get("condition").get("spec"))) continue;
                        isUpdated = true;
                    }
                }
                if (!alarm.has("clearRule") || alarm.get("clearRule").isNull() || !this.convertDeviceProfileAlarmRulesForVersion330(spec = alarm.get("clearRule").get("condition").get("spec"))) continue;
                isUpdated = true;
            }
        }
        return isUpdated;
    }

    private void updateTenantIntegrations(TenantId tenantId) {
        PageLink pageLink = new PageLink(100);
        PageData pageData = this.integrationService.findTenantIntegrations(tenantId, pageLink);
        boolean hasNext = true;
        while (hasNext) {
            for (Integration integration : pageData.getData()) {
                try {
                    Field enabledField = AbstractIntegration.class.getDeclaredField("enabled");
                    enabledField.setAccessible(true);
                    Boolean booleanVal = (Boolean)enabledField.get(integration);
                    if (booleanVal != null) continue;
                    integration.setEnabled(Boolean.valueOf(true));
                    this.integrationService.saveIntegration(integration);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (pageData.hasNext()) {
                pageLink = pageLink.nextPageLink();
                pageData = this.integrationService.findTenantIntegrations(tenantId, pageLink);
                continue;
            }
            hasNext = false;
        }
    }

    boolean convertDeviceProfileAlarmRulesForVersion330(JsonNode spec) {
        if (spec != null) {
            if (spec.has("type") && spec.get("type").asText().equals("DURATION")) {
                if (spec.has("value")) {
                    long value = spec.get("value").asLong();
                    FilterPredicateValue predicate = new FilterPredicateValue((Object)value, null, new DynamicValue(null, null, false));
                    ((ObjectNode)spec).remove("value");
                    ((ObjectNode)spec).putPOJO("predicate", (Object)predicate);
                    return true;
                }
            } else if (spec.has("type") && spec.get("type").asText().equals("REPEATING") && spec.has("count")) {
                int count = spec.get("count").asInt();
                FilterPredicateValue predicate = new FilterPredicateValue((Object)count, null, new DynamicValue(null, null, false));
                ((ObjectNode)spec).remove("count");
                ((ObjectNode)spec).putPOJO("predicate", (Object)predicate);
                return true;
            }
        }
        return false;
    }

    public static boolean getEnv(String name, boolean defaultValue) {
        String env = System.getenv(name);
        if (env == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(env);
    }

    private void fixDuplicateSystemWidgetsBundles() {
        try {
            List systemWidgetsBundles = this.widgetsBundleService.findSystemWidgetsBundles(TenantId.SYS_TENANT_ID);
            for (WidgetsBundle widgetsBundle : systemWidgetsBundles) {
                try {
                    this.widgetsBundleService.findWidgetsBundleByTenantIdAndAlias(TenantId.SYS_TENANT_ID, widgetsBundle.getAlias());
                }
                catch (IncorrectResultSizeDataAccessException e) {
                    for (WidgetsBundle systemWidgetsBundle : systemWidgetsBundles) {
                        if (!systemWidgetsBundle.getAlias().equals(widgetsBundle.getAlias())) continue;
                        this.widgetsBundleService.deleteWidgetsBundle(TenantId.SYS_TENANT_ID, systemWidgetsBundle.getId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to fix duplicate system widgets bundles", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"tenantService", "relationService", "ruleChainService", "integrationService", "entityGroupService", "userService", "whiteLabelingService", "customerService", "assetService", "deviceService", "dashboardService", "entityViewService", "edgeService", "systemDataLoaderService", "widgetsBundleService", "edgeSettingsService", "componentDiscoveryService", "executorService", "attributesService", "adminSettingsService", "secretService", "encryptionService"})
    @Generated
    public DefaultDataUpdateService(TenantService tenantService, RelationService relationService, RuleChainService ruleChainService, IntegrationService integrationService, EntityGroupService entityGroupService, UserService userService, WhiteLabelingService whiteLabelingService, CustomerService customerService, AssetService assetService, DeviceService deviceService, DashboardService dashboardService, EntityViewService entityViewService, EdgeService edgeService, SystemDataLoaderService systemDataLoaderService, WidgetsBundleService widgetsBundleService, EdgeSettingsService edgeSettingsService, ComponentDiscoveryService componentDiscoveryService, DbUpgradeExecutorService executorService, AttributesService attributesService, AdminSettingsService adminSettingsService, SecretService secretService, EncryptionService encryptionService) {
        this.tenantService = tenantService;
        this.relationService = relationService;
        this.ruleChainService = ruleChainService;
        this.integrationService = integrationService;
        this.entityGroupService = entityGroupService;
        this.userService = userService;
        this.whiteLabelingService = whiteLabelingService;
        this.customerService = customerService;
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.dashboardService = dashboardService;
        this.entityViewService = entityViewService;
        this.edgeService = edgeService;
        this.systemDataLoaderService = systemDataLoaderService;
        this.widgetsBundleService = widgetsBundleService;
        this.edgeSettingsService = edgeSettingsService;
        this.componentDiscoveryService = componentDiscoveryService;
        this.executorService = executorService;
        this.attributesService = attributesService;
        this.adminSettingsService = adminSettingsService;
        this.secretService = secretService;
        this.encryptionService = encryptionService;
    }
}

