/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.migrate;

import com.datastax.oss.driver.api.core.cql.Row;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.thingsboard.server.common.data.UUIDConverter;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumn;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumnType;

/*
 * Exception performing whole class analysis ignored.
 */
public class CassandraToSqlColumn {
    private static final ThreadLocal<Pattern> PATTERN_THREAD_LOCAL = ThreadLocal.withInitial(() -> Pattern.compile(String.valueOf('\u0000')));
    private static final String EMPTY_STR = "";
    private int index;
    private int sqlIndex;
    private String cassandraColumnName;
    private String sqlColumnName;
    private CassandraToSqlColumnType type;
    private int sqlType;
    private int size;
    private Class<? extends Enum> enumClass;
    private boolean allowNullBoolean = false;

    public static CassandraToSqlColumn idColumn(String name) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.ID);
    }

    public static CassandraToSqlColumn stringColumn(String name) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.STRING);
    }

    public static CassandraToSqlColumn stringColumn(String cassandraColumnName, String sqlColumnName) {
        return new CassandraToSqlColumn(cassandraColumnName, sqlColumnName);
    }

    public static CassandraToSqlColumn bigintColumn(String name) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.BIGINT);
    }

    public static CassandraToSqlColumn doubleColumn(String name) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.DOUBLE);
    }

    public static CassandraToSqlColumn booleanColumn(String name) {
        return CassandraToSqlColumn.booleanColumn((String)name, (boolean)false);
    }

    public static CassandraToSqlColumn booleanColumn(String name, boolean allowNullBoolean) {
        return new CassandraToSqlColumn(name, name, CassandraToSqlColumnType.BOOLEAN, null, allowNullBoolean);
    }

    public static CassandraToSqlColumn jsonColumn(String name) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.JSON);
    }

    public static CassandraToSqlColumn enumToIntColumn(String name, Class<? extends Enum> enumClass) {
        return new CassandraToSqlColumn(name, CassandraToSqlColumnType.ENUM_TO_INT, enumClass);
    }

    public CassandraToSqlColumn(String columnName) {
        this(columnName, columnName, CassandraToSqlColumnType.STRING, null, false);
    }

    public CassandraToSqlColumn(String columnName, CassandraToSqlColumnType type) {
        this(columnName, columnName, type, null, false);
    }

    public CassandraToSqlColumn(String columnName, CassandraToSqlColumnType type, Class<? extends Enum> enumClass) {
        this(columnName, columnName, type, enumClass, false);
    }

    public CassandraToSqlColumn(String cassandraColumnName, String sqlColumnName) {
        this(cassandraColumnName, sqlColumnName, CassandraToSqlColumnType.STRING, null, false);
    }

    public CassandraToSqlColumn(String cassandraColumnName, String sqlColumnName, CassandraToSqlColumnType type, Class<? extends Enum> enumClass, boolean allowNullBoolean) {
        this.cassandraColumnName = cassandraColumnName;
        this.sqlColumnName = sqlColumnName;
        this.type = type;
        this.enumClass = enumClass;
        this.allowNullBoolean = allowNullBoolean;
    }

    public String getColumnValue(Row row) {
        if (row.isNull(this.index)) {
            if (this.type == CassandraToSqlColumnType.BOOLEAN && !this.allowNullBoolean) {
                return Boolean.toString(false);
            }
            return null;
        }
        switch (1.$SwitchMap$org$thingsboard$server$service$install$migrate$CassandraToSqlColumnType[this.type.ordinal()]) {
            case 1: {
                return UUIDConverter.fromTimeUUID((UUID)row.getUuid(this.index));
            }
            case 2: {
                return Double.toString(row.getDouble(this.index));
            }
            case 3: {
                return Integer.toString(row.getInt(this.index));
            }
            case 4: {
                return Float.toString(row.getFloat(this.index));
            }
            case 5: {
                return Long.toString(row.getLong(this.index));
            }
            case 6: {
                return Boolean.toString(row.getBoolean(this.index));
            }
        }
        String value = row.getString(this.index);
        return this.replaceNullChars(value);
    }

    public void setColumnValue(PreparedStatement sqlInsertStatement, String value) throws SQLException {
        if (value == null) {
            sqlInsertStatement.setNull(this.sqlIndex, this.sqlType);
        } else {
            switch (1.$SwitchMap$org$thingsboard$server$service$install$migrate$CassandraToSqlColumnType[this.type.ordinal()]) {
                case 2: {
                    sqlInsertStatement.setDouble(this.sqlIndex, Double.parseDouble(value));
                    break;
                }
                case 3: {
                    sqlInsertStatement.setInt(this.sqlIndex, Integer.parseInt(value));
                    break;
                }
                case 4: {
                    sqlInsertStatement.setFloat(this.sqlIndex, Float.parseFloat(value));
                    break;
                }
                case 5: {
                    sqlInsertStatement.setLong(this.sqlIndex, Long.parseLong(value));
                    break;
                }
                case 6: {
                    sqlInsertStatement.setBoolean(this.sqlIndex, Boolean.parseBoolean(value));
                    break;
                }
                case 9: {
                    Object enumVal = Enum.valueOf(this.enumClass, value);
                    int intValue = ((Enum)enumVal).ordinal();
                    sqlInsertStatement.setInt(this.sqlIndex, intValue);
                    break;
                }
                default: {
                    sqlInsertStatement.setString(this.sqlIndex, value);
                }
            }
        }
    }

    private String replaceNullChars(String strValue) {
        if (strValue != null) {
            return ((Pattern)PATTERN_THREAD_LOCAL.get()).matcher(strValue).replaceAll("");
        }
        return strValue;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getSqlIndex() {
        return this.sqlIndex;
    }

    @Generated
    public String getCassandraColumnName() {
        return this.cassandraColumnName;
    }

    @Generated
    public String getSqlColumnName() {
        return this.sqlColumnName;
    }

    @Generated
    public CassandraToSqlColumnType getType() {
        return this.type;
    }

    @Generated
    public int getSqlType() {
        return this.sqlType;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public Class<? extends Enum> getEnumClass() {
        return this.enumClass;
    }

    @Generated
    public boolean isAllowNullBoolean() {
        return this.allowNullBoolean;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setSqlIndex(int sqlIndex) {
        this.sqlIndex = sqlIndex;
    }

    @Generated
    public void setCassandraColumnName(String cassandraColumnName) {
        this.cassandraColumnName = cassandraColumnName;
    }

    @Generated
    public void setSqlColumnName(String sqlColumnName) {
        this.sqlColumnName = sqlColumnName;
    }

    @Generated
    public void setType(CassandraToSqlColumnType type) {
        this.type = type;
    }

    @Generated
    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }

    @Generated
    public void setEnumClass(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    @Generated
    public void setAllowNullBoolean(boolean allowNullBoolean) {
        this.allowNullBoolean = allowNullBoolean;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraToSqlColumn)) {
            return false;
        }
        CassandraToSqlColumn other = (CassandraToSqlColumn)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getSqlIndex() != other.getSqlIndex()) {
            return false;
        }
        if (this.getSqlType() != other.getSqlType()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isAllowNullBoolean() != other.isAllowNullBoolean()) {
            return false;
        }
        String this$cassandraColumnName = this.getCassandraColumnName();
        String other$cassandraColumnName = other.getCassandraColumnName();
        if (this$cassandraColumnName == null ? other$cassandraColumnName != null : !this$cassandraColumnName.equals(other$cassandraColumnName)) {
            return false;
        }
        String this$sqlColumnName = this.getSqlColumnName();
        String other$sqlColumnName = other.getSqlColumnName();
        if (this$sqlColumnName == null ? other$sqlColumnName != null : !this$sqlColumnName.equals(other$sqlColumnName)) {
            return false;
        }
        CassandraToSqlColumnType this$type = this.getType();
        CassandraToSqlColumnType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Class this$enumClass = this.getEnumClass();
        Class other$enumClass = other.getEnumClass();
        return !(this$enumClass == null ? other$enumClass != null : !this$enumClass.equals(other$enumClass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CassandraToSqlColumn;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getSqlIndex();
        result = result * 59 + this.getSqlType();
        result = result * 59 + this.getSize();
        result = result * 59 + (this.isAllowNullBoolean() ? 79 : 97);
        String $cassandraColumnName = this.getCassandraColumnName();
        result = result * 59 + ($cassandraColumnName == null ? 43 : $cassandraColumnName.hashCode());
        String $sqlColumnName = this.getSqlColumnName();
        result = result * 59 + ($sqlColumnName == null ? 43 : $sqlColumnName.hashCode());
        CassandraToSqlColumnType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Class $enumClass = this.getEnumClass();
        result = result * 59 + ($enumClass == null ? 43 : $enumClass.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CassandraToSqlColumn(index=" + this.getIndex() + ", sqlIndex=" + this.getSqlIndex() + ", cassandraColumnName=" + this.getCassandraColumnName() + ", sqlColumnName=" + this.getSqlColumnName() + ", type=" + String.valueOf(this.getType()) + ", sqlType=" + this.getSqlType() + ", size=" + this.getSize() + ", enumClass=" + String.valueOf(this.getEnumClass()) + ", allowNullBoolean=" + this.isAllowNullBoolean() + ")";
    }
}

