/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLWarning;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.thingsboard.server.service.install.DatabaseEntitiesUpgradeService;
import org.thingsboard.server.service.install.InstallScripts;

@Service
@Profile(value={"install"})
public class SqlDatabaseUpgradeService
implements DatabaseEntitiesUpgradeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlDatabaseUpgradeService.class);
    private static final String SCHEMA_UPDATE_SQL = "schema_update.sql";
    private final InstallScripts installScripts;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    public SqlDatabaseUpgradeService(InstallScripts installScripts, JdbcTemplate jdbcTemplate, PlatformTransactionManager transactionManager) {
        this.installScripts = installScripts;
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setTimeout((int)TimeUnit.MINUTES.toSeconds(120L));
    }

    public void upgradeDatabase(boolean fromCe) {
        log.info("Updating schema...");
        if (fromCe) {
            this.loadSql(this.getSchemaUpdateFile("pe"));
        } else {
            this.loadSql(this.getSchemaUpdateFile("basic"));
        }
        log.info("Schema updated.");
    }

    private Path getSchemaUpdateFile(String version) {
        return Paths.get(this.installScripts.getDataDir(), "upgrade", version, SCHEMA_UPDATE_SQL);
    }

    private void loadSql(Path sqlFile) {
        String sql;
        try {
            sql = Files.readString(sqlFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.jdbcTemplate.execute(stmt -> {
            stmt.execute(sql);
            this.printWarnings(stmt.getWarnings());
            return null;
        });
    }

    private void execute(String ... statements) {
        for (String statement : statements) {
            this.execute(statement, true);
        }
    }

    private void execute(@Language(value="sql") String statement, boolean ignoreErrors) {
        block2: {
            try {
                this.jdbcTemplate.execute(statement);
            }
            catch (Exception e) {
                if (ignoreErrors) break block2;
                throw e;
            }
        }
    }

    private void printWarnings(SQLWarning warnings) {
        if (warnings != null) {
            log.info("{}", (Object)warnings.getMessage());
            for (SQLWarning nextWarning = warnings.getNextWarning(); nextWarning != null; nextWarning = nextWarning.getNextWarning()) {
                log.info("{}", (Object)nextWarning.getMessage());
            }
        }
    }
}

