/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class CalculatedFieldsDeletionTaskProcessor
extends HousekeeperTaskProcessor<HousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldsDeletionTaskProcessor.class);
    private final CalculatedFieldService calculatedFieldService;

    public void process(HousekeeperTask task) throws Exception {
        int deletedCount = this.calculatedFieldService.deleteAllCalculatedFieldsByEntityId(task.getTenantId(), task.getEntityId());
        log.debug("[{}][{}][{}] Deleted {} calculated fields", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), deletedCount});
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_CALCULATED_FIELDS;
    }

    @ConstructorProperties(value={"calculatedFieldService"})
    @Generated
    public CalculatedFieldsDeletionTaskProcessor(CalculatedFieldService calculatedFieldService) {
        this.calculatedFieldService = calculatedFieldService;
    }
}

