/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.oauth2client;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.oauth2client.TbOauth2ClientService;

@Service
public class DefaultTbOauth2ClientService
extends AbstractTbEntityService
implements TbOauth2ClientService {
    private final OAuth2ClientService oAuth2ClientService;

    public OAuth2Client save(OAuth2Client oAuth2Client, User user) throws Exception {
        ActionType actionType = oAuth2Client.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = oAuth2Client.getTenantId();
        try {
            OAuth2Client savedClient = (OAuth2Client)this.checkNotNull((Object)this.oAuth2ClientService.saveOAuth2Client(tenantId, oAuth2Client));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)((OAuth2ClientId)savedClient.getId()), (HasName)savedClient, actionType, user, new Object[0]);
            return savedClient;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.OAUTH2_CLIENT), (HasName)oAuth2Client, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(OAuth2Client oAuth2Client, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = oAuth2Client.getTenantId();
        OAuth2ClientId oAuth2ClientId = (OAuth2ClientId)oAuth2Client.getId();
        try {
            this.oAuth2ClientService.deleteOAuth2ClientById(tenantId, oAuth2ClientId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)oAuth2ClientId, (HasName)oAuth2Client, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)oAuth2ClientId, (HasName)oAuth2Client, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @ConstructorProperties(value={"oAuth2ClientService"})
    @Generated
    public DefaultTbOauth2ClientService(OAuth2ClientService oAuth2ClientService) {
        this.oAuth2ClientService = oAuth2ClientService;
    }
}

