/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.entity.group;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.group.EntityGroupInfo;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.entity.group.TbEntityGroupService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Service
@TbCoreComponent
public class DefaultEntityGroupService
extends AbstractTbEntityService
implements TbEntityGroupService {
    private final GroupPermissionService groupPermissionService;
    private final UserPermissionsService userPermissionsService;
    private final EntityGroupService entityGroupService;

    public EntityGroupInfo save(TenantId tenantId, EntityId parentEntityId, EntityGroup entityGroup, User user) throws Exception {
        ActionType actionType = entityGroup.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        try {
            EntityGroup savedEntityGroup = (EntityGroup)this.checkNotNull((Object)this.entityGroupService.saveEntityGroup(tenantId, parentEntityId, entityGroup));
            this.autoCommit(user, savedEntityGroup.getType(), savedEntityGroup.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedEntityGroup.getId(), (HasName)savedEntityGroup, null, actionType, user, new Object[0]);
            return (EntityGroupInfo)this.checkNotNull((Object)this.entityGroupService.findEntityGroupInfoById(tenantId, savedEntityGroup.getId()));
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_GROUP), (HasName)entityGroup, null, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(TenantId tenantId, EntityGroup entityGroup, User user) throws ThingsboardException {
        ActionType actionType = ActionType.DELETED;
        EntityGroupId entityGroupId = entityGroup.getId();
        try {
            this.entityGroupService.deleteEntityGroup(tenantId, entityGroupId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)entityGroupId, (HasName)entityGroup, null, actionType, user, new Object[]{entityGroupId.getId().toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ENTITY_GROUP), (HasName)entityGroup, null, actionType, user, e, new Object[]{entityGroupId.getId().toString()});
            throw e;
        }
    }

    public EntityId makePublic(TenantId tenantId, EntityGroup entityGroup, User user) throws ThingsboardException {
        this.checkPublicEntityGroupType(entityGroup.getType());
        if (entityGroup.isPublic()) {
            throw new ThingsboardException("Entity group is already public!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        GroupPermission groupPermission = new GroupPermission();
        groupPermission.setPublic(true);
        groupPermission.setTenantId(tenantId);
        EntityGroup publicUsers = this.customerService.findOrCreatePublicUserGroup(tenantId, user.getOwnerId());
        Role publicUserEntityGroupRole = this.customerService.findOrCreatePublicUserEntityGroupRole(tenantId, user.getOwnerId());
        groupPermission.setRoleId(publicUserEntityGroupRole.getId());
        groupPermission.setUserGroupId(publicUsers.getId());
        groupPermission.setEntityGroupId(entityGroup.getId());
        groupPermission.setEntityGroupType(entityGroup.getType());
        EntityId publicCustomerId = publicUsers.getOwnerId();
        JsonNode additionalInfo = entityGroup.getAdditionalInfo();
        if (additionalInfo == null || additionalInfo instanceof NullNode) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        ((ObjectNode)additionalInfo).put("isPublic", true);
        ((ObjectNode)additionalInfo).put("publicCustomerId", publicCustomerId.getId().toString());
        entityGroup.setAdditionalInfo(additionalInfo);
        GroupPermission savedGroupPermission = this.groupPermissionService.saveGroupPermission(tenantId, groupPermission);
        this.entityGroupService.saveEntityGroup(tenantId, entityGroup.getOwnerId(), entityGroup);
        this.userPermissionsService.onGroupPermissionUpdated(savedGroupPermission);
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)entityGroup.getId(), null, ActionType.MADE_PUBLIC, user, new Object[]{entityGroup.getId().toString(), entityGroup.getName()});
        return publicCustomerId;
    }

    public void makePrivate(TenantId tenantId, EntityGroup entityGroup, User user) throws ThingsboardException {
        JsonNode additionalInfo;
        this.checkPublicEntityGroupType(entityGroup.getType());
        if (!entityGroup.isPublic()) {
            throw new ThingsboardException("Entity group is not public!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        Optional groupPermission = this.groupPermissionService.findPublicGroupPermissionByTenantIdAndEntityGroupId(tenantId, entityGroup.getId());
        if (groupPermission.isPresent()) {
            EntityGroup updatedEntityGroup = this.groupPermissionService.deleteGroupPermission(tenantId, ((GroupPermission)groupPermission.get()).getId());
            if (updatedEntityGroup != null) {
                entityGroup = updatedEntityGroup;
            }
            this.userPermissionsService.onGroupPermissionDeleted((GroupPermission)groupPermission.get());
        }
        if ((additionalInfo = entityGroup.getAdditionalInfo()) == null) {
            additionalInfo = JacksonUtil.newObjectNode();
        }
        ((ObjectNode)additionalInfo).put("isPublic", false);
        ((ObjectNode)additionalInfo).put("publicCustomerId", "");
        entityGroup.setAdditionalInfo(additionalInfo);
        entityGroup = this.entityGroupService.saveEntityGroup(tenantId, entityGroup.getOwnerId(), entityGroup);
        this.logEntityActionService.logEntityAction(tenantId, (EntityId)entityGroup.getId(), null, ActionType.MADE_PRIVATE, user, new Object[]{entityGroup.getId().toString(), entityGroup.getName()});
    }

    private EntityType checkPublicEntityGroupType(EntityType groupType) throws ThingsboardException {
        if (groupType == null) {
            throw new ThingsboardException("EntityGroup type is required!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        if (groupType != EntityType.ASSET && groupType != EntityType.DEVICE && groupType != EntityType.ENTITY_VIEW && groupType != EntityType.EDGE && groupType != EntityType.DASHBOARD) {
            throw new ThingsboardException("Invalid entityGroup type '" + String.valueOf(groupType) + "'! Only entity groups of types 'ASSET', 'DEVICE', 'ENTITY_VIEW' or 'DASHBOARD' can be public.", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return groupType;
    }

    @ConstructorProperties(value={"groupPermissionService", "userPermissionsService", "entityGroupService"})
    @Generated
    public DefaultEntityGroupService(GroupPermissionService groupPermissionService, UserPermissionsService userPermissionsService, EntityGroupService entityGroupService) {
        this.groupPermissionService = groupPermissionService;
        this.userPermissionsService = userPermissionsService;
        this.entityGroupService = entityGroupService;
    }
}

