/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.domain;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.domain.Domain;
import org.thingsboard.server.common.data.id.DomainId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.domain.TbDomainService;

@Service
public class DefaultTbDomainService
extends AbstractTbEntityService
implements TbDomainService {
    private final DomainService domainService;

    public Domain save(Domain domain, List<OAuth2ClientId> oAuth2Clients, User user) throws Exception {
        ActionType actionType = domain.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = domain.getTenantId();
        try {
            Domain savedDomain = (Domain)this.checkNotNull((Object)this.domainService.saveDomain(tenantId, domain));
            if (CollectionUtils.isNotEmpty(oAuth2Clients)) {
                this.domainService.updateOauth2Clients(domain.getTenantId(), (DomainId)savedDomain.getId(), oAuth2Clients);
            }
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)((DomainId)savedDomain.getId()), (HasName)savedDomain, actionType, user, new Object[]{oAuth2Clients});
            return savedDomain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DOMAIN), (HasName)domain, actionType, user, e, new Object[]{oAuth2Clients});
            throw e;
        }
    }

    public void updateOauth2Clients(Domain domain, List<OAuth2ClientId> oAuth2ClientIds, User user) {
        ActionType actionType = ActionType.UPDATED;
        TenantId tenantId = domain.getTenantId();
        DomainId domainId = (DomainId)domain.getId();
        try {
            this.domainService.updateOauth2Clients(tenantId, domainId, oAuth2ClientIds);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)domainId, (HasName)domain, actionType, user, new Object[]{oAuth2ClientIds});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)domainId, (HasName)domain, actionType, user, e, new Object[]{oAuth2ClientIds});
            throw e;
        }
    }

    public void delete(Domain domain, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = domain.getTenantId();
        DomainId domainId = (DomainId)domain.getId();
        try {
            this.domainService.deleteDomainById(tenantId, domainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)domainId, (HasName)domain, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)domainId, (HasName)domain, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @ConstructorProperties(value={"domainService"})
    @Generated
    public DefaultTbDomainService(DomainService domainService) {
        this.domainService = domainService;
    }
}

