/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.cf;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.entitiy.cf.CalculatedFieldReprocessingValidator;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CalculatedFieldReprocessingValidator {
    public static final String NO_ARGUMENTS = "no arguments defined.";
    public static final String NO_TELEMETRY_ARGS = "at least one time series based argument ('Latest telemetry' or 'Time series rolling') should be specified.";
    public static final String NO_OUTPUT = "no output defined.";
    public static final String INVALID_OUTPUT_TYPE = "output type 'Attribute' is not supported.";
    private final JobService jobService;
    private final TbelInvokeService tbelInvokeService;
    private final ApiLimitService apiLimitService;

    public CfReprocessingValidationResult validate(CalculatedField calculatedField) {
        return this.checkJobStatus(calculatedField.getTenantId(), calculatedField.getId()).or(() -> this.checkArguments(calculatedField.getConfiguration().getArguments())).or(() -> this.checkExpression(calculatedField)).or(() -> this.checkOutput(calculatedField.getConfiguration().getOutput())).orElse(CfReprocessingValidationResult.valid());
    }

    private Optional<CfReprocessingValidationResult> checkJobStatus(TenantId tenantId, CalculatedFieldId calculatedFieldId) {
        Job job = this.jobService.findLatestJobByKey(tenantId, calculatedFieldId.getId().toString());
        if (job != null && job.getStatus().isOneOf(new JobStatus[]{JobStatus.QUEUED, JobStatus.PENDING, JobStatus.RUNNING})) {
            return Optional.of(CfReprocessingValidationResult.invalid((String)("Calculated field reprocessing is already " + job.getStatus().name().toLowerCase()), (JobStatus)job.getStatus()));
        }
        return Optional.empty();
    }

    private Optional<CfReprocessingValidationResult> checkArguments(Map<String, Argument> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return Optional.of(CfReprocessingValidationResult.invalid((String)"no arguments defined."));
        }
        boolean containsTelemetry = arguments.values().stream().anyMatch(arg -> ArgumentType.TS_LATEST.equals((Object)arg.getRefEntityKey().getType()) || ArgumentType.TS_ROLLING.equals((Object)arg.getRefEntityKey().getType()));
        if (!containsTelemetry) {
            return Optional.of(CfReprocessingValidationResult.invalid((String)"at least one time series based argument ('Latest telemetry' or 'Time series rolling') should be specified."));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CfReprocessingValidationResult> checkExpression(CalculatedField calculatedField) {
        CalculatedFieldCtx ctx = new CalculatedFieldCtx(calculatedField, this.tbelInvokeService, this.apiLimitService);
        try {
            ctx.init();
        }
        catch (Exception e) {
            Optional<CfReprocessingValidationResult> optional = Optional.of(CfReprocessingValidationResult.invalid((String)e.getMessage()));
            return optional;
        }
        finally {
            ctx.stop();
        }
        return Optional.empty();
    }

    private Optional<CfReprocessingValidationResult> checkOutput(Output output) {
        if (output == null) {
            return Optional.of(CfReprocessingValidationResult.invalid((String)"no output defined."));
        }
        if (OutputType.ATTRIBUTES.equals((Object)output.getType())) {
            return Optional.of(CfReprocessingValidationResult.invalid((String)"output type 'Attribute' is not supported."));
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"jobService", "tbelInvokeService", "apiLimitService"})
    @Generated
    public CalculatedFieldReprocessingValidator(JobService jobService, TbelInvokeService tbelInvokeService, ApiLimitService apiLimitService) {
        this.jobService = jobService;
        this.tbelInvokeService = tbelInvokeService;
        this.apiLimitService = apiLimitService;
    }
}

