/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.asset;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.asset.TbAssetService;

@Service
public class DefaultTbAssetService
extends AbstractTbEntityService
implements TbAssetService {
    private final AssetService assetService;

    public Asset save(Asset asset, EntityGroup entityGroup) throws Exception {
        return this.save(asset, entityGroup, null);
    }

    public Asset save(Asset asset, EntityGroup entityGroup, User user) throws Exception {
        return this.save(asset, entityGroup != null ? Collections.singletonList(entityGroup) : null, user);
    }

    public Asset save(Asset asset, List<EntityGroup> entityGroups, User user) throws Exception {
        ActionType actionType = asset.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = asset.getTenantId();
        try {
            Asset savedAsset = (Asset)this.checkNotNull((Object)this.assetService.saveAsset(asset));
            this.autoCommit(user, (EntityId)savedAsset.getId());
            this.createOrUpdateGroupEntity(tenantId, (GroupEntity)savedAsset, entityGroups, actionType, user);
            return savedAsset;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), (HasName)asset, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Transactional
    public void delete(Asset asset, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = asset.getTenantId();
        AssetId assetId = asset.getId();
        try {
            this.assetService.deleteAsset(tenantId, assetId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)assetId, (HasName)asset, asset.getCustomerId(), actionType, user, new Object[]{assetId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET), actionType, user, e, new Object[]{assetId.toString()});
            throw e;
        }
    }

    public void delete(AssetId assetId, User user) {
        Asset asset = this.assetService.findAssetById(user.getTenantId(), assetId);
        this.delete(asset, user);
    }

    @ConstructorProperties(value={"assetService"})
    @Generated
    public DefaultTbAssetService(AssetService assetService) {
        this.assetService = assetService;
    }
}

