/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.dao.alarm.AlarmCommentService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmCommentService;

@Service
public class DefaultTbAlarmCommentService
extends AbstractTbEntityService
implements TbAlarmCommentService {
    @Autowired
    private AlarmCommentService alarmCommentService;

    public AlarmComment saveAlarmComment(Alarm alarm, AlarmComment alarmComment, User user) throws ThingsboardException {
        ActionType actionType;
        ActionType actionType2 = actionType = alarmComment.getId() == null ? ActionType.ADDED_COMMENT : ActionType.UPDATED_COMMENT;
        if (user != null) {
            alarmComment.setUserId(user.getId());
        }
        try {
            AlarmComment savedAlarmComment = (AlarmComment)this.checkNotNull((Object)this.alarmCommentService.createOrUpdateAlarmComment(alarm.getTenantId(), alarmComment));
            this.logEntityActionService.logEntityAction(alarm.getTenantId(), (EntityId)alarm.getId(), (HasName)alarm, alarm.getCustomerId(), actionType, user, new Object[]{savedAlarmComment});
            return savedAlarmComment;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(alarm.getTenantId(), this.emptyId(EntityType.ALARM), (HasName)alarm, actionType, user, e, new Object[]{alarmComment});
            throw e;
        }
    }

    public void deleteAlarmComment(Alarm alarm, AlarmComment alarmComment, User user) throws ThingsboardException {
        if (alarmComment.getType() != AlarmCommentType.OTHER) {
            throw new ThingsboardException("System comment could not be deleted", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        alarmComment.setType(AlarmCommentType.SYSTEM);
        alarmComment.setUserId(null);
        alarmComment.setComment((JsonNode)JacksonUtil.newObjectNode().put("text", String.format("User %s deleted his comment", user.getFirstName() == null || user.getLastName() == null ? user.getName() : user.getFirstName() + " " + user.getLastName())));
        AlarmComment savedAlarmComment = (AlarmComment)this.checkNotNull((Object)this.alarmCommentService.saveAlarmComment(alarm.getTenantId(), alarmComment));
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), (EntityId)alarm.getId(), (HasName)alarm, alarm.getCustomerId(), ActionType.DELETED_COMMENT, user, new Object[]{savedAlarmComment});
    }

    @ConstructorProperties(value={"alarmCommentService"})
    @Generated
    public DefaultTbAlarmCommentService(AlarmCommentService alarmCommentService) {
        this.alarmCommentService = alarmCommentService;
    }
}

